/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.easing;

import it.sephiroth.android.library.easing.Easing;

public class Elastic
implements Easing {
    @Override
    public double easeIn(double time, double start, double end, double duration) {
        return this.easeIn(time, start, end, duration, start + end, duration);
    }

    public double easeIn(double t, double b, double c, double d, double a, double p) {
        double s;
        if (t == 0.0) {
            return b;
        }
        if ((t /= d) == 1.0) {
            return b + c;
        }
        if (!(p > 0.0)) {
            p = d * 0.3;
        }
        if (!(a > 0.0) || a < Math.abs(c)) {
            a = c;
            s = p / 4.0;
        } else {
            s = p / (Math.PI * 2) * Math.asin(c / a);
        }
        return -(a * Math.pow(2.0, 10.0 * (t -= 1.0)) * Math.sin((t * d - s) * (Math.PI * 2) / p)) + b;
    }

    @Override
    public double easeOut(double time, double start, double end, double duration) {
        return this.easeOut(time, start, end, duration, start + end, duration);
    }

    public double easeOut(double t, double b, double c, double d, double a, double p) {
        double s;
        if (t == 0.0) {
            return b;
        }
        if ((t /= d) == 1.0) {
            return b + c;
        }
        if (!(p > 0.0)) {
            p = d * 0.3;
        }
        if (!(a > 0.0) || a < Math.abs(c)) {
            a = c;
            s = p / 4.0;
        } else {
            s = p / (Math.PI * 2) * Math.asin(c / a);
        }
        return a * Math.pow(2.0, -10.0 * t) * Math.sin((t * d - s) * (Math.PI * 2) / p) + c + b;
    }

    @Override
    public double easeInOut(double t, double b, double c, double d) {
        return this.easeInOut(t, b, c, d, b + c, d);
    }

    public double easeInOut(double t, double b, double c, double d, double a, double p) {
        double s;
        if (t == 0.0) {
            return b;
        }
        if ((t /= d / 2.0) == 2.0) {
            return b + c;
        }
        if (!(p > 0.0)) {
            p = d * 0.44999999999999996;
        }
        if (!(a > 0.0) || a < Math.abs(c)) {
            a = c;
            s = p / 4.0;
        } else {
            s = p / (Math.PI * 2) * Math.asin(c / a);
        }
        if (t < 1.0) {
            return -0.5 * (a * Math.pow(2.0, 10.0 * (t -= 1.0)) * Math.sin((t * d - s) * (Math.PI * 2) / p)) + b;
        }
        return a * Math.pow(2.0, -10.0 * (t -= 1.0)) * Math.sin((t * d - s) * (Math.PI * 2) / p) * 0.5 + c + b;
    }
}

