/*
 * Decompiled with CFR 0.152.
 */
package it.micegroup.voila2runtime.utils;

import com.turkraft.springfilter.boot.FilterSpecification;
import com.turkraft.springfilter.parser.Filter;
import com.turkraft.springfilter.parser.FilterParser;
import it.micegroup.voila2runtime.entity.GenericEntity;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class AclUtils
implements ApplicationContextAware {
    private static final String CURRENT_USER = "{currentUser}";
    private static final String VOILA_ACL_PROFILE = "voila.acl.profile.";
    private static final String VOILA_ACL_APPLICATION = "voila.acl.application.";
    private static Environment env;

    public static <T extends GenericEntity> Specification<T> applyAcl(Specification<T> specification, String key) {
        Specification result = specification;
        String currentUser = SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString();
        Collection profiles = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
        StringBuilder filter = new StringBuilder();
        String prefix = "";
        prefix = AclUtils.applySingleAcl(filter, prefix, VOILA_ACL_APPLICATION, key);
        for (GrantedAuthority grantedAuthority : profiles) {
            prefix = AclUtils.applySingleAcl(filter, prefix, VOILA_ACL_PROFILE + grantedAuthority.getAuthority() + ".", key);
        }
        if (filter.length() > 0) {
            String filterString = filter.toString();
            filterString = StringUtils.replace((String)filterString, (String)CURRENT_USER, (String)currentUser);
            FilterSpecification aclFilter = new FilterSpecification((Filter)FilterParser.FilterContext.parse((String)filterString));
            result = FilterSpecification.merge((Specification[])new Specification[]{aclFilter, specification});
        }
        return result;
    }

    private static <T extends GenericEntity> String applySingleAcl(StringBuilder filter, String prefix, String baseKey, String key) {
        String[] keyParts = key.split("\\.");
        String compKey = "";
        for (String part : keyParts) {
            compKey = compKey + part;
            String acl = env.getProperty(baseKey + compKey);
            if (StringUtils.isNotEmpty((CharSequence)acl)) {
                filter.append(prefix).append(acl);
                prefix = " AND ";
            }
            compKey = compKey + ".";
        }
        return prefix;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        env = applicationContext.getEnvironment();
    }
}

