/*
 * Decompiled with CFR 0.152.
 */
package it.micegroup.voila2runtime.exception;

import it.micegroup.voila2runtime.exception.BusinessException;
import java.time.LocalDateTime;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.WebRequest;

public class ErrorDetails {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorDetails.class);
    private final LocalDateTime timestamp = LocalDateTime.now();
    private final String exception;
    private final Object details;
    private final String requestId;
    private final String requestUri;
    private StackTraceElement[] stackTrace;

    public ErrorDetails(BusinessException exception, WebRequest request) {
        this.exception = exception.getClass().getSimpleName();
        this.details = exception.getMessages();
        this.requestId = request.getHeader("X-Correlation-ID");
        this.requestUri = request.getDescription(false);
        if (LOGGER.isDebugEnabled()) {
            this.stackTrace = Arrays.copyOf(exception.getStackTrace(), 5);
        }
    }

    public ErrorDetails(Exception exception, WebRequest request) {
        this.exception = exception.getClass().getSimpleName();
        this.details = exception.getMessage();
        this.requestId = request.getHeader("X-Correlation-ID");
        this.requestUri = request.getDescription(false);
        if (LOGGER.isDebugEnabled()) {
            this.stackTrace = Arrays.copyOf(exception.getStackTrace(), 5);
        }
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getException() {
        return this.exception;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Object getDetails() {
        return this.details;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String toString() {
        return "ErrorDetails[timestamp=" + this.timestamp + ", exception='" + this.exception + '\'' + ", details=" + this.details + ", requestId='" + this.requestId + '\'' + ", requestUri='" + this.requestUri + '\'' + ", stackTrace=" + Arrays.toString(this.stackTrace) + ']';
    }
}

