/*
 * Copyright (c) 2018, SnakeYAML
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.snakeyaml.engine.v2.tokens

import org.snakeyaml.engine.v2.exceptions.Mark

class DirectiveToken(
    val value: TokenValue?,
    startMark: Mark?,
    endMark: Mark?,
) : Token(startMark, endMark) {

    override val tokenId: ID
        get() = ID.Directive

    sealed interface TokenValue {
        val name: String
    }

    data class YamlDirective(val major: Int, val minor: Int) : TokenValue {
        override val name: String get() = YAML_DIRECTIVE
    }

    data class TagDirective(val handle: String, val prefix: String) : TokenValue {
        override val name: String get() = TAG_DIRECTIVE
    }

    companion object {
        const val YAML_DIRECTIVE = "YAML"
        const val TAG_DIRECTIVE = "TAG"
    }
}
