/*
 * Decompiled with CFR 0.152.
 */
package it.infuse.jenkins.usemango;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.ResourceList;
import hudson.model.queue.AbstractQueueTask;
import hudson.model.queue.SubTask;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import it.infuse.jenkins.usemango.UseMangoTestExecutor;
import it.infuse.jenkins.usemango.model.TestIndexItem;
import it.infuse.jenkins.usemango.util.ProjectUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.acegisecurity.AccessDeniedException;

public class UseMangoTestTask
extends AbstractQueueTask
implements AccessControlled {
    private final String nodeLabel;
    private final AbstractBuild<?, ?> build;
    private final BuildListener listener;
    private final TestIndexItem test;
    private final String command;

    public UseMangoTestTask(String nodeLabel, AbstractBuild<?, ?> build, BuildListener listener, TestIndexItem test, String command) {
        this.build = build;
        this.listener = listener;
        this.test = test;
        this.command = command;
        this.nodeLabel = nodeLabel;
    }

    public String getName() {
        return ProjectUtils.getJenkinsTestTaskName(this.test.getName(), ((AbstractProject)this.build.getParent()).getName(), this.build.number);
    }

    public String getFullDisplayName() {
        return this.getName();
    }

    public String getUrl() {
        return this.build.getUrl();
    }

    public String getDisplayName() {
        return this.getName();
    }

    public Label getAssignedLabel() {
        return Label.get((String)this.nodeLabel);
    }

    public Node getLastBuiltOn() {
        return ((AbstractProject)this.build.getParent()).getLastBuiltOn();
    }

    public long getEstimatedDuration() {
        return this.build.getEstimatedDuration();
    }

    public Collection<? extends SubTask> getSubTasks() {
        ArrayList<UseMangoTestTask> tasks = new ArrayList<UseMangoTestTask>();
        tasks.add(this);
        return tasks;
    }

    public void checkPermission(Permission p) throws AccessDeniedException {
        this.build.checkPermission(p);
    }

    public ACL getACL() {
        return this.build.getProject().getACL();
    }

    public boolean hasPermission(Permission p) {
        return this.build.getProject().hasPermission(p);
    }

    public void checkAbortPermission() {
        this.build.getProject().checkAbortPermission();
    }

    public String getWhyBlocked() {
        return this.build.getProject().getWhyBlocked();
    }

    public boolean hasAbortPermission() {
        return this.build.getProject().hasAbortPermission();
    }

    public boolean isBuildBlocked() {
        return this.build.getProject().isBuildBlocked();
    }

    public ResourceList getResourceList() {
        return this.build.getProject().getResourceList();
    }

    public Queue.Executable createExecutable() throws IOException {
        return new UseMangoTestExecutor((Queue.Task)this, this.build.getWorkspace(), this.listener, this.test, this.command);
    }
}

