/*
 * Decompiled with CFR 0.152.
 */
package it.infuse.jenkins.usemango;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.User;
import hudson.security.ACL;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import it.infuse.jenkins.usemango.UseMangoConfiguration;
import it.infuse.jenkins.usemango.UseMangoTestTask;
import it.infuse.jenkins.usemango.exception.UseMangoException;
import it.infuse.jenkins.usemango.model.Project;
import it.infuse.jenkins.usemango.model.TestIndexItem;
import it.infuse.jenkins.usemango.model.TestIndexParams;
import it.infuse.jenkins.usemango.model.TestIndexResponse;
import it.infuse.jenkins.usemango.model.UmUser;
import it.infuse.jenkins.usemango.util.APIUtils;
import it.infuse.jenkins.usemango.util.ProjectUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class UseMangoBuilder
extends Builder
implements BuildStep {
    private static StandardUsernamePasswordCredentials credentials;
    private static String useMangoUrl;
    private static String ID_TOKEN;
    private static String REFRESH_TOKEN;
    private String useSlaveNodes;
    private String nodeLabel;
    private String projectId;
    private String tags;
    private String testName;
    private String testStatus;
    private String assignedTo;

    @DataBoundConstructor
    public UseMangoBuilder(String useSlaveNodes, String nodeLabel, String projectId, String tags, String testName, String testStatus, String assignedTo) {
        this.useSlaveNodes = useSlaveNodes;
        this.nodeLabel = nodeLabel;
        this.projectId = projectId;
        this.tags = tags;
        this.testName = testName;
        this.testStatus = testStatus;
        this.assignedTo = assignedTo;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (ProjectUtils.hasCorrectPermissions(User.current())) {
            Label label;
            UseMangoBuilder.prepareWorkspace(build.getWorkspace());
            boolean useSlaves = Boolean.valueOf(this.useSlaveNodes);
            if (!useSlaves || StringUtils.isBlank((CharSequence)this.nodeLabel)) {
                listener.getLogger().println("Not using labelled nodes, or no label defined.");
                this.nodeLabel = "master";
            }
            if ((label = Label.get((String)this.nodeLabel)) == null || label.getNodes() == null || label.getNodes().size() <= 0) {
                throw new RuntimeException("No '" + this.nodeLabel + "' nodes available to run tests");
            }
            listener.getLogger().println("Executing tests on '" + this.nodeLabel + "' node(s)");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            TestIndexParams params = new TestIndexParams();
            params.setAssignedTo(this.assignedTo);
            params.addTags(this.tags);
            params.setProjectId(this.projectId);
            params.setTestName(this.testName);
            params.setTestStatus(this.testStatus);
            listener.getLogger().println("TestIndex API parameters:\n" + gson.toJson((Object)params));
            TestIndexResponse indexes = null;
            try {
                indexes = UseMangoBuilder.getTestIndexes(params);
            }
            catch (UseMangoException e) {
                throw new RuntimeException(e);
            }
            if (Objects.requireNonNull(indexes).size() > 0) {
                build.getWorkspace().child("logs").mkdirs();
                build.getWorkspace().child("results").mkdirs();
                listener.getLogger().println(indexes.getItems().size() + " tests retrieved:\n" + gson.toJson(indexes.getItems()));
                ArrayList testIds = new ArrayList();
                indexes.getItems().forEach(test -> {
                    try {
                        testIds.add(test.getId());
                        Jenkins.getInstance().getQueue().schedule2((Queue.Task)new UseMangoTestTask(this.nodeLabel, build, listener, (TestIndexItem)((Object)test), UseMangoBuilder.getUseMangoCommand(this.projectId, test.getName())), Jenkins.getInstance().getQuietPeriod(), new Action[0]);
                    }
                    catch (Exception e) {
                        listener.error("Error executing test: " + test.getName());
                        throw new RuntimeException(e);
                    }
                });
                while (!testIds.isEmpty()) {
                    String testId = null;
                    for (String tempId : testIds) {
                        if (!build.getWorkspace().child("logs").child(ProjectUtils.getLogFileName(tempId)).exists()) continue;
                        testId = tempId;
                    }
                    if (testId != null) {
                        testIds.remove(testId);
                    }
                    Thread.sleep(1000L);
                }
                boolean testSuitePassed = true;
                for (TestIndexItem test2 : indexes.getItems()) {
                    if (test2.isPassed()) continue;
                    testSuitePassed = false;
                }
                if (!testSuitePassed) {
                    build.setResult(Result.FAILURE);
                }
                listener.getLogger().println("\nTest execution complete.\n\nThank you for using useMango :-)\n");
            } else {
                listener.getLogger().println("No tests retrieved from useMango account, please check settings and try again.");
            }
            return true;
        }
        listener.error("Jenkins user '" + User.current() + "' does not have permissions to configure and build this Job - please contact your system administrator, or update the users' security settings.");
        return false;
    }

    private static StandardUsernamePasswordCredentials getCredentials(String credentialsId) {
        List credentailsList = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList());
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)credentailsList, (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId)}));
    }

    private static void loadUseMangoCredentials() throws UseMangoException {
        useMangoUrl = UseMangoConfiguration.get().getLocation();
        credentials = UseMangoBuilder.getCredentials(UseMangoConfiguration.get().getCredentialsId());
        if (StringUtils.isBlank((CharSequence)useMangoUrl) || !useMangoUrl.startsWith("http")) {
            throw new UseMangoException("Invalid useMango url in global configuration (<a href=\"/configure\">view config</a>)");
        }
        if (credentials == null) {
            throw new UseMangoException("Invalid useMango credentials in global configuration (<a href=\"/configure\">view config</a>)");
        }
    }

    private static void getTokens() throws UseMangoException, IOException {
        UseMangoBuilder.loadUseMangoCredentials();
        if (credentials == null) {
            throw new UseMangoException("Credentials are null, please check useMango global config");
        }
        String[] tokens = APIUtils.getAuthenticationTokens(useMangoUrl, credentials.getUsername(), credentials.getPassword().getPlainText());
        ID_TOKEN = tokens[0];
        REFRESH_TOKEN = tokens[1];
    }

    private static void refreshIdToken() throws UseMangoException, IOException {
        block2: {
            try {
                ID_TOKEN = APIUtils.refreshIdToken(useMangoUrl, REFRESH_TOKEN);
            }
            catch (UseMangoException e) {
                ID_TOKEN = null;
                REFRESH_TOKEN = null;
                if (e.getMessage() != "Expired refresh token") break block2;
                UseMangoBuilder.getTokens();
            }
        }
    }

    private static boolean isTokenExpired() {
        String base64EncodedBody = ID_TOKEN.split("\\.")[1];
        Base64 base64Url = new Base64(true);
        String body = new String(base64Url.decode(base64EncodedBody), StandardCharsets.UTF_8);
        JsonObject jsonBody = new JsonParser().parse(body).getAsJsonObject();
        long expiry = jsonBody.get("exp").getAsLong();
        Date expiring = new Date(expiry * 1000L);
        Date now = new Date();
        return expiring.before(now);
    }

    private static void checkTokenExistsAndValid() throws UseMangoException, IOException {
        if (ID_TOKEN == null) {
            UseMangoBuilder.getTokens();
            return;
        }
        if (UseMangoBuilder.isTokenExpired()) {
            UseMangoBuilder.refreshIdToken();
        }
    }

    private static TestIndexResponse getTestIndexes(TestIndexParams params) throws IOException, UseMangoException {
        UseMangoBuilder.checkTokenExistsAndValid();
        if (params == null) {
            throw new UseMangoException("Test parameters are null, please check useMango build step in job");
        }
        return APIUtils.getTestIndex(useMangoUrl, params, ID_TOKEN);
    }

    private static List<Project> getProjects() throws IOException, UseMangoException {
        UseMangoBuilder.checkTokenExistsAndValid();
        return APIUtils.getProjects(useMangoUrl, ID_TOKEN);
    }

    private static List<String> getProjectTags(String projectId) throws IOException, UseMangoException {
        UseMangoBuilder.checkTokenExistsAndValid();
        return APIUtils.getProjectTags(useMangoUrl, ID_TOKEN, projectId);
    }

    private static List<UmUser> getUsers() throws IOException, UseMangoException {
        UseMangoBuilder.checkTokenExistsAndValid();
        return APIUtils.getUsers(useMangoUrl, ID_TOKEN);
    }

    private static String getUseMangoCommand(String projectId, String testName) {
        StringBuffer sb = new StringBuffer("\"C:\\Program Files (x86)\\Infuse Consulting\\useMango\\App\\MangoMotor.exe\"");
        sb.append(" -s \"" + useMangoUrl + "\"");
        sb.append(" -p \"" + projectId + "\"");
        sb.append(" --testname \"" + testName + "\"");
        sb.append(" -e \"" + credentials.getUsername() + "\"");
        sb.append(" --password \"" + credentials.getPassword().getPlainText() + "\"");
        return sb.toString();
    }

    private static void prepareWorkspace(FilePath workspace) throws IOException, InterruptedException {
        if (workspace.child("logs").exists()) {
            workspace.child("logs").deleteContents();
            workspace.child("logs").deleteRecursive();
        }
        if (workspace.child("results").exists()) {
            workspace.child("results").deleteContents();
            workspace.child("results").deleteRecursive();
        }
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getTags() {
        return this.tags;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getTestStatus() {
        return this.testStatus;
    }

    public String getAssignedTo() {
        return this.assignedTo;
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public String getUseSlaveNodes() {
        return this.useSlaveNodes;
    }

    static {
        ID_TOKEN = null;
        REFRESH_TOKEN = null;
    }

    @Symbol(value={"useMango"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public ListBoxModel doFillProjectIdItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("");
            try {
                List projects = UseMangoBuilder.getProjects();
                if (projects != null) {
                    projects.forEach(project -> items.add(project.getName()));
                }
            }
            catch (UseMangoException | IOException e) {
                e.printStackTrace(System.out);
            }
            return items;
        }

        public ListBoxModel doFillAssignedToItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Anybody");
            items.add("Nobody");
            try {
                List users = UseMangoBuilder.getUsers();
                if (users != null) {
                    users.forEach(user -> items.add(user.getName() + " (" + user.getEmail() + ")"));
                }
            }
            catch (UseMangoException | IOException e) {
                e.printStackTrace(System.out);
            }
            return items;
        }

        public ListBoxModel doFillTestStatusItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("");
            items.add("Design");
            items.add("Ready");
            items.add("Repair");
            items.add("Revalidate");
            items.add("Review");
            return items;
        }

        @POST
        public FormValidation doCheckNodeLabel(@QueryParameter String nodeLabel) throws IOException, ServletException {
            if (StringUtils.isNotBlank((CharSequence)nodeLabel)) {
                Label label = Label.get((String)nodeLabel);
                if (label != null && label.getNodes() != null && label.getNodes().size() > 0) {
                    return FormValidation.ok();
                }
                return FormValidation.warning((String)"No matching nodes found, please try again.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckProjectId(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a Project ID");
            }
            List projectTags = new ArrayList();
            try {
                projectTags = UseMangoBuilder.getProjectTags(value);
            }
            catch (UseMangoException | IOException e) {
                e.printStackTrace(System.out);
            }
            if (projectTags != null && !projectTags.isEmpty()) {
                StringBuilder resultsHtml = new StringBuilder("<label><strong>Available tags:</strong></label>");
                resultsHtml.append("<div id=\"tempTagsContainer\"style=\"max-height:150px;overflow-y:scroll;padding-top:5px;padding-bottom:5px;\">");
                resultsHtml.append("<ul>");
                projectTags.forEach(item -> resultsHtml.append("<li>" + item + "</li>"));
                resultsHtml.append("</ul>");
                resultsHtml.append("</div>");
                return FormValidation.okWithMarkup((String)resultsHtml.toString());
            }
            return FormValidation.warningWithMarkup((String)"Project doesn't have any test tags.");
        }

        public FormValidation doValidateSettings(@QueryParameter(value="projectId") String projectId, @QueryParameter(value="tags") String tags, @QueryParameter(value="testName") String testName, @QueryParameter(value="testStatus") String testStatus, @QueryParameter(value="assignedTo") String assignedTo) throws IOException, ServletException {
            if (!ProjectUtils.hasCorrectPermissions(User.current())) {
                return FormValidation.error((String)("Jenkins user '" + User.current() + "' does not have permissions to configure and build this Job - please contact your system administrator, or update the users' security settings."));
            }
            if (StringUtils.isBlank((CharSequence)projectId)) {
                return FormValidation.error((String)"Please complete mandatory Project ID field above");
            }
            try {
                List users = UseMangoBuilder.getUsers();
                String userId = assignedTo;
                if (!userId.contains("Anybody") && !userId.contains("Nobody")) {
                    String userEmail = StringUtils.substringBetween((String)userId, (String)"(", (String)")");
                    userId = ((UmUser)((Object)users.stream().filter(u -> u.getEmail().equals(userEmail)).collect(Collectors.toList()).get(0))).getId();
                }
                TestIndexParams params = new TestIndexParams();
                params.setAssignedTo(userId);
                params.addTags(tags);
                params.setProjectId(projectId);
                params.setTestName(testName);
                params.setTestStatus(testStatus);
                TestIndexResponse indexes = UseMangoBuilder.getTestIndexes(params);
                StringBuilder sb = new StringBuilder();
                sb.append("Connecting to <a href=\"" + useMangoUrl + "\" target=\"_blank\">" + useMangoUrl + "</a>... done.<br/>");
                sb.append("Validating account " + credentials.getUsername() + "... done.<br/><br/>");
                if (indexes != null && indexes.getItems() != null && !indexes.getItems().isEmpty()) {
                    int size = indexes.getItems().size();
                    StringBuilder resultsHtml = new StringBuilder("<div style=\"max-height:300px;overflow-y:scroll;padding-top:5px;\">");
                    resultsHtml.append("<table width=\"100%\" border=\"0\" cellspacing=\"6\" cellpadding=\"6\" style=\"border:1px solid rgba(0, 0, 0, 0.1);width:100%;background-color:#eee;\">");
                    resultsHtml.append("<tr style=\"background-color:rgba(0, 0, 0, 0.1);\" align=\"left\"><th>Name</th><th>Tags</th><th>Status</th><th>Assigned To</th></tr>");
                    indexes.getItems().forEach(item -> {
                        List foundUsers;
                        String assignee = item.getAssignee();
                        if (!item.getAssignee().isEmpty() && (foundUsers = users.stream().filter(u -> u.getId().equals(item.getAssignee())).collect(Collectors.toList())).size() > 0) {
                            assignee = ((UmUser)((Object)((Object)foundUsers.get(0)))).getName() + " (" + ((UmUser)((Object)((Object)foundUsers.get(0)))).getEmail() + ")";
                        }
                        resultsHtml.append("<tr><td>" + item.getName() + "</td><td>" + String.join((CharSequence)", ", item.getTags()) + "</td><td>" + item.getStatus() + "</td><td>" + assignee + "</td></tr>");
                    });
                    resultsHtml.append("</table>");
                    resultsHtml.append("</div>");
                    sb.append("<b>Test" + (size > 1 ? "s" : "") + " matched in account (" + size + "):</b><br/>");
                    return FormValidation.okWithMarkup((String)(sb.toString() + resultsHtml));
                }
                return FormValidation.warningWithMarkup((String)(sb.toString() + "No tests matched in account. Please check settings above and try again."));
            }
            catch (UseMangoException e) {
                return FormValidation.error((String)("Validation error: " + e.getMessage()));
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Run useMango tests";
        }
    }
}

