/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.filter;

import it.fattureincloud.sdk.filter.Condition;
import it.fattureincloud.sdk.filter.Conjunction;
import it.fattureincloud.sdk.filter.Disjunction;
import it.fattureincloud.sdk.filter.Expression;
import it.fattureincloud.sdk.filter.Operator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;

public class Filter {
    private Expression expression;

    public Filter() {
        this.expression = null;
    }

    public Filter(Expression expression) {
        this.expression = expression;
    }

    public Optional<Expression> getExpression() {
        return Optional.ofNullable(this.expression);
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public <T> Filter where(String field, Operator op, T value) {
        this.expression = new Condition<T>(field, op, value);
        return this;
    }

    public Filter whereExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public <T> Filter and(String field, Operator op, T value) throws Exception {
        if (this.expression == null) {
            throw new Exception("Cannot create a conjunction for an empty expression.");
        }
        Expression left = this.expression;
        Condition<T> right = new Condition<T>(field, op, value);
        this.expression = new Conjunction(left, right);
        return this;
    }

    public Filter andExpression(Expression expression) throws Exception {
        if (this.expression == null || expression == null) {
            throw new Exception("Cannot create a conjunction for an empty expression.");
        }
        Expression left = this.expression;
        this.expression = new Conjunction(left, expression);
        return this;
    }

    public Filter andFilter(Filter filter) throws Exception {
        if (this.expression == null || filter == null || !filter.getExpression().isPresent()) {
            throw new Exception("Cannot create a conjunction for an empty expression.");
        }
        Expression left = this.expression;
        this.expression = new Conjunction(left, filter.getExpression().get());
        return this;
    }

    public <T> Filter or(String field, Operator op, T value) throws Exception {
        if (this.expression == null) {
            throw new Exception("Cannot create a disjunction for an empty expression.");
        }
        Expression left = this.expression;
        Condition<T> right = new Condition<T>(field, op, value);
        this.expression = new Disjunction(left, right);
        return this;
    }

    public Filter orExpression(Expression expression) throws Exception {
        if (this.expression == null || expression == null) {
            throw new Exception("Cannot create a disjunction for an empty expression.");
        }
        Expression left = this.expression;
        this.expression = new Disjunction(left, expression);
        return this;
    }

    public Filter orFilter(Filter filter) throws Exception {
        if (this.expression == null || filter == null || !filter.getExpression().isPresent()) {
            throw new Exception("Cannot create a disjunction for an empty expression.");
        }
        Expression left = this.expression;
        this.expression = new Disjunction(left, filter.getExpression().get());
        return this;
    }

    public String buildQuery() {
        if (this.expression == null) {
            return "";
        }
        return this.expression.buildQuery();
    }

    public String buildUrlEncodedQuery() throws UnsupportedEncodingException {
        return URLEncoder.encode(this.buildQuery(), StandardCharsets.UTF_8.toString());
    }

    public String toString() {
        return this.buildQuery();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Filter filter = (Filter)o;
        return Objects.equals(this.expression, filter.expression);
    }

    public int hashCode() {
        return Objects.hash(this.expression);
    }
}

