/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.api;

import com.google.gson.reflect.TypeToken;
import it.fattureincloud.sdk.ApiCallback;
import it.fattureincloud.sdk.ApiClient;
import it.fattureincloud.sdk.ApiException;
import it.fattureincloud.sdk.ApiResponse;
import it.fattureincloud.sdk.Configuration;
import it.fattureincloud.sdk.Pair;
import it.fattureincloud.sdk.model.CreateProductRequest;
import it.fattureincloud.sdk.model.CreateProductResponse;
import it.fattureincloud.sdk.model.GetProductResponse;
import it.fattureincloud.sdk.model.ListProductsResponse;
import it.fattureincloud.sdk.model.ModifyProductRequest;
import it.fattureincloud.sdk.model.ModifyProductResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ProductsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProductsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProductsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createProductCall(Integer companyId, CreateProductRequest createProductRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateProductRequest localVarPostBody = createProductRequest;
        String localVarPath = "/c/{company_id}/products".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createProductValidateBeforeCall(Integer companyId, CreateProductRequest createProductRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling createProduct(Async)");
        }
        return this.createProductCall(companyId, createProductRequest, _callback);
    }

    public CreateProductResponse createProduct(Integer companyId, CreateProductRequest createProductRequest) throws ApiException {
        ApiResponse<CreateProductResponse> localVarResp = this.createProductWithHttpInfo(companyId, createProductRequest);
        return localVarResp.getData();
    }

    public ApiResponse<CreateProductResponse> createProductWithHttpInfo(Integer companyId, CreateProductRequest createProductRequest) throws ApiException {
        Call localVarCall = this.createProductValidateBeforeCall(companyId, createProductRequest, null);
        Type localVarReturnType = new TypeToken<CreateProductResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createProductAsync(Integer companyId, CreateProductRequest createProductRequest, ApiCallback<CreateProductResponse> _callback) throws ApiException {
        Call localVarCall = this.createProductValidateBeforeCall(companyId, createProductRequest, _callback);
        Type localVarReturnType = new TypeToken<CreateProductResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteProductCall(Integer companyId, Integer productId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/products/{product_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{product_id}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProductValidateBeforeCall(Integer companyId, Integer productId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling deleteProduct(Async)");
        }
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling deleteProduct(Async)");
        }
        return this.deleteProductCall(companyId, productId, _callback);
    }

    public void deleteProduct(Integer companyId, Integer productId) throws ApiException {
        this.deleteProductWithHttpInfo(companyId, productId);
    }

    public ApiResponse<Void> deleteProductWithHttpInfo(Integer companyId, Integer productId) throws ApiException {
        Call localVarCall = this.deleteProductValidateBeforeCall(companyId, productId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteProductAsync(Integer companyId, Integer productId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteProductValidateBeforeCall(companyId, productId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getProductCall(Integer companyId, Integer productId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/products/{product_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{product_id}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProductValidateBeforeCall(Integer companyId, Integer productId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getProduct(Async)");
        }
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling getProduct(Async)");
        }
        return this.getProductCall(companyId, productId, fields, fieldset, _callback);
    }

    public GetProductResponse getProduct(Integer companyId, Integer productId, String fields, String fieldset) throws ApiException {
        ApiResponse<GetProductResponse> localVarResp = this.getProductWithHttpInfo(companyId, productId, fields, fieldset);
        return localVarResp.getData();
    }

    public ApiResponse<GetProductResponse> getProductWithHttpInfo(Integer companyId, Integer productId, String fields, String fieldset) throws ApiException {
        Call localVarCall = this.getProductValidateBeforeCall(companyId, productId, fields, fieldset, null);
        Type localVarReturnType = new TypeToken<GetProductResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProductAsync(Integer companyId, Integer productId, String fields, String fieldset, ApiCallback<GetProductResponse> _callback) throws ApiException {
        Call localVarCall = this.getProductValidateBeforeCall(companyId, productId, fields, fieldset, _callback);
        Type localVarReturnType = new TypeToken<GetProductResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listProductsCall(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/products".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listProductsValidateBeforeCall(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listProducts(Async)");
        }
        return this.listProductsCall(companyId, fields, fieldset, sort, page, perPage, q, _callback);
    }

    public ListProductsResponse listProducts(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q) throws ApiException {
        ApiResponse<ListProductsResponse> localVarResp = this.listProductsWithHttpInfo(companyId, fields, fieldset, sort, page, perPage, q);
        return localVarResp.getData();
    }

    public ApiResponse<ListProductsResponse> listProductsWithHttpInfo(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q) throws ApiException {
        Call localVarCall = this.listProductsValidateBeforeCall(companyId, fields, fieldset, sort, page, perPage, q, null);
        Type localVarReturnType = new TypeToken<ListProductsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listProductsAsync(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback<ListProductsResponse> _callback) throws ApiException {
        Call localVarCall = this.listProductsValidateBeforeCall(companyId, fields, fieldset, sort, page, perPage, q, _callback);
        Type localVarReturnType = new TypeToken<ListProductsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyProductCall(Integer companyId, Integer productId, ModifyProductRequest modifyProductRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ModifyProductRequest localVarPostBody = modifyProductRequest;
        String localVarPath = "/c/{company_id}/products/{product_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{product_id}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyProductValidateBeforeCall(Integer companyId, Integer productId, ModifyProductRequest modifyProductRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling modifyProduct(Async)");
        }
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling modifyProduct(Async)");
        }
        return this.modifyProductCall(companyId, productId, modifyProductRequest, _callback);
    }

    public ModifyProductResponse modifyProduct(Integer companyId, Integer productId, ModifyProductRequest modifyProductRequest) throws ApiException {
        ApiResponse<ModifyProductResponse> localVarResp = this.modifyProductWithHttpInfo(companyId, productId, modifyProductRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ModifyProductResponse> modifyProductWithHttpInfo(Integer companyId, Integer productId, ModifyProductRequest modifyProductRequest) throws ApiException {
        Call localVarCall = this.modifyProductValidateBeforeCall(companyId, productId, modifyProductRequest, null);
        Type localVarReturnType = new TypeToken<ModifyProductResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call modifyProductAsync(Integer companyId, Integer productId, ModifyProductRequest modifyProductRequest, ApiCallback<ModifyProductResponse> _callback) throws ApiException {
        Call localVarCall = this.modifyProductValidateBeforeCall(companyId, productId, modifyProductRequest, _callback);
        Type localVarReturnType = new TypeToken<ModifyProductResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

