/*
 * Fatture in Cloud API v2 - API Reference
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.1.3
 * Contact: info@fattureincloud.it
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package it.fattureincloud.sdk.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

/** IssuedDocument */
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2024-10-30T09:09:50.123536Z[Etc/UTC]",
    comments = "Generator version: 7.9.0")
public class IssuedDocument implements Serializable {
  private static final long serialVersionUID = 1L;

  public static final String SERIALIZED_NAME_ID = "id";

  @SerializedName(SERIALIZED_NAME_ID)
  private Integer id;

  public static final String SERIALIZED_NAME_ENTITY = "entity";

  @SerializedName(SERIALIZED_NAME_ENTITY)
  private Entity entity;

  public static final String SERIALIZED_NAME_TYPE = "type";

  @SerializedName(SERIALIZED_NAME_TYPE)
  private IssuedDocumentType type = IssuedDocumentType.INVOICE;

  public static final String SERIALIZED_NAME_NUMBER = "number";

  @SerializedName(SERIALIZED_NAME_NUMBER)
  private Integer number;

  public static final String SERIALIZED_NAME_NUMERATION = "numeration";

  @SerializedName(SERIALIZED_NAME_NUMERATION)
  private String numeration;

  public static final String SERIALIZED_NAME_DATE = "date";

  @SerializedName(SERIALIZED_NAME_DATE)
  private LocalDate date;

  public static final String SERIALIZED_NAME_YEAR = "year";

  @SerializedName(SERIALIZED_NAME_YEAR)
  private Integer year;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";

  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private Currency currency;

  public static final String SERIALIZED_NAME_LANGUAGE = "language";

  @SerializedName(SERIALIZED_NAME_LANGUAGE)
  private Language language;

  public static final String SERIALIZED_NAME_SUBJECT = "subject";

  @SerializedName(SERIALIZED_NAME_SUBJECT)
  private String subject;

  public static final String SERIALIZED_NAME_VISIBLE_SUBJECT = "visible_subject";

  @SerializedName(SERIALIZED_NAME_VISIBLE_SUBJECT)
  private String visibleSubject;

  public static final String SERIALIZED_NAME_RC_CENTER = "rc_center";

  @SerializedName(SERIALIZED_NAME_RC_CENTER)
  private String rcCenter;

  public static final String SERIALIZED_NAME_NOTES = "notes";

  @SerializedName(SERIALIZED_NAME_NOTES)
  private String notes;

  public static final String SERIALIZED_NAME_RIVALSA = "rivalsa";

  @SerializedName(SERIALIZED_NAME_RIVALSA)
  private BigDecimal rivalsa;

  public static final String SERIALIZED_NAME_CASSA = "cassa";

  @SerializedName(SERIALIZED_NAME_CASSA)
  private BigDecimal cassa;

  public static final String SERIALIZED_NAME_AMOUNT_CASSA = "amount_cassa";

  @SerializedName(SERIALIZED_NAME_AMOUNT_CASSA)
  private BigDecimal amountCassa;

  public static final String SERIALIZED_NAME_CASSA_TAXABLE = "cassa_taxable";

  @SerializedName(SERIALIZED_NAME_CASSA_TAXABLE)
  private BigDecimal cassaTaxable;

  public static final String SERIALIZED_NAME_AMOUNT_CASSA_TAXABLE = "amount_cassa_taxable";

  @SerializedName(SERIALIZED_NAME_AMOUNT_CASSA_TAXABLE)
  private BigDecimal amountCassaTaxable;

  public static final String SERIALIZED_NAME_CASSA2 = "cassa2";

  @SerializedName(SERIALIZED_NAME_CASSA2)
  private BigDecimal cassa2;

  public static final String SERIALIZED_NAME_AMOUNT_CASSA2 = "amount_cassa2";

  @SerializedName(SERIALIZED_NAME_AMOUNT_CASSA2)
  private BigDecimal amountCassa2;

  public static final String SERIALIZED_NAME_CASSA2_TAXABLE = "cassa2_taxable";

  @SerializedName(SERIALIZED_NAME_CASSA2_TAXABLE)
  private BigDecimal cassa2Taxable;

  public static final String SERIALIZED_NAME_AMOUNT_CASSA2_TAXABLE = "amount_cassa2_taxable";

  @SerializedName(SERIALIZED_NAME_AMOUNT_CASSA2_TAXABLE)
  private BigDecimal amountCassa2Taxable;

  public static final String SERIALIZED_NAME_GLOBAL_CASSA_TAXABLE = "global_cassa_taxable";

  @SerializedName(SERIALIZED_NAME_GLOBAL_CASSA_TAXABLE)
  private BigDecimal globalCassaTaxable;

  public static final String SERIALIZED_NAME_AMOUNT_GLOBAL_CASSA_TAXABLE =
      "amount_global_cassa_taxable";

  @SerializedName(SERIALIZED_NAME_AMOUNT_GLOBAL_CASSA_TAXABLE)
  private BigDecimal amountGlobalCassaTaxable;

  public static final String SERIALIZED_NAME_WITHHOLDING_TAX = "withholding_tax";

  @SerializedName(SERIALIZED_NAME_WITHHOLDING_TAX)
  private BigDecimal withholdingTax;

  public static final String SERIALIZED_NAME_WITHHOLDING_TAX_TAXABLE = "withholding_tax_taxable";

  @SerializedName(SERIALIZED_NAME_WITHHOLDING_TAX_TAXABLE)
  private BigDecimal withholdingTaxTaxable;

  public static final String SERIALIZED_NAME_OTHER_WITHHOLDING_TAX = "other_withholding_tax";

  @SerializedName(SERIALIZED_NAME_OTHER_WITHHOLDING_TAX)
  private BigDecimal otherWithholdingTax;

  public static final String SERIALIZED_NAME_STAMP_DUTY = "stamp_duty";

  @SerializedName(SERIALIZED_NAME_STAMP_DUTY)
  private BigDecimal stampDuty;

  public static final String SERIALIZED_NAME_PAYMENT_METHOD = "payment_method";

  @SerializedName(SERIALIZED_NAME_PAYMENT_METHOD)
  private PaymentMethod paymentMethod;

  public static final String SERIALIZED_NAME_USE_SPLIT_PAYMENT = "use_split_payment";

  @SerializedName(SERIALIZED_NAME_USE_SPLIT_PAYMENT)
  private Boolean useSplitPayment;

  public static final String SERIALIZED_NAME_USE_GROSS_PRICES = "use_gross_prices";

  @SerializedName(SERIALIZED_NAME_USE_GROSS_PRICES)
  private Boolean useGrossPrices;

  public static final String SERIALIZED_NAME_E_INVOICE = "e_invoice";

  @SerializedName(SERIALIZED_NAME_E_INVOICE)
  private Boolean eInvoice;

  public static final String SERIALIZED_NAME_EI_DATA = "ei_data";

  @SerializedName(SERIALIZED_NAME_EI_DATA)
  private IssuedDocumentEiData eiData;

  public static final String SERIALIZED_NAME_EI_CASSA_TYPE = "ei_cassa_type";

  @SerializedName(SERIALIZED_NAME_EI_CASSA_TYPE)
  private String eiCassaType;

  public static final String SERIALIZED_NAME_EI_CASSA2_TYPE = "ei_cassa2_type";

  @SerializedName(SERIALIZED_NAME_EI_CASSA2_TYPE)
  private String eiCassa2Type;

  public static final String SERIALIZED_NAME_EI_WITHHOLDING_TAX_CAUSAL =
      "ei_withholding_tax_causal";

  @SerializedName(SERIALIZED_NAME_EI_WITHHOLDING_TAX_CAUSAL)
  private String eiWithholdingTaxCausal;

  public static final String SERIALIZED_NAME_EI_OTHER_WITHHOLDING_TAX_TYPE =
      "ei_other_withholding_tax_type";

  @SerializedName(SERIALIZED_NAME_EI_OTHER_WITHHOLDING_TAX_TYPE)
  private String eiOtherWithholdingTaxType;

  public static final String SERIALIZED_NAME_EI_OTHER_WITHHOLDING_TAX_CAUSAL =
      "ei_other_withholding_tax_causal";

  @SerializedName(SERIALIZED_NAME_EI_OTHER_WITHHOLDING_TAX_CAUSAL)
  private String eiOtherWithholdingTaxCausal;

  public static final String SERIALIZED_NAME_ITEMS_LIST = "items_list";

  @SerializedName(SERIALIZED_NAME_ITEMS_LIST)
  private List<IssuedDocumentItemsListItem> itemsList;

  public static final String SERIALIZED_NAME_PAYMENTS_LIST = "payments_list";

  @SerializedName(SERIALIZED_NAME_PAYMENTS_LIST)
  private List<IssuedDocumentPaymentsListItem> paymentsList;

  public static final String SERIALIZED_NAME_TEMPLATE = "template";

  @SerializedName(SERIALIZED_NAME_TEMPLATE)
  private DocumentTemplate template;

  public static final String SERIALIZED_NAME_DELIVERY_NOTE_TEMPLATE = "delivery_note_template";

  @SerializedName(SERIALIZED_NAME_DELIVERY_NOTE_TEMPLATE)
  private DocumentTemplate deliveryNoteTemplate;

  public static final String SERIALIZED_NAME_ACC_INV_TEMPLATE = "acc_inv_template";

  @SerializedName(SERIALIZED_NAME_ACC_INV_TEMPLATE)
  private DocumentTemplate accInvTemplate;

  public static final String SERIALIZED_NAME_H_MARGINS = "h_margins";

  @SerializedName(SERIALIZED_NAME_H_MARGINS)
  private Integer hMargins;

  public static final String SERIALIZED_NAME_V_MARGINS = "v_margins";

  @SerializedName(SERIALIZED_NAME_V_MARGINS)
  private Integer vMargins;

  public static final String SERIALIZED_NAME_SHOW_PAYMENTS = "show_payments";

  @SerializedName(SERIALIZED_NAME_SHOW_PAYMENTS)
  private Boolean showPayments;

  public static final String SERIALIZED_NAME_SHOW_PAYMENT_METHOD = "show_payment_method";

  @SerializedName(SERIALIZED_NAME_SHOW_PAYMENT_METHOD)
  private Boolean showPaymentMethod;

  public static final String SERIALIZED_NAME_SHOW_TOTALS = "show_totals";

  @SerializedName(SERIALIZED_NAME_SHOW_TOTALS)
  private ShowTotalsMode showTotals = ShowTotalsMode.ALL;

  public static final String SERIALIZED_NAME_SHOW_NOTIFICATION_BUTTON = "show_notification_button";

  @SerializedName(SERIALIZED_NAME_SHOW_NOTIFICATION_BUTTON)
  private Boolean showNotificationButton;

  public static final String SERIALIZED_NAME_SHOW_TSPAY_BUTTON = "show_tspay_button";

  @SerializedName(SERIALIZED_NAME_SHOW_TSPAY_BUTTON)
  private Boolean showTspayButton;

  public static final String SERIALIZED_NAME_DELIVERY_NOTE = "delivery_note";

  @SerializedName(SERIALIZED_NAME_DELIVERY_NOTE)
  private Boolean deliveryNote;

  public static final String SERIALIZED_NAME_ACCOMPANYING_INVOICE = "accompanying_invoice";

  @SerializedName(SERIALIZED_NAME_ACCOMPANYING_INVOICE)
  private Boolean accompanyingInvoice;

  public static final String SERIALIZED_NAME_DN_NUMBER = "dn_number";

  @SerializedName(SERIALIZED_NAME_DN_NUMBER)
  private Integer dnNumber;

  public static final String SERIALIZED_NAME_DN_DATE = "dn_date";

  @SerializedName(SERIALIZED_NAME_DN_DATE)
  private LocalDate dnDate;

  public static final String SERIALIZED_NAME_DN_AI_PACKAGES_NUMBER = "dn_ai_packages_number";

  @SerializedName(SERIALIZED_NAME_DN_AI_PACKAGES_NUMBER)
  private String dnAiPackagesNumber;

  public static final String SERIALIZED_NAME_DN_AI_WEIGHT = "dn_ai_weight";

  @SerializedName(SERIALIZED_NAME_DN_AI_WEIGHT)
  private String dnAiWeight;

  public static final String SERIALIZED_NAME_DN_AI_CAUSAL = "dn_ai_causal";

  @SerializedName(SERIALIZED_NAME_DN_AI_CAUSAL)
  private String dnAiCausal;

  public static final String SERIALIZED_NAME_DN_AI_DESTINATION = "dn_ai_destination";

  @SerializedName(SERIALIZED_NAME_DN_AI_DESTINATION)
  private String dnAiDestination;

  public static final String SERIALIZED_NAME_DN_AI_TRANSPORTER = "dn_ai_transporter";

  @SerializedName(SERIALIZED_NAME_DN_AI_TRANSPORTER)
  private String dnAiTransporter;

  public static final String SERIALIZED_NAME_DN_AI_NOTES = "dn_ai_notes";

  @SerializedName(SERIALIZED_NAME_DN_AI_NOTES)
  private String dnAiNotes;

  public static final String SERIALIZED_NAME_IS_MARKED = "is_marked";

  @SerializedName(SERIALIZED_NAME_IS_MARKED)
  private Boolean isMarked;

  public static final String SERIALIZED_NAME_AMOUNT_NET = "amount_net";

  @SerializedName(SERIALIZED_NAME_AMOUNT_NET)
  private BigDecimal amountNet;

  public static final String SERIALIZED_NAME_AMOUNT_VAT = "amount_vat";

  @SerializedName(SERIALIZED_NAME_AMOUNT_VAT)
  private BigDecimal amountVat;

  public static final String SERIALIZED_NAME_AMOUNT_GROSS = "amount_gross";

  @SerializedName(SERIALIZED_NAME_AMOUNT_GROSS)
  private BigDecimal amountGross;

  public static final String SERIALIZED_NAME_AMOUNT_DUE_DISCOUNT = "amount_due_discount";

  @SerializedName(SERIALIZED_NAME_AMOUNT_DUE_DISCOUNT)
  private BigDecimal amountDueDiscount;

  public static final String SERIALIZED_NAME_AMOUNT_RIVALSA = "amount_rivalsa";

  @SerializedName(SERIALIZED_NAME_AMOUNT_RIVALSA)
  private BigDecimal amountRivalsa;

  public static final String SERIALIZED_NAME_AMOUNT_RIVALSA_TAXABLE = "amount_rivalsa_taxable";

  @SerializedName(SERIALIZED_NAME_AMOUNT_RIVALSA_TAXABLE)
  private BigDecimal amountRivalsaTaxable;

  public static final String SERIALIZED_NAME_AMOUNT_WITHHOLDING_TAX = "amount_withholding_tax";

  @SerializedName(SERIALIZED_NAME_AMOUNT_WITHHOLDING_TAX)
  private BigDecimal amountWithholdingTax;

  public static final String SERIALIZED_NAME_AMOUNT_WITHHOLDING_TAX_TAXABLE =
      "amount_withholding_tax_taxable";

  @SerializedName(SERIALIZED_NAME_AMOUNT_WITHHOLDING_TAX_TAXABLE)
  private BigDecimal amountWithholdingTaxTaxable;

  public static final String SERIALIZED_NAME_AMOUNT_OTHER_WITHHOLDING_TAX =
      "amount_other_withholding_tax";

  @SerializedName(SERIALIZED_NAME_AMOUNT_OTHER_WITHHOLDING_TAX)
  private BigDecimal amountOtherWithholdingTax;

  public static final String SERIALIZED_NAME_AMOUNT_OTHER_WITHHOLDING_TAX_TAXABLE =
      "amount_other_withholding_tax_taxable";

  @SerializedName(SERIALIZED_NAME_AMOUNT_OTHER_WITHHOLDING_TAX_TAXABLE)
  private BigDecimal amountOtherWithholdingTaxTaxable;

  public static final String SERIALIZED_NAME_AMOUNT_ENASARCO_TAXABLE = "amount_enasarco_taxable";

  @SerializedName(SERIALIZED_NAME_AMOUNT_ENASARCO_TAXABLE)
  private BigDecimal amountEnasarcoTaxable;

  public static final String SERIALIZED_NAME_EXTRA_DATA = "extra_data";

  @SerializedName(SERIALIZED_NAME_EXTRA_DATA)
  private IssuedDocumentExtraData extraData;

  public static final String SERIALIZED_NAME_SEEN_DATE = "seen_date";

  @SerializedName(SERIALIZED_NAME_SEEN_DATE)
  private LocalDate seenDate;

  public static final String SERIALIZED_NAME_NEXT_DUE_DATE = "next_due_date";

  @SerializedName(SERIALIZED_NAME_NEXT_DUE_DATE)
  private LocalDate nextDueDate;

  public static final String SERIALIZED_NAME_URL = "url";

  @SerializedName(SERIALIZED_NAME_URL)
  private String url;

  public static final String SERIALIZED_NAME_DN_URL = "dn_url";

  @SerializedName(SERIALIZED_NAME_DN_URL)
  private String dnUrl;

  public static final String SERIALIZED_NAME_AI_URL = "ai_url";

  @SerializedName(SERIALIZED_NAME_AI_URL)
  private String aiUrl;

  public static final String SERIALIZED_NAME_ATTACHMENT_URL = "attachment_url";

  @SerializedName(SERIALIZED_NAME_ATTACHMENT_URL)
  private String attachmentUrl;

  public static final String SERIALIZED_NAME_ATTACHMENT_TOKEN = "attachment_token";

  @SerializedName(SERIALIZED_NAME_ATTACHMENT_TOKEN)
  private String attachmentToken;

  public static final String SERIALIZED_NAME_EI_RAW = "ei_raw";

  @SerializedName(SERIALIZED_NAME_EI_RAW)
  private Object eiRaw;

  /**
   * [Read only] Status of the e-invoice. * **attempt** - We are trying to send the invoice, please
   * wait up to 2 hours * **missing** - The invoice is missing * **not_sent** - The invoice has yet
   * to be sent * **sent** - The invoice was sent * **pending** - The checks for the digital
   * signature and sending are in progress * **processing** - The SDI is delivering the invoice to
   * the customer * **error** - An error occurred while handling the invoice, please try to resend
   * it or contact support * **discarded** - The invoice has been rejected by the SDI, so it must be
   * corrected and re-sent * **not_delivered** - The SDI was unable to deliver the invoice *
   * **accepted** - The customer accepted the invoice * **rejected** - The customer rejected the
   * invoice, so it must be corrected * **no_response** - A response has not yet been received
   * whithin the deadline, contact the customer to ascertain the status of the invoice *
   * **manual_accepted** - The customer accepted the invoice * **manual_rejected** - The customer
   * rejected the invoice
   */
  @JsonAdapter(EiStatusEnum.Adapter.class)
  public enum EiStatusEnum {
    ATTEMPT("attempt"),

    MISSING("missing"),

    NOT_SENT("not_sent"),

    SENT("sent"),

    PENDING("pending"),

    PROCESSING("processing"),

    ERROR("error"),

    DISCARDED("discarded"),

    NOT_DELIVERED("not_delivered"),

    ACCEPTED("accepted"),

    REJECTED("rejected"),

    NO_RESPONSE("no_response"),

    MANUAL_ACCEPTED("manual_accepted"),

    MANUAL_REJECTED("manual_rejected");

    private String value;

    EiStatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static EiStatusEnum fromValue(String value) {
      for (EiStatusEnum b : EiStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<EiStatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EiStatusEnum enumeration)
          throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public EiStatusEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return EiStatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_EI_STATUS = "ei_status";

  @SerializedName(SERIALIZED_NAME_EI_STATUS)
  private EiStatusEnum eiStatus;

  public static final String SERIALIZED_NAME_LOCKED = "locked";

  @SerializedName(SERIALIZED_NAME_LOCKED)
  private Boolean locked;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";

  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private String createdAt;

  public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";

  @SerializedName(SERIALIZED_NAME_UPDATED_AT)
  private String updatedAt;

  public IssuedDocument() {}
  /** Constructor with only readonly parameters */
  public IssuedDocument(
      BigDecimal amountCassa,
      BigDecimal amountCassa2,
      BigDecimal amountNet,
      BigDecimal amountVat,
      BigDecimal amountGross,
      BigDecimal amountRivalsa,
      BigDecimal amountWithholdingTax,
      BigDecimal amountOtherWithholdingTax,
      String attachmentUrl) {
    this();
    this.amountCassa = amountCassa;
    this.amountCassa2 = amountCassa2;
    this.amountNet = amountNet;
    this.amountVat = amountVat;
    this.amountGross = amountGross;
    this.amountRivalsa = amountRivalsa;
    this.amountWithholdingTax = amountWithholdingTax;
    this.amountOtherWithholdingTax = amountOtherWithholdingTax;
    this.attachmentUrl = attachmentUrl;
  }

  public IssuedDocument id(Integer id) {

    this.id = id;
    return this;
  }

  /**
   * Issued document id
   *
   * @return id
   */
  @javax.annotation.Nullable
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public IssuedDocument entity(Entity entity) {

    this.entity = entity;
    return this;
  }

  /**
   * Get entity
   *
   * @return entity
   */
  @javax.annotation.Nullable
  public Entity getEntity() {
    return entity;
  }

  public void setEntity(Entity entity) {
    this.entity = entity;
  }

  public IssuedDocument type(IssuedDocumentType type) {

    this.type = type;
    return this;
  }

  /**
   * Get type
   *
   * @return type
   */
  @javax.annotation.Nullable
  public IssuedDocumentType getType() {
    return type;
  }

  public void setType(IssuedDocumentType type) {
    this.type = type;
  }

  public IssuedDocument number(Integer number) {

    this.number = number;
    return this;
  }

  /**
   * Issued document number [If not specified, next number is used]
   *
   * @return number
   */
  @javax.annotation.Nullable
  public Integer getNumber() {
    return number;
  }

  public void setNumber(Integer number) {
    this.number = number;
  }

  public IssuedDocument numeration(String numeration) {

    this.numeration = numeration;
    return this;
  }

  /**
   * Issued document numeration [Not available if type&#x3D;delivery_note]
   *
   * @return numeration
   */
  @javax.annotation.Nullable
  public String getNumeration() {
    return numeration;
  }

  public void setNumeration(String numeration) {
    this.numeration = numeration;
  }

  public IssuedDocument date(LocalDate date) {

    this.date = date;
    return this;
  }

  /**
   * Issued document date [defaults to today&#39;s date]
   *
   * @return date
   */
  @javax.annotation.Nullable
  public LocalDate getDate() {
    return date;
  }

  public void setDate(LocalDate date) {
    this.date = date;
  }

  public IssuedDocument year(Integer year) {

    this.year = year;
    return this;
  }

  /**
   * Issued document year
   *
   * @return year
   */
  @javax.annotation.Nullable
  public Integer getYear() {
    return year;
  }

  public void setYear(Integer year) {
    this.year = year;
  }

  public IssuedDocument currency(Currency currency) {

    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   *
   * @return currency
   */
  @javax.annotation.Nullable
  public Currency getCurrency() {
    return currency;
  }

  public void setCurrency(Currency currency) {
    this.currency = currency;
  }

  public IssuedDocument language(Language language) {

    this.language = language;
    return this;
  }

  /**
   * Get language
   *
   * @return language
   */
  @javax.annotation.Nullable
  public Language getLanguage() {
    return language;
  }

  public void setLanguage(Language language) {
    this.language = language;
  }

  public IssuedDocument subject(String subject) {

    this.subject = subject;
    return this;
  }

  /**
   * Issued document subject [not shown on the PDF]
   *
   * @return subject
   */
  @javax.annotation.Nullable
  public String getSubject() {
    return subject;
  }

  public void setSubject(String subject) {
    this.subject = subject;
  }

  public IssuedDocument visibleSubject(String visibleSubject) {

    this.visibleSubject = visibleSubject;
    return this;
  }

  /**
   * Issued document visible subject
   *
   * @return visibleSubject
   */
  @javax.annotation.Nullable
  public String getVisibleSubject() {
    return visibleSubject;
  }

  public void setVisibleSubject(String visibleSubject) {
    this.visibleSubject = visibleSubject;
  }

  public IssuedDocument rcCenter(String rcCenter) {

    this.rcCenter = rcCenter;
    return this;
  }

  /**
   * Issued document revenue center [or cost center if type&#x3D;supplier_order].
   *
   * @return rcCenter
   */
  @javax.annotation.Nullable
  public String getRcCenter() {
    return rcCenter;
  }

  public void setRcCenter(String rcCenter) {
    this.rcCenter = rcCenter;
  }

  public IssuedDocument notes(String notes) {

    this.notes = notes;
    return this;
  }

  /**
   * Issued document extra notes
   *
   * @return notes
   */
  @javax.annotation.Nullable
  public String getNotes() {
    return notes;
  }

  public void setNotes(String notes) {
    this.notes = notes;
  }

  public IssuedDocument rivalsa(BigDecimal rivalsa) {

    this.rivalsa = rivalsa;
    return this;
  }

  /**
   * Issued document \&quot;Rivalsa INPS\&quot; percentual value
   *
   * @return rivalsa
   */
  @javax.annotation.Nullable
  public BigDecimal getRivalsa() {
    return rivalsa;
  }

  public void setRivalsa(BigDecimal rivalsa) {
    this.rivalsa = rivalsa;
  }

  public IssuedDocument cassa(BigDecimal cassa) {

    this.cassa = cassa;
    return this;
  }

  /**
   * Issued document \&quot;Cassa previdenziale\&quot; percentual value
   *
   * @return cassa
   */
  @javax.annotation.Nullable
  public BigDecimal getCassa() {
    return cassa;
  }

  public void setCassa(BigDecimal cassa) {
    this.cassa = cassa;
  }

  /**
   * [Read Only] Issued document cassa amount.
   *
   * @return amountCassa
   */
  @javax.annotation.Nullable
  public BigDecimal getAmountCassa() {
    return amountCassa;
  }

  public IssuedDocument cassaTaxable(BigDecimal cassaTaxable) {

    this.cassaTaxable = cassaTaxable;
    return this;
  }

  /**
   * Issued document cassa taxable percentage
   *
   * @return cassaTaxable
   */
  @javax.annotation.Nullable
  public BigDecimal getCassaTaxable() {
    return cassaTaxable;
  }

  public void setCassaTaxable(BigDecimal cassaTaxable) {
    this.cassaTaxable = cassaTaxable;
  }

  public IssuedDocument amountCassaTaxable(BigDecimal amountCassaTaxable) {

    this.amountCassaTaxable = amountCassaTaxable;
    return this;
  }

  /**
   * [Can be set only if cassa_taxable is NULL] Issued document cassa taxable amount
   *
   * @return amountCassaTaxable
   */
  @javax.annotation.Nullable
  public BigDecimal getAmountCassaTaxable() {
    return amountCassaTaxable;
  }

  public void setAmountCassaTaxable(BigDecimal amountCassaTaxable) {
    this.amountCassaTaxable = amountCassaTaxable;
  }

  public IssuedDocument cassa2(BigDecimal cassa2) {

    this.cassa2 = cassa2;
    return this;
  }

  /**
   * Issued document \&quot;Cassa previdenziale 2\&quot; percentual value
   *
   * @return cassa2
   */
  @javax.annotation.Nullable
  public BigDecimal getCassa2() {
    return cassa2;
  }

  public void setCassa2(BigDecimal cassa2) {
    this.cassa2 = cassa2;
  }

  /**
   * [Read Only] Issued document cassa2 amount
   *
   * @return amountCassa2
   */
  @javax.annotation.Nullable
  public BigDecimal getAmountCassa2() {
    return amountCassa2;
  }

  public IssuedDocument cassa2Taxable(BigDecimal cassa2Taxable) {

    this.cassa2Taxable = cassa2Taxable;
    return this;
  }

  /**
   * Issued document cassa2 taxable percentage
   *
   * @return cassa2Taxable
   */
  @javax.annotation.Nullable
  public BigDecimal getCassa2Taxable() {
    return cassa2Taxable;
  }

  public void setCassa2Taxable(BigDecimal cassa2Taxable) {
    this.cassa2Taxable = cassa2Taxable;
  }

  public IssuedDocument amountCassa2Taxable(BigDecimal amountCassa2Taxable) {

    this.amountCassa2Taxable = amountCassa2Taxable;
    return this;
  }

  /**
   * [Can be set only if cassa2_taxable is NULL] Issued document cassa2 taxable amount
   *
   * @return amountCassa2Taxable
   */
  @javax.annotation.Nullable
  public BigDecimal getAmountCassa2Taxable() {
    return amountCassa2Taxable;
  }

  public void setAmountCassa2Taxable(BigDecimal amountCassa2Taxable) {
    this.amountCassa2Taxable = amountCassa2Taxable;
  }

  public IssuedDocument globalCassaTaxable(BigDecimal globalCassaTaxable) {

    this.globalCassaTaxable = globalCassaTaxable;
    return this;
  }

  /**
   * Issued document global cassa taxable percentage
   *
   * @return globalCassaTaxable
   */
  @javax.annotation.Nullable
  public BigDecimal getGlobalCassaTaxable() {
    return globalCassaTaxable;
  }

  public void setGlobalCassaTaxable(BigDecimal globalCassaTaxable) {
    this.globalCassaTaxable = globalCassaTaxable;
  }

  public IssuedDocument amountGlobalCassaTaxable(BigDecimal amountGlobalCassaTaxable) {

    this.amountGlobalCassaTaxable = amountGlobalCassaTaxable;
    return this;
  }

  /**
   * [Can be set only if global_cassa_taxable is NULL] Issued document global cassa taxable amount
   *
   * @return amountGlobalCassaTaxable
   */
  @javax.annotation.Nullable
  public BigDecimal getAmountGlobalCassaTaxable() {
    return amountGlobalCassaTaxable;
  }

  public void setAmountGlobalCassaTaxable(BigDecimal amountGlobalCassaTaxable) {
    this.amountGlobalCassaTaxable = amountGlobalCassaTaxable;
  }

  public IssuedDocument withholdingTax(BigDecimal withholdingTax) {

    this.withholdingTax = withholdingTax;
    return this;
  }

  /**
   * Issued document withholding tax (ritenuta d&#39;acconto) percentual value
   *
   * @return withholdingTax
   */
  @javax.annotation.Nullable
  public BigDecimal getWithholdingTax() {
    return withholdingTax;
  }

  public void setWithholdingTax(BigDecimal withholdingTax) {
    this.withholdingTax = withholdingTax;
  }

  public IssuedDocument withholdingTaxTaxable(BigDecimal withholdingTaxTaxable) {

    this.withholdingTaxTaxable = withholdingTaxTaxable;
    return this;
  }

  /**
   * Issued document withholding tax taxable (imponibile) percentual value
   *
   * @return withholdingTaxTaxable
   */
  @javax.annotation.Nullable
  public BigDecimal getWithholdingTaxTaxable() {
    return withholdingTaxTaxable;
  }

  public void setWithholdingTaxTaxable(BigDecimal withholdingTaxTaxable) {
    this.withholdingTaxTaxable = withholdingTaxTaxable;
  }

  public IssuedDocument otherWithholdingTax(BigDecimal otherWithholdingTax) {

    this.otherWithholdingTax = otherWithholdingTax;
    return this;
  }

  /**
   * Issued document other withholding tax (altra ritenuta) percentual value
   *
   * @return otherWithholdingTax
   */
  @javax.annotation.Nullable
  public BigDecimal getOtherWithholdingTax() {
    return otherWithholdingTax;
  }

  public void setOtherWithholdingTax(BigDecimal otherWithholdingTax) {
    this.otherWithholdingTax = otherWithholdingTax;
  }

  public IssuedDocument stampDuty(BigDecimal stampDuty) {

    this.stampDuty = stampDuty;
    return this;
  }

  /**
   * Issued document stamp duty value [0 if not present]
   *
   * @return stampDuty
   */
  @javax.annotation.Nullable
  public BigDecimal getStampDuty() {
    return stampDuty;
  }

  public void setStampDuty(BigDecimal stampDuty) {
    this.stampDuty = stampDuty;
  }

  public IssuedDocument paymentMethod(PaymentMethod paymentMethod) {

    this.paymentMethod = paymentMethod;
    return this;
  }

  /**
   * Get paymentMethod
   *
   * @return paymentMethod
   */
  @javax.annotation.Nullable
  public PaymentMethod getPaymentMethod() {
    return paymentMethod;
  }

  public void setPaymentMethod(PaymentMethod paymentMethod) {
    this.paymentMethod = paymentMethod;
  }

  public IssuedDocument useSplitPayment(Boolean useSplitPayment) {

    this.useSplitPayment = useSplitPayment;
    return this;
  }

  /**
   * Issued document uses split payment
   *
   * @return useSplitPayment
   */
  @javax.annotation.Nullable
  public Boolean getUseSplitPayment() {
    return useSplitPayment;
  }

  public void setUseSplitPayment(Boolean useSplitPayment) {
    this.useSplitPayment = useSplitPayment;
  }

  public IssuedDocument useGrossPrices(Boolean useGrossPrices) {

    this.useGrossPrices = useGrossPrices;
    return this;
  }

  /**
   * Issued document uses gross prices
   *
   * @return useGrossPrices
   */
  @javax.annotation.Nullable
  public Boolean getUseGrossPrices() {
    return useGrossPrices;
  }

  public void setUseGrossPrices(Boolean useGrossPrices) {
    this.useGrossPrices = useGrossPrices;
  }

  public IssuedDocument eInvoice(Boolean eInvoice) {

    this.eInvoice = eInvoice;
    return this;
  }

  /**
   * Issued document is an e-invoice.
   *
   * @return eInvoice
   */
  @javax.annotation.Nullable
  public Boolean geteInvoice() {
    return eInvoice;
  }

  public void seteInvoice(Boolean eInvoice) {
    this.eInvoice = eInvoice;
  }

  public IssuedDocument eiData(IssuedDocumentEiData eiData) {

    this.eiData = eiData;
    return this;
  }

  /**
   * Get eiData
   *
   * @return eiData
   */
  @javax.annotation.Nullable
  public IssuedDocumentEiData getEiData() {
    return eiData;
  }

  public void setEiData(IssuedDocumentEiData eiData) {
    this.eiData = eiData;
  }

  public IssuedDocument eiCassaType(String eiCassaType) {

    this.eiCassaType = eiCassaType;
    return this;
  }

  /**
   * E-invoice cassa type
   *
   * @return eiCassaType
   */
  @javax.annotation.Nullable
  public String getEiCassaType() {
    return eiCassaType;
  }

  public void setEiCassaType(String eiCassaType) {
    this.eiCassaType = eiCassaType;
  }

  public IssuedDocument eiCassa2Type(String eiCassa2Type) {

    this.eiCassa2Type = eiCassa2Type;
    return this;
  }

  /**
   * E-invoice cassa2 type
   *
   * @return eiCassa2Type
   */
  @javax.annotation.Nullable
  public String getEiCassa2Type() {
    return eiCassa2Type;
  }

  public void setEiCassa2Type(String eiCassa2Type) {
    this.eiCassa2Type = eiCassa2Type;
  }

  public IssuedDocument eiWithholdingTaxCausal(String eiWithholdingTaxCausal) {

    this.eiWithholdingTaxCausal = eiWithholdingTaxCausal;
    return this;
  }

  /**
   * E-invoice withholding tax causal
   *
   * @return eiWithholdingTaxCausal
   */
  @javax.annotation.Nullable
  public String getEiWithholdingTaxCausal() {
    return eiWithholdingTaxCausal;
  }

  public void setEiWithholdingTaxCausal(String eiWithholdingTaxCausal) {
    this.eiWithholdingTaxCausal = eiWithholdingTaxCausal;
  }

  public IssuedDocument eiOtherWithholdingTaxType(String eiOtherWithholdingTaxType) {

    this.eiOtherWithholdingTaxType = eiOtherWithholdingTaxType;
    return this;
  }

  /**
   * E-invoice other withholding tax type
   *
   * @return eiOtherWithholdingTaxType
   */
  @javax.annotation.Nullable
  public String getEiOtherWithholdingTaxType() {
    return eiOtherWithholdingTaxType;
  }

  public void setEiOtherWithholdingTaxType(String eiOtherWithholdingTaxType) {
    this.eiOtherWithholdingTaxType = eiOtherWithholdingTaxType;
  }

  public IssuedDocument eiOtherWithholdingTaxCausal(String eiOtherWithholdingTaxCausal) {

    this.eiOtherWithholdingTaxCausal = eiOtherWithholdingTaxCausal;
    return this;
  }

  /**
   * E-invoice other withholding tax causal
   *
   * @return eiOtherWithholdingTaxCausal
   */
  @javax.annotation.Nullable
  public String getEiOtherWithholdingTaxCausal() {
    return eiOtherWithholdingTaxCausal;
  }

  public void setEiOtherWithholdingTaxCausal(String eiOtherWithholdingTaxCausal) {
    this.eiOtherWithholdingTaxCausal = eiOtherWithholdingTaxCausal;
  }

  public IssuedDocument itemsList(List<IssuedDocumentItemsListItem> itemsList) {

    this.itemsList = itemsList;
    return this;
  }

  public IssuedDocument addItemsListItem(IssuedDocumentItemsListItem itemsListItem) {
    if (this.itemsList == null) {
      this.itemsList = new ArrayList<>();
    }
    this.itemsList.add(itemsListItem);
    return this;
  }

  /**
   * Get itemsList
   *
   * @return itemsList
   */
  @javax.annotation.Nullable
  public List<IssuedDocumentItemsListItem> getItemsList() {
    return itemsList;
  }

  public void setItemsList(List<IssuedDocumentItemsListItem> itemsList) {
    this.itemsList = itemsList;
  }

  public IssuedDocument paymentsList(List<IssuedDocumentPaymentsListItem> paymentsList) {

    this.paymentsList = paymentsList;
    return this;
  }

  public IssuedDocument addPaymentsListItem(IssuedDocumentPaymentsListItem paymentsListItem) {
    if (this.paymentsList == null) {
      this.paymentsList = new ArrayList<>();
    }
    this.paymentsList.add(paymentsListItem);
    return this;
  }

  /**
   * Get paymentsList
   *
   * @return paymentsList
   */
  @javax.annotation.Nullable
  public List<IssuedDocumentPaymentsListItem> getPaymentsList() {
    return paymentsList;
  }

  public void setPaymentsList(List<IssuedDocumentPaymentsListItem> paymentsList) {
    this.paymentsList = paymentsList;
  }

  public IssuedDocument template(DocumentTemplate template) {

    this.template = template;
    return this;
  }

  /**
   * Get template
   *
   * @return template
   */
  @javax.annotation.Nullable
  public DocumentTemplate getTemplate() {
    return template;
  }

  public void setTemplate(DocumentTemplate template) {
    this.template = template;
  }

  public IssuedDocument deliveryNoteTemplate(DocumentTemplate deliveryNoteTemplate) {

    this.deliveryNoteTemplate = deliveryNoteTemplate;
    return this;
  }

  /**
   * Get deliveryNoteTemplate
   *
   * @return deliveryNoteTemplate
   */
  @javax.annotation.Nullable
  public DocumentTemplate getDeliveryNoteTemplate() {
    return deliveryNoteTemplate;
  }

  public void setDeliveryNoteTemplate(DocumentTemplate deliveryNoteTemplate) {
    this.deliveryNoteTemplate = deliveryNoteTemplate;
  }

  public IssuedDocument accInvTemplate(DocumentTemplate accInvTemplate) {

    this.accInvTemplate = accInvTemplate;
    return this;
  }

  /**
   * Get accInvTemplate
   *
   * @return accInvTemplate
   */
  @javax.annotation.Nullable
  public DocumentTemplate getAccInvTemplate() {
    return accInvTemplate;
  }

  public void setAccInvTemplate(DocumentTemplate accInvTemplate) {
    this.accInvTemplate = accInvTemplate;
  }

  public IssuedDocument hMargins(Integer hMargins) {

    this.hMargins = hMargins;
    return this;
  }

  /**
   * Issued document PDF horizontal margins
   *
   * @return hMargins
   */
  @javax.annotation.Nullable
  public Integer gethMargins() {
    return hMargins;
  }

  public void sethMargins(Integer hMargins) {
    this.hMargins = hMargins;
  }

  public IssuedDocument vMargins(Integer vMargins) {

    this.vMargins = vMargins;
    return this;
  }

  /**
   * Issued document PDF vertical margins
   *
   * @return vMargins
   */
  @javax.annotation.Nullable
  public Integer getvMargins() {
    return vMargins;
  }

  public void setvMargins(Integer vMargins) {
    this.vMargins = vMargins;
  }

  public IssuedDocument showPayments(Boolean showPayments) {

    this.showPayments = showPayments;
    return this;
  }

  /**
   * Show the expiration dates of the payments on the document
   *
   * @return showPayments
   */
  @javax.annotation.Nullable
  public Boolean getShowPayments() {
    return showPayments;
  }

  public void setShowPayments(Boolean showPayments) {
    this.showPayments = showPayments;
  }

  public IssuedDocument showPaymentMethod(Boolean showPaymentMethod) {

    this.showPaymentMethod = showPaymentMethod;
    return this;
  }

  /**
   * Show the payment method details on the document
   *
   * @return showPaymentMethod
   */
  @javax.annotation.Nullable
  public Boolean getShowPaymentMethod() {
    return showPaymentMethod;
  }

  public void setShowPaymentMethod(Boolean showPaymentMethod) {
    this.showPaymentMethod = showPaymentMethod;
  }

  public IssuedDocument showTotals(ShowTotalsMode showTotals) {

    this.showTotals = showTotals;
    return this;
  }

  /**
   * Get showTotals
   *
   * @return showTotals
   */
  @javax.annotation.Nullable
  public ShowTotalsMode getShowTotals() {
    return showTotals;
  }

  public void setShowTotals(ShowTotalsMode showTotals) {
    this.showTotals = showTotals;
  }

  public IssuedDocument showNotificationButton(Boolean showNotificationButton) {

    this.showNotificationButton = showNotificationButton;
    return this;
  }

  /**
   * Show notification button in the PDF
   *
   * @return showNotificationButton
   */
  @javax.annotation.Nullable
  public Boolean getShowNotificationButton() {
    return showNotificationButton;
  }

  public void setShowNotificationButton(Boolean showNotificationButton) {
    this.showNotificationButton = showNotificationButton;
  }

  public IssuedDocument showTspayButton(Boolean showTspayButton) {

    this.showTspayButton = showTspayButton;
    return this;
  }

  /**
   * Show ts pay button in the PDF
   *
   * @return showTspayButton
   */
  @javax.annotation.Nullable
  public Boolean getShowTspayButton() {
    return showTspayButton;
  }

  public void setShowTspayButton(Boolean showTspayButton) {
    this.showTspayButton = showTspayButton;
  }

  public IssuedDocument deliveryNote(Boolean deliveryNote) {

    this.deliveryNote = deliveryNote;
    return this;
  }

  /**
   * Issued document has delivery note
   *
   * @return deliveryNote
   */
  @javax.annotation.Nullable
  public Boolean getDeliveryNote() {
    return deliveryNote;
  }

  public void setDeliveryNote(Boolean deliveryNote) {
    this.deliveryNote = deliveryNote;
  }

  public IssuedDocument accompanyingInvoice(Boolean accompanyingInvoice) {

    this.accompanyingInvoice = accompanyingInvoice;
    return this;
  }

  /**
   * Issued document has an accompanying invoice
   *
   * @return accompanyingInvoice
   */
  @javax.annotation.Nullable
  public Boolean getAccompanyingInvoice() {
    return accompanyingInvoice;
  }

  public void setAccompanyingInvoice(Boolean accompanyingInvoice) {
    this.accompanyingInvoice = accompanyingInvoice;
  }

  public IssuedDocument dnNumber(Integer dnNumber) {

    this.dnNumber = dnNumber;
    return this;
  }

  /**
   * Issued document attached delivery note number
   *
   * @return dnNumber
   */
  @javax.annotation.Nullable
  public Integer getDnNumber() {
    return dnNumber;
  }

  public void setDnNumber(Integer dnNumber) {
    this.dnNumber = dnNumber;
  }

  public IssuedDocument dnDate(LocalDate dnDate) {

    this.dnDate = dnDate;
    return this;
  }

  /**
   * Issued document attached delivery note date
   *
   * @return dnDate
   */
  @javax.annotation.Nullable
  public LocalDate getDnDate() {
    return dnDate;
  }

  public void setDnDate(LocalDate dnDate) {
    this.dnDate = dnDate;
  }

  public IssuedDocument dnAiPackagesNumber(String dnAiPackagesNumber) {

    this.dnAiPackagesNumber = dnAiPackagesNumber;
    return this;
  }

  /**
   * Issued document attached delivery note number of packages
   *
   * @return dnAiPackagesNumber
   */
  @javax.annotation.Nullable
  public String getDnAiPackagesNumber() {
    return dnAiPackagesNumber;
  }

  public void setDnAiPackagesNumber(String dnAiPackagesNumber) {
    this.dnAiPackagesNumber = dnAiPackagesNumber;
  }

  public IssuedDocument dnAiWeight(String dnAiWeight) {

    this.dnAiWeight = dnAiWeight;
    return this;
  }

  /**
   * Issued document attached delivery note package weight
   *
   * @return dnAiWeight
   */
  @javax.annotation.Nullable
  public String getDnAiWeight() {
    return dnAiWeight;
  }

  public void setDnAiWeight(String dnAiWeight) {
    this.dnAiWeight = dnAiWeight;
  }

  public IssuedDocument dnAiCausal(String dnAiCausal) {

    this.dnAiCausal = dnAiCausal;
    return this;
  }

  /**
   * Issued document attached delivery note causal
   *
   * @return dnAiCausal
   */
  @javax.annotation.Nullable
  public String getDnAiCausal() {
    return dnAiCausal;
  }

  public void setDnAiCausal(String dnAiCausal) {
    this.dnAiCausal = dnAiCausal;
  }

  public IssuedDocument dnAiDestination(String dnAiDestination) {

    this.dnAiDestination = dnAiDestination;
    return this;
  }

  /**
   * Issued document attached delivery note destination
   *
   * @return dnAiDestination
   */
  @javax.annotation.Nullable
  public String getDnAiDestination() {
    return dnAiDestination;
  }

  public void setDnAiDestination(String dnAiDestination) {
    this.dnAiDestination = dnAiDestination;
  }

  public IssuedDocument dnAiTransporter(String dnAiTransporter) {

    this.dnAiTransporter = dnAiTransporter;
    return this;
  }

  /**
   * Issued document attached delivery note transporter
   *
   * @return dnAiTransporter
   */
  @javax.annotation.Nullable
  public String getDnAiTransporter() {
    return dnAiTransporter;
  }

  public void setDnAiTransporter(String dnAiTransporter) {
    this.dnAiTransporter = dnAiTransporter;
  }

  public IssuedDocument dnAiNotes(String dnAiNotes) {

    this.dnAiNotes = dnAiNotes;
    return this;
  }

  /**
   * Issued document attached delivery note notes
   *
   * @return dnAiNotes
   */
  @javax.annotation.Nullable
  public String getDnAiNotes() {
    return dnAiNotes;
  }

  public void setDnAiNotes(String dnAiNotes) {
    this.dnAiNotes = dnAiNotes;
  }

  public IssuedDocument isMarked(Boolean isMarked) {

    this.isMarked = isMarked;
    return this;
  }

  /**
   * Issued document is marked
   *
   * @return isMarked
   */
  @javax.annotation.Nullable
  public Boolean getIsMarked() {
    return isMarked;
  }

  public void setIsMarked(Boolean isMarked) {
    this.isMarked = isMarked;
  }

  /**
   * [Read only] Issued document total net amount
   *
   * @return amountNet
   */
  @javax.annotation.Nullable
  public BigDecimal getAmountNet() {
    return amountNet;
  }

  /**
   * [Read Only] Issued document total vat amount
   *
   * @return amountVat
   */
  @javax.annotation.Nullable
  public BigDecimal getAmountVat() {
    return amountVat;
  }

  /**
   * [Read Only] Issued document total gross amount
   *
   * @return amountGross
   */
  @javax.annotation.Nullable
  public BigDecimal getAmountGross() {
    return amountGross;
  }

  public IssuedDocument amountDueDiscount(BigDecimal amountDueDiscount) {

    this.amountDueDiscount = amountDueDiscount;
    return this;
  }

  /**
   * Issued document amount due discount
   *
   * @return amountDueDiscount
   */
  @javax.annotation.Nullable
  public BigDecimal getAmountDueDiscount() {
    return amountDueDiscount;
  }

  public void setAmountDueDiscount(BigDecimal amountDueDiscount) {
    this.amountDueDiscount = amountDueDiscount;
  }

  /**
   * [Read Only] Issued document rivalsa amount
   *
   * @return amountRivalsa
   */
  @javax.annotation.Nullable
  public BigDecimal getAmountRivalsa() {
    return amountRivalsa;
  }

  public IssuedDocument amountRivalsaTaxable(BigDecimal amountRivalsaTaxable) {

    this.amountRivalsaTaxable = amountRivalsaTaxable;
    return this;
  }

  /**
   * Issued document taxable rivalsa amount
   *
   * @return amountRivalsaTaxable
   */
  @javax.annotation.Nullable
  public BigDecimal getAmountRivalsaTaxable() {
    return amountRivalsaTaxable;
  }

  public void setAmountRivalsaTaxable(BigDecimal amountRivalsaTaxable) {
    this.amountRivalsaTaxable = amountRivalsaTaxable;
  }

  /**
   * [Read Only] Issued document withholding tax amount (ritenuta d&#39;acconto).
   *
   * @return amountWithholdingTax
   */
  @javax.annotation.Nullable
  public BigDecimal getAmountWithholdingTax() {
    return amountWithholdingTax;
  }

  public IssuedDocument amountWithholdingTaxTaxable(BigDecimal amountWithholdingTaxTaxable) {

    this.amountWithholdingTaxTaxable = amountWithholdingTaxTaxable;
    return this;
  }

  /**
   * Issued document taxable withholding tax amount
   *
   * @return amountWithholdingTaxTaxable
   */
  @javax.annotation.Nullable
  public BigDecimal getAmountWithholdingTaxTaxable() {
    return amountWithholdingTaxTaxable;
  }

  public void setAmountWithholdingTaxTaxable(BigDecimal amountWithholdingTaxTaxable) {
    this.amountWithholdingTaxTaxable = amountWithholdingTaxTaxable;
  }

  /**
   * [Read Only] Issued document other withholding tax amount (altra ritenuta)
   *
   * @return amountOtherWithholdingTax
   */
  @javax.annotation.Nullable
  public BigDecimal getAmountOtherWithholdingTax() {
    return amountOtherWithholdingTax;
  }

  public IssuedDocument amountOtherWithholdingTaxTaxable(
      BigDecimal amountOtherWithholdingTaxTaxable) {

    this.amountOtherWithholdingTaxTaxable = amountOtherWithholdingTaxTaxable;
    return this;
  }

  /**
   * Issued document taxable other withholding tax amount
   *
   * @return amountOtherWithholdingTaxTaxable
   */
  @javax.annotation.Nullable
  public BigDecimal getAmountOtherWithholdingTaxTaxable() {
    return amountOtherWithholdingTaxTaxable;
  }

  public void setAmountOtherWithholdingTaxTaxable(BigDecimal amountOtherWithholdingTaxTaxable) {
    this.amountOtherWithholdingTaxTaxable = amountOtherWithholdingTaxTaxable;
  }

  public IssuedDocument amountEnasarcoTaxable(BigDecimal amountEnasarcoTaxable) {

    this.amountEnasarcoTaxable = amountEnasarcoTaxable;
    return this;
  }

  /**
   * Issued document taxable enasarco amount
   *
   * @return amountEnasarcoTaxable
   */
  @javax.annotation.Nullable
  public BigDecimal getAmountEnasarcoTaxable() {
    return amountEnasarcoTaxable;
  }

  public void setAmountEnasarcoTaxable(BigDecimal amountEnasarcoTaxable) {
    this.amountEnasarcoTaxable = amountEnasarcoTaxable;
  }

  public IssuedDocument extraData(IssuedDocumentExtraData extraData) {

    this.extraData = extraData;
    return this;
  }

  /**
   * Get extraData
   *
   * @return extraData
   */
  @javax.annotation.Nullable
  public IssuedDocumentExtraData getExtraData() {
    return extraData;
  }

  public void setExtraData(IssuedDocumentExtraData extraData) {
    this.extraData = extraData;
  }

  public IssuedDocument seenDate(LocalDate seenDate) {

    this.seenDate = seenDate;
    return this;
  }

  /**
   * Issued document seen date
   *
   * @return seenDate
   */
  @javax.annotation.Nullable
  public LocalDate getSeenDate() {
    return seenDate;
  }

  public void setSeenDate(LocalDate seenDate) {
    this.seenDate = seenDate;
  }

  public IssuedDocument nextDueDate(LocalDate nextDueDate) {

    this.nextDueDate = nextDueDate;
    return this;
  }

  /**
   * Issued document date of the next not paid payment
   *
   * @return nextDueDate
   */
  @javax.annotation.Nullable
  public LocalDate getNextDueDate() {
    return nextDueDate;
  }

  public void setNextDueDate(LocalDate nextDueDate) {
    this.nextDueDate = nextDueDate;
  }

  public IssuedDocument url(String url) {

    this.url = url;
    return this;
  }

  /**
   * [Temporary] [Read Only] Issued document url of the document PDF file
   *
   * @return url
   */
  @javax.annotation.Nullable
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public IssuedDocument dnUrl(String dnUrl) {

    this.dnUrl = dnUrl;
    return this;
  }

  /**
   * [Temporary] [Read Only] Issued document url of the attached delivery note PDF file
   *
   * @return dnUrl
   */
  @javax.annotation.Nullable
  public String getDnUrl() {
    return dnUrl;
  }

  public void setDnUrl(String dnUrl) {
    this.dnUrl = dnUrl;
  }

  public IssuedDocument aiUrl(String aiUrl) {

    this.aiUrl = aiUrl;
    return this;
  }

  /**
   * [Temporary] [Read Only] Issued document url of the accompanying invoice PDF file
   *
   * @return aiUrl
   */
  @javax.annotation.Nullable
  public String getAiUrl() {
    return aiUrl;
  }

  public void setAiUrl(String aiUrl) {
    this.aiUrl = aiUrl;
  }

  /**
   * [Temporary] [Read Only] Issued document url of the attached file
   *
   * @return attachmentUrl
   */
  @javax.annotation.Nullable
  public String getAttachmentUrl() {
    return attachmentUrl;
  }

  public IssuedDocument attachmentToken(String attachmentToken) {

    this.attachmentToken = attachmentToken;
    return this;
  }

  /**
   * [Write Only] Issued document attachment token returned by POST /issued_documents/attachment
   *
   * @return attachmentToken
   */
  @javax.annotation.Nullable
  public String getAttachmentToken() {
    return attachmentToken;
  }

  public void setAttachmentToken(String attachmentToken) {
    this.attachmentToken = attachmentToken;
  }

  public IssuedDocument eiRaw(Object eiRaw) {

    this.eiRaw = eiRaw;
    return this;
  }

  /**
   * Issued document advanced raw attributes for e-invoices
   *
   * @return eiRaw
   */
  @javax.annotation.Nullable
  public Object getEiRaw() {
    return eiRaw;
  }

  public void setEiRaw(Object eiRaw) {
    this.eiRaw = eiRaw;
  }

  public IssuedDocument eiStatus(EiStatusEnum eiStatus) {

    this.eiStatus = eiStatus;
    return this;
  }

  /**
   * [Read only] Status of the e-invoice. * **attempt** - We are trying to send the invoice, please
   * wait up to 2 hours * **missing** - The invoice is missing * **not_sent** - The invoice has yet
   * to be sent * **sent** - The invoice was sent * **pending** - The checks for the digital
   * signature and sending are in progress * **processing** - The SDI is delivering the invoice to
   * the customer * **error** - An error occurred while handling the invoice, please try to resend
   * it or contact support * **discarded** - The invoice has been rejected by the SDI, so it must be
   * corrected and re-sent * **not_delivered** - The SDI was unable to deliver the invoice *
   * **accepted** - The customer accepted the invoice * **rejected** - The customer rejected the
   * invoice, so it must be corrected * **no_response** - A response has not yet been received
   * whithin the deadline, contact the customer to ascertain the status of the invoice *
   * **manual_accepted** - The customer accepted the invoice * **manual_rejected** - The customer
   * rejected the invoice
   *
   * @return eiStatus
   */
  @javax.annotation.Nullable
  public EiStatusEnum getEiStatus() {
    return eiStatus;
  }

  public void setEiStatus(EiStatusEnum eiStatus) {
    this.eiStatus = eiStatus;
  }

  public IssuedDocument locked(Boolean locked) {

    this.locked = locked;
    return this;
  }

  /**
   * Issued Document can&#39;t be edited
   *
   * @return locked
   */
  @javax.annotation.Nullable
  public Boolean getLocked() {
    return locked;
  }

  public void setLocked(Boolean locked) {
    this.locked = locked;
  }

  public IssuedDocument createdAt(String createdAt) {

    this.createdAt = createdAt;
    return this;
  }

  /**
   * Issued document creation date
   *
   * @return createdAt
   */
  @javax.annotation.Nullable
  public String getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(String createdAt) {
    this.createdAt = createdAt;
  }

  public IssuedDocument updatedAt(String updatedAt) {

    this.updatedAt = updatedAt;
    return this;
  }

  /**
   * Issued document last update date
   *
   * @return updatedAt
   */
  @javax.annotation.Nullable
  public String getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(String updatedAt) {
    this.updatedAt = updatedAt;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IssuedDocument issuedDocument = (IssuedDocument) o;
    return Objects.equals(this.id, issuedDocument.id)
        && Objects.equals(this.entity, issuedDocument.entity)
        && Objects.equals(this.type, issuedDocument.type)
        && Objects.equals(this.number, issuedDocument.number)
        && Objects.equals(this.numeration, issuedDocument.numeration)
        && Objects.equals(this.date, issuedDocument.date)
        && Objects.equals(this.year, issuedDocument.year)
        && Objects.equals(this.currency, issuedDocument.currency)
        && Objects.equals(this.language, issuedDocument.language)
        && Objects.equals(this.subject, issuedDocument.subject)
        && Objects.equals(this.visibleSubject, issuedDocument.visibleSubject)
        && Objects.equals(this.rcCenter, issuedDocument.rcCenter)
        && Objects.equals(this.notes, issuedDocument.notes)
        && Objects.equals(this.rivalsa, issuedDocument.rivalsa)
        && Objects.equals(this.cassa, issuedDocument.cassa)
        && Objects.equals(this.amountCassa, issuedDocument.amountCassa)
        && Objects.equals(this.cassaTaxable, issuedDocument.cassaTaxable)
        && Objects.equals(this.amountCassaTaxable, issuedDocument.amountCassaTaxable)
        && Objects.equals(this.cassa2, issuedDocument.cassa2)
        && Objects.equals(this.amountCassa2, issuedDocument.amountCassa2)
        && Objects.equals(this.cassa2Taxable, issuedDocument.cassa2Taxable)
        && Objects.equals(this.amountCassa2Taxable, issuedDocument.amountCassa2Taxable)
        && Objects.equals(this.globalCassaTaxable, issuedDocument.globalCassaTaxable)
        && Objects.equals(this.amountGlobalCassaTaxable, issuedDocument.amountGlobalCassaTaxable)
        && Objects.equals(this.withholdingTax, issuedDocument.withholdingTax)
        && Objects.equals(this.withholdingTaxTaxable, issuedDocument.withholdingTaxTaxable)
        && Objects.equals(this.otherWithholdingTax, issuedDocument.otherWithholdingTax)
        && Objects.equals(this.stampDuty, issuedDocument.stampDuty)
        && Objects.equals(this.paymentMethod, issuedDocument.paymentMethod)
        && Objects.equals(this.useSplitPayment, issuedDocument.useSplitPayment)
        && Objects.equals(this.useGrossPrices, issuedDocument.useGrossPrices)
        && Objects.equals(this.eInvoice, issuedDocument.eInvoice)
        && Objects.equals(this.eiData, issuedDocument.eiData)
        && Objects.equals(this.eiCassaType, issuedDocument.eiCassaType)
        && Objects.equals(this.eiCassa2Type, issuedDocument.eiCassa2Type)
        && Objects.equals(this.eiWithholdingTaxCausal, issuedDocument.eiWithholdingTaxCausal)
        && Objects.equals(this.eiOtherWithholdingTaxType, issuedDocument.eiOtherWithholdingTaxType)
        && Objects.equals(
            this.eiOtherWithholdingTaxCausal, issuedDocument.eiOtherWithholdingTaxCausal)
        && Objects.equals(this.itemsList, issuedDocument.itemsList)
        && Objects.equals(this.paymentsList, issuedDocument.paymentsList)
        && Objects.equals(this.template, issuedDocument.template)
        && Objects.equals(this.deliveryNoteTemplate, issuedDocument.deliveryNoteTemplate)
        && Objects.equals(this.accInvTemplate, issuedDocument.accInvTemplate)
        && Objects.equals(this.hMargins, issuedDocument.hMargins)
        && Objects.equals(this.vMargins, issuedDocument.vMargins)
        && Objects.equals(this.showPayments, issuedDocument.showPayments)
        && Objects.equals(this.showPaymentMethod, issuedDocument.showPaymentMethod)
        && Objects.equals(this.showTotals, issuedDocument.showTotals)
        && Objects.equals(this.showNotificationButton, issuedDocument.showNotificationButton)
        && Objects.equals(this.showTspayButton, issuedDocument.showTspayButton)
        && Objects.equals(this.deliveryNote, issuedDocument.deliveryNote)
        && Objects.equals(this.accompanyingInvoice, issuedDocument.accompanyingInvoice)
        && Objects.equals(this.dnNumber, issuedDocument.dnNumber)
        && Objects.equals(this.dnDate, issuedDocument.dnDate)
        && Objects.equals(this.dnAiPackagesNumber, issuedDocument.dnAiPackagesNumber)
        && Objects.equals(this.dnAiWeight, issuedDocument.dnAiWeight)
        && Objects.equals(this.dnAiCausal, issuedDocument.dnAiCausal)
        && Objects.equals(this.dnAiDestination, issuedDocument.dnAiDestination)
        && Objects.equals(this.dnAiTransporter, issuedDocument.dnAiTransporter)
        && Objects.equals(this.dnAiNotes, issuedDocument.dnAiNotes)
        && Objects.equals(this.isMarked, issuedDocument.isMarked)
        && Objects.equals(this.amountNet, issuedDocument.amountNet)
        && Objects.equals(this.amountVat, issuedDocument.amountVat)
        && Objects.equals(this.amountGross, issuedDocument.amountGross)
        && Objects.equals(this.amountDueDiscount, issuedDocument.amountDueDiscount)
        && Objects.equals(this.amountRivalsa, issuedDocument.amountRivalsa)
        && Objects.equals(this.amountRivalsaTaxable, issuedDocument.amountRivalsaTaxable)
        && Objects.equals(this.amountWithholdingTax, issuedDocument.amountWithholdingTax)
        && Objects.equals(
            this.amountWithholdingTaxTaxable, issuedDocument.amountWithholdingTaxTaxable)
        && Objects.equals(this.amountOtherWithholdingTax, issuedDocument.amountOtherWithholdingTax)
        && Objects.equals(
            this.amountOtherWithholdingTaxTaxable, issuedDocument.amountOtherWithholdingTaxTaxable)
        && Objects.equals(this.amountEnasarcoTaxable, issuedDocument.amountEnasarcoTaxable)
        && Objects.equals(this.extraData, issuedDocument.extraData)
        && Objects.equals(this.seenDate, issuedDocument.seenDate)
        && Objects.equals(this.nextDueDate, issuedDocument.nextDueDate)
        && Objects.equals(this.url, issuedDocument.url)
        && Objects.equals(this.dnUrl, issuedDocument.dnUrl)
        && Objects.equals(this.aiUrl, issuedDocument.aiUrl)
        && Objects.equals(this.attachmentUrl, issuedDocument.attachmentUrl)
        && Objects.equals(this.attachmentToken, issuedDocument.attachmentToken)
        && Objects.equals(this.eiRaw, issuedDocument.eiRaw)
        && Objects.equals(this.eiStatus, issuedDocument.eiStatus)
        && Objects.equals(this.locked, issuedDocument.locked)
        && Objects.equals(this.createdAt, issuedDocument.createdAt)
        && Objects.equals(this.updatedAt, issuedDocument.updatedAt);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b
        || (a != null
            && b != null
            && a.isPresent()
            && b.isPresent()
            && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        id,
        entity,
        type,
        number,
        numeration,
        date,
        year,
        currency,
        language,
        subject,
        visibleSubject,
        rcCenter,
        notes,
        rivalsa,
        cassa,
        amountCassa,
        cassaTaxable,
        amountCassaTaxable,
        cassa2,
        amountCassa2,
        cassa2Taxable,
        amountCassa2Taxable,
        globalCassaTaxable,
        amountGlobalCassaTaxable,
        withholdingTax,
        withholdingTaxTaxable,
        otherWithholdingTax,
        stampDuty,
        paymentMethod,
        useSplitPayment,
        useGrossPrices,
        eInvoice,
        eiData,
        eiCassaType,
        eiCassa2Type,
        eiWithholdingTaxCausal,
        eiOtherWithholdingTaxType,
        eiOtherWithholdingTaxCausal,
        itemsList,
        paymentsList,
        template,
        deliveryNoteTemplate,
        accInvTemplate,
        hMargins,
        vMargins,
        showPayments,
        showPaymentMethod,
        showTotals,
        showNotificationButton,
        showTspayButton,
        deliveryNote,
        accompanyingInvoice,
        dnNumber,
        dnDate,
        dnAiPackagesNumber,
        dnAiWeight,
        dnAiCausal,
        dnAiDestination,
        dnAiTransporter,
        dnAiNotes,
        isMarked,
        amountNet,
        amountVat,
        amountGross,
        amountDueDiscount,
        amountRivalsa,
        amountRivalsaTaxable,
        amountWithholdingTax,
        amountWithholdingTaxTaxable,
        amountOtherWithholdingTax,
        amountOtherWithholdingTaxTaxable,
        amountEnasarcoTaxable,
        extraData,
        seenDate,
        nextDueDate,
        url,
        dnUrl,
        aiUrl,
        attachmentUrl,
        attachmentToken,
        eiRaw,
        eiStatus,
        locked,
        createdAt,
        updatedAt);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[] {a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IssuedDocument {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    entity: ").append(toIndentedString(entity)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    numeration: ").append(toIndentedString(numeration)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    year: ").append(toIndentedString(year)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    visibleSubject: ").append(toIndentedString(visibleSubject)).append("\n");
    sb.append("    rcCenter: ").append(toIndentedString(rcCenter)).append("\n");
    sb.append("    notes: ").append(toIndentedString(notes)).append("\n");
    sb.append("    rivalsa: ").append(toIndentedString(rivalsa)).append("\n");
    sb.append("    cassa: ").append(toIndentedString(cassa)).append("\n");
    sb.append("    amountCassa: ").append(toIndentedString(amountCassa)).append("\n");
    sb.append("    cassaTaxable: ").append(toIndentedString(cassaTaxable)).append("\n");
    sb.append("    amountCassaTaxable: ").append(toIndentedString(amountCassaTaxable)).append("\n");
    sb.append("    cassa2: ").append(toIndentedString(cassa2)).append("\n");
    sb.append("    amountCassa2: ").append(toIndentedString(amountCassa2)).append("\n");
    sb.append("    cassa2Taxable: ").append(toIndentedString(cassa2Taxable)).append("\n");
    sb.append("    amountCassa2Taxable: ")
        .append(toIndentedString(amountCassa2Taxable))
        .append("\n");
    sb.append("    globalCassaTaxable: ").append(toIndentedString(globalCassaTaxable)).append("\n");
    sb.append("    amountGlobalCassaTaxable: ")
        .append(toIndentedString(amountGlobalCassaTaxable))
        .append("\n");
    sb.append("    withholdingTax: ").append(toIndentedString(withholdingTax)).append("\n");
    sb.append("    withholdingTaxTaxable: ")
        .append(toIndentedString(withholdingTaxTaxable))
        .append("\n");
    sb.append("    otherWithholdingTax: ")
        .append(toIndentedString(otherWithholdingTax))
        .append("\n");
    sb.append("    stampDuty: ").append(toIndentedString(stampDuty)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    useSplitPayment: ").append(toIndentedString(useSplitPayment)).append("\n");
    sb.append("    useGrossPrices: ").append(toIndentedString(useGrossPrices)).append("\n");
    sb.append("    eInvoice: ").append(toIndentedString(eInvoice)).append("\n");
    sb.append("    eiData: ").append(toIndentedString(eiData)).append("\n");
    sb.append("    eiCassaType: ").append(toIndentedString(eiCassaType)).append("\n");
    sb.append("    eiCassa2Type: ").append(toIndentedString(eiCassa2Type)).append("\n");
    sb.append("    eiWithholdingTaxCausal: ")
        .append(toIndentedString(eiWithholdingTaxCausal))
        .append("\n");
    sb.append("    eiOtherWithholdingTaxType: ")
        .append(toIndentedString(eiOtherWithholdingTaxType))
        .append("\n");
    sb.append("    eiOtherWithholdingTaxCausal: ")
        .append(toIndentedString(eiOtherWithholdingTaxCausal))
        .append("\n");
    sb.append("    itemsList: ").append(toIndentedString(itemsList)).append("\n");
    sb.append("    paymentsList: ").append(toIndentedString(paymentsList)).append("\n");
    sb.append("    template: ").append(toIndentedString(template)).append("\n");
    sb.append("    deliveryNoteTemplate: ")
        .append(toIndentedString(deliveryNoteTemplate))
        .append("\n");
    sb.append("    accInvTemplate: ").append(toIndentedString(accInvTemplate)).append("\n");
    sb.append("    hMargins: ").append(toIndentedString(hMargins)).append("\n");
    sb.append("    vMargins: ").append(toIndentedString(vMargins)).append("\n");
    sb.append("    showPayments: ").append(toIndentedString(showPayments)).append("\n");
    sb.append("    showPaymentMethod: ").append(toIndentedString(showPaymentMethod)).append("\n");
    sb.append("    showTotals: ").append(toIndentedString(showTotals)).append("\n");
    sb.append("    showNotificationButton: ")
        .append(toIndentedString(showNotificationButton))
        .append("\n");
    sb.append("    showTspayButton: ").append(toIndentedString(showTspayButton)).append("\n");
    sb.append("    deliveryNote: ").append(toIndentedString(deliveryNote)).append("\n");
    sb.append("    accompanyingInvoice: ")
        .append(toIndentedString(accompanyingInvoice))
        .append("\n");
    sb.append("    dnNumber: ").append(toIndentedString(dnNumber)).append("\n");
    sb.append("    dnDate: ").append(toIndentedString(dnDate)).append("\n");
    sb.append("    dnAiPackagesNumber: ").append(toIndentedString(dnAiPackagesNumber)).append("\n");
    sb.append("    dnAiWeight: ").append(toIndentedString(dnAiWeight)).append("\n");
    sb.append("    dnAiCausal: ").append(toIndentedString(dnAiCausal)).append("\n");
    sb.append("    dnAiDestination: ").append(toIndentedString(dnAiDestination)).append("\n");
    sb.append("    dnAiTransporter: ").append(toIndentedString(dnAiTransporter)).append("\n");
    sb.append("    dnAiNotes: ").append(toIndentedString(dnAiNotes)).append("\n");
    sb.append("    isMarked: ").append(toIndentedString(isMarked)).append("\n");
    sb.append("    amountNet: ").append(toIndentedString(amountNet)).append("\n");
    sb.append("    amountVat: ").append(toIndentedString(amountVat)).append("\n");
    sb.append("    amountGross: ").append(toIndentedString(amountGross)).append("\n");
    sb.append("    amountDueDiscount: ").append(toIndentedString(amountDueDiscount)).append("\n");
    sb.append("    amountRivalsa: ").append(toIndentedString(amountRivalsa)).append("\n");
    sb.append("    amountRivalsaTaxable: ")
        .append(toIndentedString(amountRivalsaTaxable))
        .append("\n");
    sb.append("    amountWithholdingTax: ")
        .append(toIndentedString(amountWithholdingTax))
        .append("\n");
    sb.append("    amountWithholdingTaxTaxable: ")
        .append(toIndentedString(amountWithholdingTaxTaxable))
        .append("\n");
    sb.append("    amountOtherWithholdingTax: ")
        .append(toIndentedString(amountOtherWithholdingTax))
        .append("\n");
    sb.append("    amountOtherWithholdingTaxTaxable: ")
        .append(toIndentedString(amountOtherWithholdingTaxTaxable))
        .append("\n");
    sb.append("    amountEnasarcoTaxable: ")
        .append(toIndentedString(amountEnasarcoTaxable))
        .append("\n");
    sb.append("    extraData: ").append(toIndentedString(extraData)).append("\n");
    sb.append("    seenDate: ").append(toIndentedString(seenDate)).append("\n");
    sb.append("    nextDueDate: ").append(toIndentedString(nextDueDate)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    dnUrl: ").append(toIndentedString(dnUrl)).append("\n");
    sb.append("    aiUrl: ").append(toIndentedString(aiUrl)).append("\n");
    sb.append("    attachmentUrl: ").append(toIndentedString(attachmentUrl)).append("\n");
    sb.append("    attachmentToken: ").append(toIndentedString(attachmentToken)).append("\n");
    sb.append("    eiRaw: ").append(toIndentedString(eiRaw)).append("\n");
    sb.append("    eiStatus: ").append(toIndentedString(eiStatus)).append("\n");
    sb.append("    locked: ").append(toIndentedString(locked)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
