/*
 * Decompiled with CFR 0.152.
 */
package it.dex.movingimageviewlib.evaluating.evaluators;

import android.view.View;
import it.dex.movingimageviewlib.evaluating.Evaluator;
import java.util.Timer;
import java.util.TimerTask;

public class TimeEvaluator
extends Evaluator
implements Runnable {
    protected float evaluatedValue;
    private float frequency = 30.0f;
    private final float step = 0.1f;
    private Timer timer;

    public TimeEvaluator(View view) {
        super(view);
    }

    public TimeEvaluator(View view, Evaluator.OnEventOccurred onEventOccurred) {
        super(view, onEventOccurred);
    }

    @Override
    public void onCreate(View view) {
        this.startTimer(this.frequency);
    }

    private void startTimer(float frequency) {
        if (this.getFrequency() != 0.0f) {
            this.stop();
            this.setNotifyEvent(true);
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    TimeEvaluator.this.getView().post((Runnable)TimeEvaluator.this);
                }
            }, 0L, (long)frequency);
        }
    }

    @Override
    public float evaluateX(View view) {
        return this.evaluatedValue;
    }

    @Override
    public float evaluateY(View view) {
        return this.evaluatedValue;
    }

    @Override
    public float evaluateZoom(View view, float defaultZoom) {
        return this.evaluatedValue;
    }

    @Override
    public float evaluateAngle(View view, float defaultAngle) {
        return this.evaluatedValue;
    }

    @Override
    public void onDestroy(View view) {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
        }
        this.timer = null;
    }

    @Override
    public void run() {
        this.evaluatedValue += 0.1f;
        if (this.getOnEventOccurred() != null && this.isNotifyEvent()) {
            if (this.evaluatedValue >= 359.9f) {
                this.getOnEventOccurred().onEventOccurred(this.getView(), this, Evaluator.EVENT_STATUS.END, ++this.endLoopCount);
            } else if (this.evaluatedValue <= 0.1f) {
                this.getOnEventOccurred().onEventOccurred(this.getView(), this, Evaluator.EVENT_STATUS.START, ++this.startLoopCount);
            } else if (this.evaluatedValue + 0.05f >= 180.0f && this.evaluatedValue - 0.05f <= 180.0f) {
                this.getOnEventOccurred().onEventOccurred(this.getView(), this, Evaluator.EVENT_STATUS.MIDDLE, ++this.middleLoopCount);
            } else if (this.evaluatedValue + 0.05f >= 90.0f && this.evaluatedValue - 0.05f <= 90.0f) {
                this.getOnEventOccurred().onEventOccurred(this.getView(), this, Evaluator.EVENT_STATUS.FIRST_QUARTER, ++this.firstQuarterLoopCount);
            } else if (this.evaluatedValue + 0.05f >= 270.0f && this.evaluatedValue - 0.05f <= 270.0f) {
                this.getOnEventOccurred().onEventOccurred(this.getView(), this, Evaluator.EVENT_STATUS.THIRD_QUARTER, ++this.secondQuarterLoopCount);
            }
        }
        if (this.evaluatedValue >= 359.9f) {
            this.evaluatedValue = 0.0f;
        }
        this.getView().invalidate();
    }

    public float getFrequency() {
        return this.frequency;
    }

    public void setFrequency(float frequency) {
        this.frequency = frequency;
        this.restart();
    }
}

