/*
 * Decompiled with CFR 0.152.
 */
package it.dex.movingimageviewlib.evaluating.evaluators;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.view.View;
import it.dex.movingimageviewlib.evaluating.Evaluator;

public class GyroscopeEvaluator
extends Evaluator
implements SensorEventListener {
    private static final float MIN_TIME_STEP = 0.025f;
    private SensorManager mSensorManager;
    private Sensor mGyroSensor;
    private long mLastTime = System.currentTimeMillis();
    private float x;
    private float y;
    private float z;

    public GyroscopeEvaluator(View view) {
        super(view);
    }

    public GyroscopeEvaluator(View view, Evaluator.OnEventOccurred onEventOccurred) {
        super(view, onEventOccurred);
    }

    @Override
    protected void onCreate(View view) {
        this.mSensorManager = (SensorManager)view.getContext().getSystemService("sensor");
        this.mGyroSensor = this.mSensorManager.getDefaultSensor(4);
        this.mSensorManager.registerListener((SensorEventListener)this, this.mGyroSensor, 0);
    }

    @Override
    public float evaluateX(View view) {
        return (int)(this.x * (float)view.getWidth());
    }

    @Override
    public float evaluateY(View view) {
        return (int)(this.y * (float)view.getHeight());
    }

    @Override
    public float evaluateAngle(View view, float defaultAngle) {
        return (float)((double)this.z * 180.0 / Math.PI);
    }

    @Override
    protected void onDestroy(View view) {
        this.mSensorManager.unregisterListener((SensorEventListener)this, this.mGyroSensor);
    }

    public void onSensorChanged(SensorEvent event) {
        float[] values = event.values;
        float x = values[1];
        float y = values[0];
        float z = values[2];
        float angularVelocity = z * 0.96f;
        long now = System.currentTimeMillis();
        float timeDiff = (float)(now - this.mLastTime) / 1000.0f;
        this.mLastTime = now;
        if (timeDiff > 1.0f) {
            timeDiff = 0.025f;
        }
        this.x += x * timeDiff;
        if (this.x > 1.0f) {
            this.x = 1.0f;
        } else if (this.x < -1.0f) {
            this.x = -1.0f;
        }
        this.y += y * timeDiff;
        if (this.y > 1.0f) {
            this.y = 1.0f;
        } else if (this.y < -1.0f) {
            this.y = -1.0f;
        }
        this.z += angularVelocity * timeDiff;
        if (this.x == 0.0f && this.y == 0.0f && this.z == 0.0f && this.getOnEventOccurred() != null && this.isNotifyEvent()) {
            this.getOnEventOccurred().onEventOccurred(this.getView(), this, Evaluator.EVENT_STATUS.MIDDLE, ++this.middleLoopCount);
        }
        this.getView().invalidate();
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }
}

