/*
 * Decompiled with CFR 0.152.
 */
package it.dex.movingimageviewlib.evaluating;

import android.view.View;

public abstract class Evaluator {
    private View view;
    private OnEventOccurred onEventOccurred;
    private boolean notifyEvent = false;
    protected int startLoopCount;
    protected int middleLoopCount;
    protected int endLoopCount;
    protected int firstQuarterLoopCount;
    protected int secondQuarterLoopCount;

    public Evaluator(View view) {
        this.view = view;
    }

    public Evaluator(View view, OnEventOccurred onEventOccurred) {
        this(view);
        this.setOnEventOccurred(onEventOccurred);
    }

    public void start() {
        this.setNotifyEvent(true);
        this.onCreate(this.view);
    }

    protected abstract void onCreate(View var1);

    public abstract float evaluateX(View var1);

    public abstract float evaluateY(View var1);

    public float evaluateZoom(View view, float defaultZoom) {
        return defaultZoom;
    }

    public float evaluateAngle(View view, float defaultAngle) {
        return defaultAngle;
    }

    public void pause() {
        this.onPause(this.view);
    }

    protected void onPause(View view) {
    }

    public void update() {
        this.onUpdate(this.view);
    }

    protected void onUpdate(View view) {
    }

    public void stop() {
        this.setNotifyEvent(false);
        this.onDestroy(this.view);
    }

    protected abstract void onDestroy(View var1);

    protected View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public void restart() {
        this.stop();
        this.start();
    }

    protected OnEventOccurred getOnEventOccurred() {
        return this.onEventOccurred;
    }

    public void setOnEventOccurred(OnEventOccurred onEventOccurred) {
        this.onEventOccurred = onEventOccurred;
    }

    public boolean isNotifyEvent() {
        return this.notifyEvent;
    }

    public void setNotifyEvent(boolean notifyEvent) {
        this.notifyEvent = notifyEvent;
    }

    public static enum EVENT_STATUS {
        START,
        FIRST_QUARTER,
        MIDDLE,
        THIRD_QUARTER,
        END;

    }

    public static interface OnEventOccurred {
        public void onEventOccurred(View var1, Evaluator var2, EVENT_STATUS var3, int var4);
    }
}

