/*
 * Decompiled with CFR 0.152.
 */
package it.dex.movingimageviewlib;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import it.dex.movingimageviewlib.R;
import java.util.List;

public class DexCrossFadeImageView
extends ImageView {
    private int transitionDurationMillis = 300;
    private int stillImageDurationMillis = 3000;
    private int currentPosition = 0;
    private boolean loop = false;
    private Drawable[] drawables;
    private boolean play = false;

    public DexCrossFadeImageView(Context context) {
        this(context, null);
    }

    public DexCrossFadeImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DexCrossFadeImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public DexCrossFadeImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.DexCrossFadeImageView, 0, 0);
            this.setTransitionDurationMillis(a.getInt(R.styleable.DexCrossFadeImageView_transition_duration_millis, this.transitionDurationMillis));
            this.setStillImageDurationMillis(a.getInt(R.styleable.DexCrossFadeImageView_still_image_duration_millis, this.stillImageDurationMillis));
            this.setLoop(a.getBoolean(R.styleable.DexCrossFadeImageView_loop, this.loop));
            int intArrayRes = a.getResourceId(R.styleable.DexCrossFadeImageView_images_array, 0);
            if (intArrayRes != 0) {
                TypedArray images = this.getResources().obtainTypedArray(intArrayRes);
                this.drawables = new Drawable[images.length()];
                for (int i = 0; i < images.length(); ++i) {
                    this.drawables[i] = images.getDrawable(i);
                }
                images.recycle();
                this.start();
            }
            a.recycle();
        }
    }

    private void play() {
        if (this.isPlaying()) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (DexCrossFadeImageView.this.drawables.length > DexCrossFadeImageView.this.currentPosition) {
                        DexCrossFadeImageView.this.setFadingImageDrawable(DexCrossFadeImageView.this.drawables[DexCrossFadeImageView.this.currentPosition]);
                        DexCrossFadeImageView.this.currentPosition++;
                        DexCrossFadeImageView.this.play();
                    } else {
                        DexCrossFadeImageView.this.currentPosition = 0;
                        if (DexCrossFadeImageView.this.isLoop()) {
                            DexCrossFadeImageView.this.play();
                        }
                    }
                }
            }, this.stillImageDurationMillis);
        }
    }

    public void start() {
        if (!this.isPlaying()) {
            this.setPlaying(true);
            this.play();
        }
    }

    public void start(int transitionDurationMillis, int stillImageDurationMillis) {
        this.setTransitionDurationMillis(transitionDurationMillis);
        this.setStillImageDurationMillis(stillImageDurationMillis);
        this.start();
    }

    public void pause() {
        this.setPlaying(false);
    }

    public Drawable[] getImageDrawables() {
        return this.drawables;
    }

    public void setImageDrawables(Drawable[] drawables) {
        this.drawables = drawables;
    }

    public void setImageDrawables(List<Drawable> drawablesList) {
        if (drawablesList != null) {
            Drawable[] drawables = new Drawable[drawablesList.size()];
            drawablesList.toArray(drawables);
            this.setImageDrawables(drawables);
        }
    }

    public void setImageBitmaps(Bitmap[] bitmaps) {
        if (bitmaps != null) {
            Drawable[] drawables = new Drawable[bitmaps.length];
            for (int i = 0; i < bitmaps.length; ++i) {
                drawables[i] = new BitmapDrawable(this.getResources(), bitmaps[i]);
            }
            this.setImageDrawables(drawables);
        }
    }

    public void setImageBitmaps(List<Bitmap> bitmapsList) {
        if (bitmapsList != null) {
            Bitmap[] drawables = new Bitmap[bitmapsList.size()];
            bitmapsList.toArray(drawables);
            this.setImageBitmaps(drawables);
        }
    }

    public void setImageResources(int[] resources) {
        if (resources != null) {
            Drawable[] drawables = new Drawable[resources.length];
            for (int i = 0; i < resources.length; ++i) {
                drawables[i] = this.getResources().getDrawable(resources[i]);
            }
            this.setImageDrawables(drawables);
        }
    }

    public void setImageResources(List<Integer> resourcesList) {
        if (resourcesList != null) {
            int[] drawables = new int[resourcesList.size()];
            for (Integer integer : resourcesList) {
                drawables[resourcesList.indexOf((Object)integer)] = integer;
            }
            this.setImageResources(drawables);
        }
    }

    public void setFadingImageDrawable(Drawable drawable) {
        Drawable currentDrawable = this.getDrawable();
        if (currentDrawable != null && currentDrawable instanceof TransitionDrawable) {
            currentDrawable = ((TransitionDrawable)currentDrawable).getDrawable(1);
        }
        if (currentDrawable != null) {
            Drawable[] arrayDrawable = new Drawable[]{currentDrawable, drawable};
            TransitionDrawable transitionDrawable = new TransitionDrawable(arrayDrawable);
            transitionDrawable.setCrossFadeEnabled(true);
            this.setImageDrawable((Drawable)transitionDrawable);
            transitionDrawable.startTransition(this.transitionDurationMillis);
        } else {
            this.setImageDrawable(drawable);
        }
    }

    public void setFadingImageDrawable(Drawable drawable, int transitionDurationMillis) {
        this.setTransitionDurationMillis(transitionDurationMillis);
        this.setFadingImageDrawable(drawable);
    }

    public void setFadingImageResource(int res) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)res);
        this.setFadingImageBitmap(bitmap);
    }

    public void setFadingImageResource(int res, int transitionDurationMillis) {
        this.setTransitionDurationMillis(transitionDurationMillis);
        this.setFadingImageResource(res);
    }

    public void setFadingImageBitmap(Bitmap bitmap) {
        BitmapDrawable bitmapDrawable = new BitmapDrawable(this.getResources(), bitmap);
        this.setFadingImageDrawable((Drawable)bitmapDrawable);
    }

    public void setFadingImageBitmap(Bitmap bitmap, int transitionDurationMillis) {
        this.setTransitionDurationMillis(transitionDurationMillis);
        this.setFadingImageBitmap(bitmap);
    }

    public void setTransitionDurationMillis(int transitionDurationMillis) {
        this.transitionDurationMillis = transitionDurationMillis;
    }

    public void setStillImageDurationMillis(int stillImageDurationMillis) {
        this.stillImageDurationMillis = stillImageDurationMillis;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public boolean isPlaying() {
        return this.play;
    }

    public void setPlaying(boolean play) {
        this.play = play;
    }
}

