/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.packet;

import java.io.IOException;
import net.tinyos.comm.SerialPort;
import net.tinyos.comm.SerialPortEvent;
import net.tinyos.comm.SerialPortListener;
import net.tinyos.comm.TOSSerial;
import net.tinyos.packet.StreamByteSource;

public class SerialByteSource
extends StreamByteSource
implements SerialPortListener {
    private SerialPort serialPort;
    private String portName;
    private int baudRate;
    Object sync = new Object();

    public SerialByteSource(String string, int n) {
        this.portName = string;
        this.baudRate = n;
    }

    public void openStreams() throws IOException {
        try {
            this.serialPort = new TOSSerial(this.portName);
        }
        catch (Exception exception) {
            throw new IOException("Could not open " + this.portName + ": " + exception.getMessage());
        }
        try {
            this.serialPort.setSerialPortParams(this.baudRate, 8, 1, false);
            this.serialPort.addListener(this);
            this.serialPort.notifyOn(1, true);
            this.serialPort.notifyOn(2, true);
        }
        catch (Exception exception) {
            this.serialPort.close();
            throw new IOException("Could not configure " + this.portName + ": " + exception.getMessage());
        }
        this.is = this.serialPort.getInputStream();
        this.os = this.serialPort.getOutputStream();
    }

    public void closeStreams() throws IOException {
        this.serialPort.close();
    }

    public String allPorts() {
        return "Listing available comm ports is no longer supported.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte() throws IOException {
        Object object = this.sync;
        synchronized (object) {
            while (this.is.available() == 0) {
                try {
                    this.sync.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.close();
                    throw new IOException("interrupted");
                }
            }
        }
        return super.readByte();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialEvent(SerialPortEvent serialPortEvent) {
        if (serialPortEvent.getEventType() == 1) {
            Object object = this.sync;
            synchronized (object) {
                this.sync.notify();
            }
        }
    }

    protected void finalize() {
        this.serialPort.finalize();
    }
}

