/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.comm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.tinyos.comm.ByteQueue;
import net.tinyos.comm.NativeSerial;
import net.tinyos.comm.SerialPort;
import net.tinyos.comm.SerialPortEvent;
import net.tinyos.comm.SerialPortListener;

public class TOSSerial
extends NativeSerial
implements SerialPort {
    private SerialInputStream m_in;
    private SerialOutputStream m_out;
    private Vector m_listeners = new Vector();
    private EventDispatcher m_dispatch;

    static String map_portname(String string, String string2) {
        String[] stringArray = string.split(":");
        Pattern pattern = Pattern.compile("(.*?)=(.*?)");
        Pattern pattern2 = Pattern.compile("(.*\\D)(\\d+)");
        Matcher matcher = pattern2.matcher(string2);
        int n = -1;
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            Matcher matcher2 = pattern.matcher(stringArray[i]);
            if (!matcher2.matches()) continue;
            Matcher matcher3 = pattern2.matcher(matcher2.group(1));
            Matcher matcher4 = pattern2.matcher(matcher2.group(2));
            if (matcher3.matches() && matcher4.matches() && matcher.matches() && matcher3.group(1).equalsIgnoreCase(matcher.group(1))) {
                int n2 = Integer.parseInt(matcher3.group(2));
                int n3 = Integer.parseInt(matcher4.group(2));
                int n4 = Integer.parseInt(matcher.group(2));
                int n5 = n4 - n2 + n3;
                int n6 = n4 - n2;
                if (n6 < 0 || n6 >= n && n != -1) continue;
                n = n6;
                string3 = matcher4.group(1) + n5;
                continue;
            }
            if (!matcher2.group(1).equalsIgnoreCase(string2)) continue;
            n = 0;
            string3 = matcher2.group(2);
        }
        return string3 == null ? string2 : string3;
    }

    public TOSSerial(String string) {
        super(TOSSerial.map_portname(NativeSerial.getTOSCommMap(), string));
        this.m_in = new SerialInputStream();
        this.m_out = new SerialOutputStream();
        this.m_dispatch = new EventDispatcher();
        this.m_dispatch.start();
    }

    public boolean open() {
        if (this.m_dispatch != null) {
            this.m_dispatch.open();
        }
        return super.open();
    }

    public void close() {
        if (this.m_dispatch != null) {
            this.m_dispatch.close();
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SerialPortListener serialPortListener) {
        Vector vector = this.m_listeners;
        synchronized (vector) {
            if (!this.m_listeners.contains(serialPortListener)) {
                this.m_listeners.add(serialPortListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SerialPortListener serialPortListener) {
        Vector vector = this.m_listeners;
        synchronized (vector) {
            this.m_listeners.remove(serialPortListener);
        }
    }

    public InputStream getInputStream() {
        return this.m_in;
    }

    public OutputStream getOutputStream() {
        return this.m_out;
    }

    public void finalize() {
        if (this.m_dispatch != null) {
            this.m_dispatch.close();
        }
        super.close();
        try {
            if (this.m_in != null) {
                this.m_in.close();
            }
            if (this.m_out != null) {
                this.m_out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_dispatch = null;
        this.m_in = null;
        this.m_out = null;
        super.finalize();
    }

    class SerialOutputStream
    extends OutputStream {
        SerialOutputStream() {
        }

        public void write(int n) {
            TOSSerial.this.write(n);
        }

        public void write(byte[] byArray) {
            TOSSerial.this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) {
            for (int i = 0; i < n2; i += TOSSerial.this.write(byArray, i, n2 - i)) {
            }
        }
    }

    class SerialInputStream
    extends InputStream {
        ByteQueue bq = new ByteQueue(128);

        SerialInputStream() {
        }

        protected void gather() {
            int n = TOSSerial.this.available();
            if (n > 0) {
                byte[] byArray = new byte[n];
                this.bq.push_back(byArray, 0, TOSSerial.this.read(byArray, 0, n));
            }
        }

        public int read() {
            this.gather();
            return this.bq.pop_front();
        }

        public int read(byte[] byArray) {
            this.gather();
            return this.bq.pop_front(byArray);
        }

        public int read(byte[] byArray, int n, int n2) {
            this.gather();
            return this.bq.pop_front(byArray, n, n2);
        }

        public int available() {
            this.gather();
            return this.bq.available();
        }
    }

    class EventDispatcher
    extends Thread {
        private boolean m_run = true;
        private boolean busy = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void open() {
            EventDispatcher eventDispatcher = this;
            synchronized (eventDispatcher) {
                this.m_run = true;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.m_run = false;
            EventDispatcher eventDispatcher = this;
            synchronized (eventDispatcher) {
                while (this.busy) {
                    TOSSerial.this.write(126);
                    TOSSerial.this.cancelWait();
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatch_event(int n) {
            if (TOSSerial.this.didEventOccur(n)) {
                SerialPortEvent serialPortEvent = new SerialPortEvent(TOSSerial.this, n);
                Vector vector = TOSSerial.this.m_listeners;
                synchronized (vector) {
                    Iterator iterator = TOSSerial.this.m_listeners.iterator();
                    while (iterator.hasNext()) {
                        ((SerialPortListener)iterator.next()).serialEvent(serialPortEvent);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                EventDispatcher eventDispatcher = this;
                synchronized (eventDispatcher) {
                    while (!this.m_run) {
                        try {
                            this.busy = false;
                            EventDispatcher eventDispatcher2 = this;
                            synchronized (eventDispatcher2) {
                                this.notify();
                            }
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
                this.busy = true;
                if (!TOSSerial.this.waitForEvent()) continue;
                this.dispatch_event(1);
                this.dispatch_event(2);
            }
        }
    }
}

