/*
 * Decompiled with CFR 0.152.
 */
package ir.sohreco.circularpulsingbutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.RequiresApi;
import android.support.annotation.StringRes;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.FrameLayout;
import android.widget.TextView;
import ir.sohreco.circularpulsingbutton.R;

public class CircularPulsingButton
extends FrameLayout {
    private Circle backgroundCircle;
    private TextView tvButtonText;
    private float zoomOutScale;
    private float zoomInScale;
    private int animationDuration;

    public CircularPulsingButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs);
    }

    public CircularPulsingButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs);
    }

    @RequiresApi(api=21)
    public CircularPulsingButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize(context, attrs);
    }

    private void initialize(Context context, AttributeSet attrs) {
        TypedArray arr = context.obtainStyledAttributes(attrs, R.styleable.CircularPulsingButton);
        this.setZoomOutScale(arr.getFloat(R.styleable.CircularPulsingButton_cpb_zoomOutScale, 0.5f));
        this.setZoomInScale(arr.getFloat(R.styleable.CircularPulsingButton_cpb_zoomInScale, 1.1f));
        this.setAnimationDuration(arr.getInt(R.styleable.CircularPulsingButton_cpb_animationDuration, 100));
        this.addBackgroundCircle();
        this.setColor(arr.getColor(R.styleable.CircularPulsingButton_cpb_color, -7829368));
        this.tvButtonText = new TextView(context);
        this.tvButtonText.setText((CharSequence)arr.getString(R.styleable.CircularPulsingButton_cpb_text));
        this.tvButtonText.setTextColor(arr.getColor(R.styleable.CircularPulsingButton_cpb_textColor, -16777216));
        arr.recycle();
    }

    public void setZoomOutScale(float scale) {
        this.zoomOutScale = scale >= 1.0f ? 0.9f : (scale <= 0.0f ? 0.1f : scale);
    }

    public void setZoomInScale(float scale) {
        this.zoomInScale = scale <= 1.0f ? 1.1f : (scale >= 2.0f ? 1.9f : scale);
    }

    public void setAnimationDuration(int duration) {
        this.animationDuration = duration <= 0 ? 100 : duration;
    }

    public void setColor(int color) {
        this.backgroundCircle.setColor(color);
    }

    public void setText(@StringRes int resId) {
        this.tvButtonText.setText(resId);
    }

    public void setText(String text) {
        this.tvButtonText.setText((CharSequence)text);
    }

    public void setTextColor(int color) {
        this.tvButtonText.setTextColor(color);
    }

    public String getText() {
        return this.tvButtonText.getText().toString();
    }

    public float getZoomOutScale() {
        return this.zoomOutScale;
    }

    public float getZoomInScale() {
        return this.zoomInScale;
    }

    public int getAnimationDuration() {
        return this.animationDuration;
    }

    private void addBackgroundCircle() {
        this.backgroundCircle = new Circle(this.getContext(), this.zoomInScale);
        this.backgroundCircle.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                switch (motionEvent.getAction()) {
                    case 0: {
                        CircularPulsingButton.this.scaleView(CircularPulsingButton.this.backgroundCircle, 1.0f, CircularPulsingButton.this.zoomOutScale);
                        CircularPulsingButton.this.scaleView((View)CircularPulsingButton.this.tvButtonText, 1.0f, CircularPulsingButton.this.zoomOutScale);
                        break;
                    }
                    case 1: {
                        CircularPulsingButton.this.scaleView(CircularPulsingButton.this.backgroundCircle, CircularPulsingButton.this.zoomOutScale, 1.0f);
                        CircularPulsingButton.this.scaleView((View)CircularPulsingButton.this.tvButtonText, CircularPulsingButton.this.zoomOutScale, 1.0f);
                        CircularPulsingButton.this.scaleView(CircularPulsingButton.this.backgroundCircle, CircularPulsingButton.this.zoomInScale, 1.0f);
                        CircularPulsingButton.this.scaleView((View)CircularPulsingButton.this.tvButtonText, CircularPulsingButton.this.zoomInScale, 1.0f);
                    }
                }
                return true;
            }
        });
        this.addView(this.backgroundCircle);
        this.backgroundCircle.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                CircularPulsingButton.this.addButtonTextView();
                CircularPulsingButton.this.backgroundCircle.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    private void addButtonTextView() {
        int width = this.backgroundCircle.getWidth() - this.backgroundCircle.getWidth() * 35 / 100;
        int height = this.backgroundCircle.getHeight() - this.backgroundCircle.getHeight() * 50 / 100;
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(width, height, 17);
        this.addView((View)this.tvButtonText, (ViewGroup.LayoutParams)params);
        this.tvButtonText.setGravity(17);
    }

    private void scaleView(View v, float startScale, float endScale) {
        ScaleAnimation anim = new ScaleAnimation(startScale, endScale, startScale, endScale, 0, (float)(v.getWidth() / 2), 0, (float)(v.getHeight() / 2));
        anim.setFillAfter(true);
        anim.setDuration((long)this.animationDuration);
        v.startAnimation((Animation)anim);
    }

    private class Circle
    extends View {
        private Paint paint;
        private float zoomInScale;

        private Circle(Context context, float zoomInScale) {
            super(context);
            this.paint = new Paint();
            this.paint.setColor(-7829368);
            this.paint.setAntiAlias(true);
            this.zoomInScale = zoomInScale;
        }

        private void setColor(int color) {
            this.paint.setColor(color);
            this.invalidate();
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            float cx = canvas.getWidth() / 2;
            float cy = canvas.getHeight() / 2;
            float radius = cx - cx * ((this.zoomInScale - 1.0f) * 100.0f) / 100.0f;
            canvas.drawCircle(cx, cy, radius, this.paint);
        }
    }
}

