/*
 * Decompiled with CFR 0.152.
 */
package ir.sohreco.androidfilechooser;

import android.content.Context;
import android.support.annotation.ColorRes;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import ir.sohreco.androidfilechooser.Item;
import ir.sohreco.androidfilechooser.ItemHolder;
import ir.sohreco.androidfilechooser.R;
import java.util.ArrayList;
import java.util.List;

class ItemsAdapter
extends RecyclerView.Adapter<ItemHolder> {
    private List<Item> items;
    private List<Item> selectedItems;
    private ItemHolder.OnItemClickListener itemClickListener;
    private boolean multipleFileSelectionEnabled;
    @ColorRes
    private int listItemsTextColorResId;

    ItemsAdapter(ItemHolder.OnItemClickListener itemClickListener, boolean multipleFileSelectionEnabled, @ColorRes int listItemsTextColorResId) {
        this.itemClickListener = itemClickListener;
        this.items = new ArrayList<Item>();
        this.multipleFileSelectionEnabled = multipleFileSelectionEnabled;
        if (multipleFileSelectionEnabled) {
            this.selectedItems = new ArrayList<Item>();
        }
        this.listItemsTextColorResId = listItemsTextColorResId;
    }

    void setItems(List<Item> items) {
        this.items = items;
        this.notifyDataSetChanged();
    }

    public ItemHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        return new ItemHolder(inflater.inflate(R.layout.list_item, parent, false), this.itemClickListener, this.listItemsTextColorResId);
    }

    public void onBindViewHolder(ItemHolder holder, int position) {
        Item item = this.items.get(position);
        if (item.isFile() && this.multipleFileSelectionEnabled) {
            holder.bind(this.items.get(position), this.selectedItems);
        } else {
            holder.bind(this.items.get(position));
        }
    }

    String getSelectedItems() {
        StringBuilder builder = new StringBuilder();
        for (Item i : this.selectedItems) {
            builder.append(i.getPath()).append(":");
        }
        return builder.toString();
    }

    public int getItemCount() {
        return this.items.size();
    }
}

