/*
 * Decompiled with CFR 0.152.
 */
package ir.sohreco.androidfilechooser;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.TextView;
import ir.sohreco.androidfilechooser.ExternalStorageNotAvailableException;
import ir.sohreco.androidfilechooser.Item;
import ir.sohreco.androidfilechooser.ItemHolder;
import ir.sohreco.androidfilechooser.ItemsAdapter;
import ir.sohreco.androidfilechooser.R;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

public class FileChooser
extends Fragment
implements ItemHolder.OnItemClickListener,
View.OnClickListener {
    public static final String FILE_NAMES_SEPARATOR = ":";
    private static final String KEY_CHOOSER_TYPE = "chooserType";
    private static final String KEY_FILE_FORMATS = "fileFormats";
    private static final String KEY_MULTIPLE_FILE_SELECTION_ENABLED = "multipleFileSelectionEnabled";
    private static final String KEY_INITIAL_DIRECTORY = "initialDirectory";
    private static final String KEY_SELECT_DIRECTORY_BUTTON_TEXT = "selectDirectoryButtonText";
    private static final String KEY_SELECT_DIRECTORY_BUTTON_TEXT_SIZE = "selectDirectoryButtonTextSize";
    private static final String KEY_SELECT_DIRECTORY_BUTTON_TEXT_COLOR_RES_ID = "selectDirectoryButtonTextColorResId";
    private static final String KEY_SELECT_DIRECTORY_BUTTON_BACKGROUND_RES_ID = "selectDirectoryButtonBackgroundResId";
    private static final String KEY_LIST_ITEMS_TEXT_COLOR_RES_ID = "listItemsTextColorResId";
    private static final String KEY_FILE_ICON_RES_ID = "fileIconResId";
    private static final String KEY_DIRECTORY_ICON_RES_ID = "directoryIconResId";
    private static final String KEY_PREVIOUS_DIRECTORY_BUTTON_ICON_RES_ID = "previousDirectoryButtonIconResId";
    private ImageButton ibPrevDirectory;
    private Button btnSelectDirectory;
    private RecyclerView rvItems;
    private TextView tvCurrentDirectory;
    private ChooserType chooserType;
    private ChooserListener chooserListener;
    private ItemsAdapter itemsAdapter;
    private String currentDirectoryPath;
    private String[] fileFormats;
    private boolean multipleFileSelectionEnabled;
    private String initialDirectory;
    private String selectDirectoryButtonText;
    private float selectDirectoryButtonTextSize;
    @ColorRes
    private int selectDirectoryButtonTextColorResId;
    @DrawableRes
    private int selectDirectoryButtonBackgroundResId;
    @ColorRes
    private int listItemsTextColorResId;
    @DrawableRes
    private int fileIconResId;
    @DrawableRes
    private int directoryIconResId;
    @DrawableRes
    private int previousDirectoryButtonIconResId;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getGivenArguments();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_file_chooser, container, false);
        this.findViews(view);
        this.setListeners();
        if (this.chooserType == ChooserType.DIRECTORY_CHOOSER || this.multipleFileSelectionEnabled) {
            this.btnSelectDirectory.setVisibility(0);
            this.btnSelectDirectory.setText((CharSequence)this.selectDirectoryButtonText);
            if (this.selectDirectoryButtonBackgroundResId != 0) {
                this.btnSelectDirectory.setBackgroundResource(this.selectDirectoryButtonBackgroundResId);
            }
            if (this.selectDirectoryButtonTextColorResId != 0) {
                this.btnSelectDirectory.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)this.selectDirectoryButtonTextColorResId));
            }
            if (this.selectDirectoryButtonTextSize != 0.0f) {
                this.btnSelectDirectory.setTextSize(this.selectDirectoryButtonTextSize);
            }
        }
        this.ibPrevDirectory.setImageResource(this.previousDirectoryButtonIconResId);
        this.itemsAdapter = new ItemsAdapter(this, this.multipleFileSelectionEnabled, this.listItemsTextColorResId);
        this.rvItems.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.rvItems.setAdapter((RecyclerView.Adapter)this.itemsAdapter);
        this.loadItems(this.initialDirectory != null ? this.initialDirectory : Environment.getExternalStorageDirectory().getPath());
        return view;
    }

    @Override
    public void onItemClick(Item item) {
        if (item.isDirectory()) {
            this.loadItems(item.getPath());
        } else {
            this.chooserListener.onSelect(item.getPath());
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.previous_dir_imagebutton) {
            File parent = new File(this.currentDirectoryPath).getParentFile();
            if (parent != null && parent.canRead()) {
                this.loadItems(parent.getPath());
            }
        } else if (id2 == R.id.select_dir_button) {
            if (this.chooserType == ChooserType.DIRECTORY_CHOOSER) {
                this.chooserListener.onSelect(this.currentDirectoryPath);
            } else if (this.multipleFileSelectionEnabled) {
                this.chooserListener.onSelect(this.itemsAdapter.getSelectedItems());
            }
        }
    }

    private void loadItems(String path) {
        this.currentDirectoryPath = path;
        String currentDir = path.substring(path.lastIndexOf(File.separator) + 1);
        this.tvCurrentDirectory.setText((CharSequence)currentDir);
        File[] files = new File(path).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.canRead()) {
                    if (FileChooser.this.chooserType == ChooserType.FILE_CHOOSER && file.isFile()) {
                        if (FileChooser.this.fileFormats != null) {
                            for (String fileFormat : FileChooser.this.fileFormats) {
                                if (!file.getName().endsWith(fileFormat)) continue;
                                return true;
                            }
                            return false;
                        }
                        return true;
                    }
                    return file.isDirectory();
                }
                return false;
            }
        });
        ArrayList<Item> items = new ArrayList<Item>();
        for (File f : files) {
            int drawableId = f.isFile() ? this.fileIconResId : this.directoryIconResId;
            Drawable drawable2 = ContextCompat.getDrawable((Context)this.getActivity().getApplicationContext(), (int)drawableId);
            items.add(new Item(f.getPath(), drawable2));
        }
        Collections.sort(items);
        this.itemsAdapter.setItems(items);
    }

    private void getGivenArguments() {
        Bundle args = this.getArguments();
        this.chooserType = (ChooserType)((Object)args.getSerializable(KEY_CHOOSER_TYPE));
        this.fileFormats = args.getStringArray(KEY_FILE_FORMATS);
        this.multipleFileSelectionEnabled = args.getBoolean(KEY_MULTIPLE_FILE_SELECTION_ENABLED);
        this.initialDirectory = args.getString(KEY_INITIAL_DIRECTORY);
        this.selectDirectoryButtonText = args.getString(KEY_SELECT_DIRECTORY_BUTTON_TEXT);
        this.selectDirectoryButtonTextSize = args.getFloat(KEY_SELECT_DIRECTORY_BUTTON_TEXT_SIZE);
        this.selectDirectoryButtonTextColorResId = args.getInt(KEY_SELECT_DIRECTORY_BUTTON_TEXT_COLOR_RES_ID);
        this.selectDirectoryButtonBackgroundResId = args.getInt(KEY_SELECT_DIRECTORY_BUTTON_BACKGROUND_RES_ID);
        this.listItemsTextColorResId = args.getInt(KEY_LIST_ITEMS_TEXT_COLOR_RES_ID);
        this.fileIconResId = args.getInt(KEY_FILE_ICON_RES_ID);
        this.directoryIconResId = args.getInt(KEY_DIRECTORY_ICON_RES_ID);
        this.previousDirectoryButtonIconResId = args.getInt(KEY_PREVIOUS_DIRECTORY_BUTTON_ICON_RES_ID);
    }

    private void setListeners() {
        this.ibPrevDirectory.setOnClickListener((View.OnClickListener)this);
        this.btnSelectDirectory.setOnClickListener((View.OnClickListener)this);
    }

    private void findViews(View v) {
        this.rvItems = (RecyclerView)v.findViewById(R.id.items_recyclerview);
        this.ibPrevDirectory = (ImageButton)v.findViewById(R.id.previous_dir_imagebutton);
        this.btnSelectDirectory = (Button)v.findViewById(R.id.select_dir_button);
        this.tvCurrentDirectory = (TextView)v.findViewById(R.id.current_dir_textview);
    }

    public static class Builder {
        private ChooserType chooserType;
        private ChooserListener chooserListener;
        private String[] fileFormats;
        private boolean multipleFileSelectionEnabled;
        private String initialDirectory;
        private String selectDirectoryButtonText;
        private float selectDirectoryButtonTextSize;
        @ColorRes
        private int selectDirectoryButtonTextColorResId;
        @DrawableRes
        private int selectDirectoryButtonBackgroundResId;
        @ColorRes
        private int listItemsTextColorResId;
        @DrawableRes
        private int fileIconResId = R.drawable.ic_file;
        @DrawableRes
        private int directoryIconResId = R.drawable.ic_directory;
        @DrawableRes
        private int previousDirectoryButtonIconResId = R.drawable.ic_prev_dir;

        public Builder(ChooserType chooserType, ChooserListener chooserListener) {
            if (chooserType == null) {
                throw new IllegalArgumentException("chooserType can not be null.");
            }
            if (chooserListener == null) {
                throw new IllegalArgumentException("chooserListener can not be null.");
            }
            this.chooserType = chooserType;
            this.chooserListener = chooserListener;
        }

        public Builder setFileFormats(String[] fileFormats) {
            if (this.chooserType == ChooserType.DIRECTORY_CHOOSER) {
                throw new IllegalStateException("Can't set file formats when chooser type is DIRECTORY_CHOOSER.");
            }
            if (fileFormats == null) {
                throw new IllegalArgumentException("File formats can't be null. If you want all types of files to be shown, simply don't set this parameter.");
            }
            if (fileFormats.length == 0) {
                throw new IllegalArgumentException("File formats can't be empty. If you want all types of files to be shown, simply don't set this parameter.");
            }
            this.fileFormats = fileFormats;
            return this;
        }

        public Builder setMultipleFileSelectionEnabled(boolean enabled) {
            if (this.chooserType == ChooserType.DIRECTORY_CHOOSER) {
                throw new IllegalStateException("Multiple file selection can't be enabled when chooser type is DIRECTORY_CHOOSER.");
            }
            this.multipleFileSelectionEnabled = enabled;
            return this;
        }

        public Builder setInitialDirectory(File initialDirectory) {
            if (initialDirectory == null) {
                throw new IllegalArgumentException("initialDirectory can't be null.");
            }
            if (!initialDirectory.exists()) {
                throw new IllegalArgumentException(initialDirectory.getPath() + " Does not exist.");
            }
            if (!initialDirectory.isDirectory()) {
                throw new IllegalArgumentException(initialDirectory.getPath() + " Is not a directory.");
            }
            if (!initialDirectory.canRead()) {
                throw new IllegalArgumentException("Can't access " + initialDirectory.getPath());
            }
            this.initialDirectory = initialDirectory.getPath();
            return this;
        }

        public Builder setSelectMultipleFilesButtonText(String text) {
            if (this.chooserType == ChooserType.DIRECTORY_CHOOSER) {
                throw new IllegalStateException("Can't set select multiple files button's text when chooser type is DIRECTORY_CHOOSER.");
            }
            this.selectDirectoryButtonText = text;
            return this;
        }

        public Builder setSelectMultipleFilesButtonTextSize(float textSize) {
            if (this.chooserType == ChooserType.DIRECTORY_CHOOSER) {
                throw new IllegalStateException("Can't set select multiple files button's text size when chooser type is DIRECTORY_CHOOSER.");
            }
            if (textSize <= 0.0f) {
                throw new IllegalArgumentException("textSize can't be less than or equal to zero.");
            }
            this.selectDirectoryButtonTextSize = textSize;
            return this;
        }

        public Builder setSelectMultipleFilesButtonTextColor(@ColorRes int resId) {
            if (this.chooserType == ChooserType.DIRECTORY_CHOOSER) {
                throw new IllegalStateException("Can't set select multiple files button's text color when chooser type is DIRECTORY_CHOOSER.");
            }
            if (resId <= 0) {
                throw new IllegalArgumentException("resId can't be less than or equal to zero.");
            }
            this.selectDirectoryButtonTextColorResId = resId;
            return this;
        }

        public Builder setSelectMultipleFilesButtonBackground(@DrawableRes int resId) {
            if (this.chooserType == ChooserType.DIRECTORY_CHOOSER) {
                throw new IllegalStateException("Can't set select multiple files button's background when chooser type is DIRECTORY_CHOOSER.");
            }
            if (resId <= 0) {
                throw new IllegalArgumentException("resId can't be less than or equal to zero.");
            }
            this.selectDirectoryButtonBackgroundResId = resId;
            return this;
        }

        public Builder setSelectDirectoryButtonText(String text) {
            if (this.chooserType == ChooserType.FILE_CHOOSER) {
                throw new IllegalStateException("Can't set select directory button's text when chooser type is FILE_CHOOSER.");
            }
            this.selectDirectoryButtonText = text;
            return this;
        }

        public Builder setSelectDirectoryButtonTextSize(float textSize) {
            if (this.chooserType == ChooserType.FILE_CHOOSER) {
                throw new IllegalStateException("Can't set select directory button's text size when chooser type is FILE_CHOOSER.");
            }
            if (textSize <= 0.0f) {
                throw new IllegalArgumentException("textSize can't be less than or equal to zero.");
            }
            this.selectDirectoryButtonTextSize = textSize;
            return this;
        }

        public Builder setSelectDirectoryButtonTextColor(@ColorRes int resId) {
            if (this.chooserType == ChooserType.FILE_CHOOSER) {
                throw new IllegalStateException("Can't set select directory button's text color when chooser type is FILE_CHOOSER.");
            }
            if (resId <= 0) {
                throw new IllegalArgumentException("resId can't be less than or equal to zero.");
            }
            this.selectDirectoryButtonTextColorResId = resId;
            return this;
        }

        public Builder setSelectDirectoryButtonBackground(@DrawableRes int resId) {
            if (this.chooserType == ChooserType.FILE_CHOOSER) {
                throw new IllegalStateException("Can't set select directory button's background when chooser type is FILE_CHOOSER.");
            }
            if (resId <= 0) {
                throw new IllegalArgumentException("resId can't be less than or equal to zero.");
            }
            this.selectDirectoryButtonBackgroundResId = resId;
            return this;
        }

        public Builder setListItemsTextColor(@ColorRes int resId) {
            if (resId <= 0) {
                throw new IllegalArgumentException("resId can't be less than or equal to zero.");
            }
            this.listItemsTextColorResId = resId;
            return this;
        }

        public Builder setFileIcon(@DrawableRes int resId) {
            if (this.chooserType == ChooserType.DIRECTORY_CHOOSER) {
                throw new IllegalStateException("Can't set file icon when chooser type is DIRECTORY_CHOOSER.");
            }
            if (resId <= 0) {
                throw new IllegalArgumentException("resId can't be less than or equal to zero.");
            }
            this.fileIconResId = resId;
            return this;
        }

        public Builder setDirectoryIcon(@DrawableRes int resId) {
            if (resId <= 0) {
                throw new IllegalArgumentException("resId can't be less than or equal to zero.");
            }
            this.directoryIconResId = resId;
            return this;
        }

        public Builder setPreviousDirectoryButtonIcon(@DrawableRes int resId) {
            if (resId <= 0) {
                throw new IllegalArgumentException("resId can't be less than or equal to zero.");
            }
            this.previousDirectoryButtonIconResId = resId;
            return this;
        }

        public FileChooser build() throws ExternalStorageNotAvailableException {
            boolean externalStorageAvailable;
            String externalStorageState = Environment.getExternalStorageState();
            boolean bl = externalStorageAvailable = externalStorageState.equals("mounted") || externalStorageState.equals("mounted_ro");
            if (!externalStorageAvailable) {
                throw new ExternalStorageNotAvailableException();
            }
            FileChooser fragment = new FileChooser();
            Bundle args = new Bundle();
            args.putSerializable(FileChooser.KEY_CHOOSER_TYPE, (Serializable)((Object)this.chooserType));
            fragment.chooserListener = this.chooserListener;
            args.putStringArray(FileChooser.KEY_FILE_FORMATS, this.fileFormats);
            args.putBoolean(FileChooser.KEY_MULTIPLE_FILE_SELECTION_ENABLED, this.multipleFileSelectionEnabled);
            args.putString(FileChooser.KEY_INITIAL_DIRECTORY, this.initialDirectory);
            args.putString(FileChooser.KEY_SELECT_DIRECTORY_BUTTON_TEXT, this.selectDirectoryButtonText);
            args.putFloat(FileChooser.KEY_SELECT_DIRECTORY_BUTTON_TEXT_SIZE, this.selectDirectoryButtonTextSize);
            args.putInt(FileChooser.KEY_SELECT_DIRECTORY_BUTTON_TEXT_COLOR_RES_ID, this.selectDirectoryButtonTextColorResId);
            args.putInt(FileChooser.KEY_SELECT_DIRECTORY_BUTTON_BACKGROUND_RES_ID, this.selectDirectoryButtonBackgroundResId);
            args.putInt(FileChooser.KEY_LIST_ITEMS_TEXT_COLOR_RES_ID, this.listItemsTextColorResId);
            args.putInt(FileChooser.KEY_FILE_ICON_RES_ID, this.fileIconResId);
            args.putInt(FileChooser.KEY_DIRECTORY_ICON_RES_ID, this.directoryIconResId);
            args.putInt(FileChooser.KEY_PREVIOUS_DIRECTORY_BUTTON_ICON_RES_ID, this.previousDirectoryButtonIconResId);
            fragment.setArguments(args);
            return fragment;
        }
    }

    public static enum ChooserType {
        FILE_CHOOSER,
        DIRECTORY_CHOOSER;

    }

    public static interface ChooserListener
    extends Serializable {
        public void onSelect(String var1);
    }
}

