/*
 * Decompiled with CFR 0.152.
 */
package ir.sohreco.androidfilechooser;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatDialogFragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import ir.sohreco.androidfilechooser.ExternalStorageNotAvailableException;
import ir.sohreco.androidfilechooser.Item;
import ir.sohreco.androidfilechooser.ItemHolder;
import ir.sohreco.androidfilechooser.ItemsAdapter;
import ir.sohreco.androidfilechooser.R;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

public class FileChooserDialog
extends AppCompatDialogFragment
implements ItemHolder.OnItemClickListener,
View.OnClickListener {
    private static final String KEY_CHOOSER_TYPE = "chooserType";
    private static final String KEY_CHOOSER_LISTENER = "chooserListener";
    private static final String KEY_TITLE = "title";
    private static final String KEY_FILE_FORMATS = "fileFormats";
    private static final String KEY_FILE_ICON_ID = "fileIconId";
    private static final String KEY_DIRECTORY_ICON_ID = "directoryIconId";
    private static final String KEY_PREVIOUS_DIRECTORY_BUTTON_ICON_ID = "previousDirectoryButtonIconId";
    private Button btnPrevDir;
    private Button btnSelectDir;
    private RecyclerView rvItems;
    private TextView tvCurrentDir;
    private ChooserType chooserType;
    private ChooserListener chooserListener;
    private ItemsAdapter itemsAdapter;
    private String[] fileFormats;
    private String currentDirPath;
    private String title;
    @DrawableRes
    private int directoryIconId;
    @DrawableRes
    private int fileIconId;
    @DrawableRes
    private int previousDirectoryButtonIconId;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getGivenArguments();
        if (this.title == null) {
            this.setStyle(1, 0);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_chooser, container, false);
        this.findViews(view);
        this.setListeners();
        this.getDialog().setTitle((CharSequence)this.title);
        if (this.chooserType == ChooserType.DIRECTORY_CHOOSER) {
            this.btnSelectDir.setVisibility(0);
        }
        this.btnPrevDir.setBackgroundResource(this.previousDirectoryButtonIconId);
        this.itemsAdapter = new ItemsAdapter(this);
        this.rvItems.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.rvItems.setAdapter((RecyclerView.Adapter)this.itemsAdapter);
        this.loadItems(Environment.getExternalStorageDirectory().getPath());
        return view;
    }

    @Override
    public void onItemClick(Item item) {
        if (item.isDirectory()) {
            this.loadItems(item.getPath());
        } else {
            this.chooserListener.onSelect(item.getPath());
            this.dismiss();
        }
    }

    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.previous_dir_imagebutton) {
            String parent = new File(this.currentDirPath).getParent();
            if (parent != null) {
                this.loadItems(parent);
            }
        } else if (i == R.id.select_dir_button) {
            this.chooserListener.onSelect(this.currentDirPath);
            this.dismiss();
        }
    }

    private void loadItems(String path) {
        this.currentDirPath = path;
        String currentDir = path.substring(path.lastIndexOf("/") + 1);
        this.tvCurrentDir.setText((CharSequence)currentDir);
        File[] files = new File(path).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.canRead()) {
                    if (FileChooserDialog.this.chooserType == ChooserType.FILE_CHOOSER && file.isFile()) {
                        if (FileChooserDialog.this.fileFormats != null) {
                            for (String fileFormat : FileChooserDialog.this.fileFormats) {
                                if (!file.getName().endsWith(fileFormat)) continue;
                                return true;
                            }
                            return false;
                        }
                        return true;
                    }
                    return file.isDirectory();
                }
                return false;
            }
        });
        ArrayList<Item> items = new ArrayList<Item>();
        for (File f : files) {
            int drawableId = f.isFile() ? this.fileIconId : this.directoryIconId;
            Drawable drawable2 = ContextCompat.getDrawable((Context)this.getActivity().getApplicationContext(), (int)drawableId);
            items.add(new Item(f.getPath(), drawable2));
        }
        Collections.sort(items);
        this.itemsAdapter.setItems(items);
    }

    private void getGivenArguments() {
        Bundle args = this.getArguments();
        this.chooserType = (ChooserType)((Object)args.getSerializable(KEY_CHOOSER_TYPE));
        this.chooserListener = (ChooserListener)args.getSerializable(KEY_CHOOSER_LISTENER);
        this.title = args.getString(KEY_TITLE);
        this.fileFormats = args.getStringArray(KEY_FILE_FORMATS);
        this.fileIconId = args.getInt(KEY_FILE_ICON_ID);
        this.directoryIconId = args.getInt(KEY_DIRECTORY_ICON_ID);
        this.previousDirectoryButtonIconId = args.getInt(KEY_PREVIOUS_DIRECTORY_BUTTON_ICON_ID);
    }

    private void setListeners() {
        this.btnPrevDir.setOnClickListener((View.OnClickListener)this);
        this.btnSelectDir.setOnClickListener((View.OnClickListener)this);
    }

    private void findViews(View v) {
        this.rvItems = (RecyclerView)v.findViewById(R.id.items_recyclerview);
        this.btnPrevDir = (Button)v.findViewById(R.id.previous_dir_imagebutton);
        this.btnSelectDir = (Button)v.findViewById(R.id.select_dir_button);
        this.tvCurrentDir = (TextView)v.findViewById(R.id.current_dir_textview);
    }

    public static class Builder {
        private ChooserType chooserType;
        private ChooserListener chooserListener;
        private String[] fileFormats;
        private String title;
        @DrawableRes
        private int fileIconId = R.drawable.ic_file;
        @DrawableRes
        private int directoryIconId = R.drawable.ic_directory;
        @DrawableRes
        private int previousDirectoryButtonIcon = R.drawable.ic_prev_dir;

        public Builder(ChooserType chooserType, ChooserListener chooserListener) {
            this.chooserType = chooserType;
            this.chooserListener = chooserListener;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setFileFormats(String[] fileFormats) {
            this.fileFormats = fileFormats;
            return this;
        }

        public Builder setFileIcon(@DrawableRes int fileIconId) {
            this.fileIconId = fileIconId;
            return this;
        }

        public Builder setDirectoryIcon(@DrawableRes int directoryIconId) {
            this.directoryIconId = directoryIconId;
            return this;
        }

        public Builder setPreviousDirectoryButtonIcon(@DrawableRes int previousDirectoryButtonIcon) {
            this.previousDirectoryButtonIcon = previousDirectoryButtonIcon;
            return this;
        }

        public FileChooserDialog build() throws ExternalStorageNotAvailableException {
            boolean externalStorageAvailable;
            String externalStorageState = Environment.getExternalStorageState();
            boolean bl = externalStorageAvailable = externalStorageState.equals("mounted") || externalStorageState.equals("mounted_ro");
            if (!externalStorageAvailable) {
                throw new ExternalStorageNotAvailableException();
            }
            FileChooserDialog fragment = new FileChooserDialog();
            Bundle args = new Bundle();
            args.putSerializable(FileChooserDialog.KEY_CHOOSER_TYPE, (Serializable)((Object)this.chooserType));
            args.putSerializable(FileChooserDialog.KEY_CHOOSER_LISTENER, (Serializable)this.chooserListener);
            args.putString(FileChooserDialog.KEY_TITLE, this.title);
            args.putStringArray(FileChooserDialog.KEY_FILE_FORMATS, this.fileFormats);
            args.putInt(FileChooserDialog.KEY_FILE_ICON_ID, this.fileIconId);
            args.putInt(FileChooserDialog.KEY_DIRECTORY_ICON_ID, this.directoryIconId);
            args.putInt(FileChooserDialog.KEY_PREVIOUS_DIRECTORY_BUTTON_ICON_ID, this.previousDirectoryButtonIcon);
            fragment.setArguments(args);
            return fragment;
        }
    }

    public static enum ChooserType {
        FILE_CHOOSER,
        DIRECTORY_CHOOSER;

    }

    public static interface ChooserListener
    extends Serializable {
        public void onSelect(String var1);
    }
}

