/*
 * Decompiled with CFR 0.152.
 */
package ir.mstajbakhsh.livehiddencamera.LiveBroadcaster;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import com.github.faucamp.simplertmp.DefaultRtmpPublisher;
import com.github.faucamp.simplertmp.RtmpHandler;
import ir.mstajbakhsh.livehiddencamera.LiveBroadcaster.SrsAllocator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class SrsFlvMuxer {
    private static final int VIDEO_ALLOC_SIZE = 131072;
    private static final int AUDIO_ALLOC_SIZE = 4096;
    private static final int VIDEO_TRACK = 100;
    private static final int AUDIO_TRACK = 101;
    private static final String TAG = "SrsFlvMuxer";
    private final Object txFrameLock = new Object();
    private volatile boolean started = false;
    private DefaultRtmpPublisher publisher;
    private Thread worker;
    private SrsFlv flv = new SrsFlv();
    private boolean needToFindKeyFrame = true;
    private SrsFlvFrame mVideoSequenceHeader;
    private SrsFlvFrame mAudioSequenceHeader;
    private SrsAllocator mVideoAllocator = new SrsAllocator(131072);
    private SrsAllocator mAudioAllocator = new SrsAllocator(4096);
    private ConcurrentLinkedQueue<SrsFlvFrame> mFlvTagCache = new ConcurrentLinkedQueue();

    public SrsFlvMuxer(RtmpHandler handler) {
        this.publisher = new DefaultRtmpPublisher(handler);
    }

    public AtomicInteger getVideoFrameCacheNumber() {
        return this.publisher == null ? null : this.publisher.getVideoFrameCacheNumber();
    }

    public void setVideoResolution(int width, int height) {
        if (this.publisher != null) {
            this.publisher.setVideoResolution(width, height);
        }
    }

    public int addTrack(MediaFormat format) {
        if (format.getString("mime").contentEquals("video/avc")) {
            this.flv.setVideoTrack(format);
            return 100;
        }
        this.flv.setAudioTrack(format);
        return 101;
    }

    private void disconnect() {
        try {
            this.publisher.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.mVideoSequenceHeader = null;
        this.mAudioSequenceHeader = null;
        Log.i((String)TAG, (String)"worker: disconnect ok.");
    }

    private boolean connect(String url) {
        boolean connected = false;
        Log.i((String)TAG, (String)String.format("worker: connecting to RTMP server by url=%s\n", url));
        if (this.publisher.connect(url)) {
            connected = this.publisher.publish("live");
        }
        this.mVideoSequenceHeader = null;
        this.mAudioSequenceHeader = null;
        return connected;
    }

    private void sendFlvTag(SrsFlvFrame frame) {
        if (frame == null) {
            return;
        }
        if (frame.isVideo()) {
            if (frame.isKeyFrame()) {
                Log.i((String)TAG, (String)String.format("worker: send frame type=%d, dts=%d, size=%dB", frame.type, frame.dts, frame.flvTag.array().length));
            }
            this.publisher.publishVideoData(frame.flvTag.array(), frame.flvTag.size(), frame.dts);
            this.mVideoAllocator.release(frame.flvTag);
        } else if (frame.isAudio()) {
            this.publisher.publishAudioData(frame.flvTag.array(), frame.flvTag.size(), frame.dts);
            this.mAudioAllocator.release(frame.flvTag);
        }
    }

    public void start(final String rtmpUrl) {
        this.started = true;
        this.worker = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!SrsFlvMuxer.this.connect(rtmpUrl)) {
                    return;
                }
                while (!Thread.interrupted()) {
                    while (!SrsFlvMuxer.this.mFlvTagCache.isEmpty()) {
                        SrsFlvFrame frame = (SrsFlvFrame)SrsFlvMuxer.this.mFlvTagCache.poll();
                        if (frame.isSequenceHeader()) {
                            if (frame.isVideo()) {
                                SrsFlvMuxer.this.mVideoSequenceHeader = frame;
                                SrsFlvMuxer.this.sendFlvTag(SrsFlvMuxer.this.mVideoSequenceHeader);
                                continue;
                            }
                            if (!frame.isAudio()) continue;
                            SrsFlvMuxer.this.mAudioSequenceHeader = frame;
                            SrsFlvMuxer.this.sendFlvTag(SrsFlvMuxer.this.mAudioSequenceHeader);
                            continue;
                        }
                        if (frame.isVideo() && SrsFlvMuxer.this.mVideoSequenceHeader != null) {
                            SrsFlvMuxer.this.sendFlvTag(frame);
                            continue;
                        }
                        if (!frame.isAudio() || SrsFlvMuxer.this.mAudioSequenceHeader == null) continue;
                        SrsFlvMuxer.this.sendFlvTag(frame);
                    }
                    Object object = SrsFlvMuxer.this.txFrameLock;
                    synchronized (object) {
                        try {
                            SrsFlvMuxer.this.txFrameLock.wait(500L);
                        }
                        catch (InterruptedException ie) {
                            SrsFlvMuxer.this.worker.interrupt();
                        }
                    }
                }
            }
        });
        this.worker.start();
    }

    public void stop() {
        this.started = false;
        this.mFlvTagCache.clear();
        if (this.worker != null) {
            this.worker.interrupt();
            try {
                this.worker.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.worker.interrupt();
            }
            this.worker = null;
        }
        this.flv.reset();
        this.needToFindKeyFrame = true;
        Log.i((String)TAG, (String)"SrsFlvMuxer closed");
        new Thread(new Runnable(){

            @Override
            public void run() {
                SrsFlvMuxer.this.disconnect();
            }
        }).start();
    }

    public void writeSampleData(int trackIndex, ByteBuffer byteBuf, MediaCodec.BufferInfo bufferInfo) {
        if (bufferInfo.offset > 0) {
            Log.w((String)TAG, (String)String.format("encoded frame %dB, offset=%d pts=%dms", bufferInfo.size, bufferInfo.offset, bufferInfo.presentationTimeUs / 1000L));
        }
        if (100 == trackIndex) {
            this.flv.writeVideoSample(byteBuf, bufferInfo);
        } else {
            this.flv.writeAudioSample(byteBuf, bufferInfo);
        }
    }

    private class SrsFlv {
        private MediaFormat videoTrack;
        private MediaFormat audioTrack;
        private int achannel;
        private int asample_rate;
        private SrsRawH264Stream avc;
        private ArrayList<SrsFlvFrameBytes> ipbs;
        private SrsAllocator.Allocation audio_tag;
        private SrsAllocator.Allocation video_tag;
        private ByteBuffer h264_sps;
        private boolean h264_sps_changed;
        private ByteBuffer h264_pps;
        private boolean h264_pps_changed;
        private boolean h264_sps_pps_sent;
        private boolean aac_specific_config_got;

        public SrsFlv() {
            this.avc = new SrsRawH264Stream();
            this.ipbs = new ArrayList();
            this.reset();
        }

        public void reset() {
            this.h264_sps_changed = false;
            this.h264_pps_changed = false;
            this.h264_sps_pps_sent = false;
            this.aac_specific_config_got = false;
            if (null != this.h264_sps) {
                Arrays.fill(this.h264_sps.array(), (byte)0);
                this.h264_sps.clear();
            }
            if (null != this.h264_pps) {
                Arrays.fill(this.h264_pps.array(), (byte)0);
                this.h264_pps.clear();
            }
        }

        public void setVideoTrack(MediaFormat format) {
            this.videoTrack = format;
        }

        public void setAudioTrack(MediaFormat format) {
            this.audioTrack = format;
            this.achannel = format.getInteger("channel-count");
            this.asample_rate = format.getInteger("sample-rate");
        }

        public void writeAudioSample(ByteBuffer bb, MediaCodec.BufferInfo bi) {
            int pts;
            int dts = pts = (int)(bi.presentationTimeUs / 1000L);
            this.audio_tag = SrsFlvMuxer.this.mAudioAllocator.allocate(bi.size + 2);
            byte aac_packet_type = 1;
            if (!this.aac_specific_config_got) {
                byte ch = (byte)(bb.get(0) & 0xF8);
                int samplingFrequencyIndex = 4;
                if (this.asample_rate == 22050) {
                    samplingFrequencyIndex = 7;
                } else if (this.asample_rate == 11025) {
                    samplingFrequencyIndex = 10;
                } else if (this.asample_rate == 32000) {
                    samplingFrequencyIndex = 5;
                } else if (this.asample_rate == 16000) {
                    samplingFrequencyIndex = 8;
                }
                ch = (byte)(ch | samplingFrequencyIndex >> 1 & 7);
                this.audio_tag.put(ch, 2);
                ch = (byte)(samplingFrequencyIndex << 7 & 0x80);
                int channelConfiguration = 1;
                if (this.achannel == 2) {
                    channelConfiguration = 2;
                }
                ch = (byte)(ch | channelConfiguration << 3 & 0x78);
                this.audio_tag.put(ch, 3);
                this.aac_specific_config_got = true;
                aac_packet_type = 0;
                this.writeAdtsHeader(this.audio_tag.array(), 4);
                this.audio_tag.appendOffset(7);
            } else {
                bb.get(this.audio_tag.array(), 2, bi.size);
                this.audio_tag.appendOffset(bi.size + 2);
            }
            int sound_format = 10;
            boolean sound_type = false;
            if (this.achannel == 2) {
                sound_type = true;
            }
            int sound_size = 1;
            int sound_rate = 3;
            if (this.asample_rate == 22050) {
                sound_rate = 2;
            } else if (this.asample_rate == 11025) {
                sound_rate = 1;
            } else if (this.asample_rate == 5512) {
                sound_rate = 0;
            }
            byte audio_header = (byte)((sound_type ? 1 : 0) & 1);
            audio_header = (byte)(audio_header | sound_size << 1 & 2);
            audio_header = (byte)(audio_header | sound_rate << 2 & 0xC);
            audio_header = (byte)(audio_header | sound_format << 4 & 0xF0);
            this.audio_tag.put(audio_header, 0);
            this.audio_tag.put(aac_packet_type, 1);
            this.writeRtmpPacket(8, dts, 0, aac_packet_type, this.audio_tag);
        }

        private void writeAdtsHeader(byte[] frame, int offset) {
            frame[offset] = -1;
            frame[offset + 1] = -16;
            int n = offset + 1;
            frame[n] = (byte)(frame[n] | 0);
            int n2 = offset + 1;
            frame[n2] = (byte)(frame[n2] | 0);
            int n3 = offset + 1;
            frame[n3] = (byte)(frame[n3] | 1);
            frame[offset + 2] = 64;
            int n4 = offset + 2;
            frame[n4] = (byte)(frame[n4] | 0x10);
            int n5 = offset + 2;
            frame[n5] = (byte)(frame[n5] | 0);
            frame[offset + 3] = -128;
            int n6 = offset + 3;
            frame[n6] = (byte)(frame[n6] | 0);
            int n7 = offset + 3;
            frame[n7] = (byte)(frame[n7] | 0);
            int n8 = offset + 3;
            frame[n8] = (byte)(frame[n8] | 0);
            int n9 = offset + 3;
            frame[n9] = (byte)(frame[n9] | 0);
            int n10 = offset + 3;
            frame[n10] = (byte)(frame[n10] | (frame.length - 2 & 0x1800) >> 11);
            frame[offset + 4] = (byte)((frame.length - 2 & 0x7F8) >> 3);
            frame[offset + 5] = (byte)((frame.length - 2 & 7) << 5);
            int n11 = offset + 5;
            frame[n11] = (byte)(frame[n11] | 0x1F);
            frame[offset + 6] = -4;
            int n12 = offset + 6;
            frame[n12] = (byte)(frame[n12] | 0);
        }

        public void writeVideoSample(ByteBuffer bb, MediaCodec.BufferInfo bi) {
            int pts;
            if (bi.size < 4) {
                return;
            }
            int dts = pts = (int)(bi.presentationTimeUs / 1000L);
            int type = 2;
            SrsFlvFrameBytes frame = this.avc.demuxAnnexb(bb, bi, true);
            int nal_unit_type = frame.data.get(0) & 0x1F;
            if (nal_unit_type == 5) {
                type = 1;
            } else {
                if (nal_unit_type == 7 || nal_unit_type == 8) {
                    SrsFlvFrameBytes frame_pps = this.avc.demuxAnnexb(bb, bi, false);
                    frame.size = frame.size - frame_pps.size - 4;
                    if (!frame.data.equals(this.h264_sps)) {
                        byte[] sps = new byte[frame.size];
                        frame.data.get(sps);
                        this.h264_sps_changed = true;
                        this.h264_sps = ByteBuffer.wrap(sps);
                    }
                    SrsFlvFrameBytes frame_sei = this.avc.demuxAnnexb(bb, bi, false);
                    if (frame_sei.size > 0 && 6 == (frame_sei.data.get(0) & 0x1F)) {
                        frame_pps.size = frame_pps.size - frame_sei.size - 3;
                    }
                    if (!frame_pps.data.equals(this.h264_pps)) {
                        byte[] pps = new byte[frame_pps.size];
                        frame_pps.data.get(pps);
                        this.h264_pps_changed = true;
                        this.h264_pps = ByteBuffer.wrap(pps);
                        this.writeH264SpsPps(dts, pts);
                    }
                    return;
                }
                if (nal_unit_type != 1) {
                    return;
                }
            }
            this.ipbs.add(this.avc.muxNaluHeader(frame));
            this.ipbs.add(frame);
            this.writeH264IpbFrame(this.ipbs, type, dts, pts);
            this.ipbs.clear();
        }

        private void writeH264SpsPps(int dts, int pts) {
            if (this.h264_sps_pps_sent && !this.h264_sps_changed && !this.h264_pps_changed) {
                return;
            }
            if (this.h264_pps == null || this.h264_sps == null) {
                return;
            }
            ArrayList<SrsFlvFrameBytes> frames = new ArrayList<SrsFlvFrameBytes>();
            this.avc.muxSequenceHeader(this.h264_sps, this.h264_pps, dts, pts, frames);
            int frame_type = 1;
            int avc_packet_type = 0;
            this.video_tag = this.avc.muxFlvTag(frames, frame_type, avc_packet_type, dts, pts);
            this.writeRtmpPacket(9, dts, frame_type, avc_packet_type, this.video_tag);
            this.h264_sps_changed = false;
            this.h264_pps_changed = false;
            this.h264_sps_pps_sent = true;
            Log.i((String)SrsFlvMuxer.TAG, (String)String.format("flv: h264 sps/pps sent, sps=%dB, pps=%dB", this.h264_sps.array().length, this.h264_pps.array().length));
        }

        private void writeH264IpbFrame(ArrayList<SrsFlvFrameBytes> frames, int type, int dts, int pts) {
            if (!this.h264_sps_pps_sent) {
                return;
            }
            this.video_tag = this.avc.muxFlvTag(frames, type, 1, dts, pts);
            this.writeRtmpPacket(9, dts, type, 1, this.video_tag);
        }

        private void writeRtmpPacket(int type, int dts, int frame_type, int avc_aac_type, SrsAllocator.Allocation tag) {
            SrsFlvFrame frame = new SrsFlvFrame();
            frame.flvTag = tag;
            frame.type = type;
            frame.dts = dts;
            frame.frame_type = frame_type;
            frame.avc_aac_type = avc_aac_type;
            if (frame.isVideo()) {
                if (SrsFlvMuxer.this.needToFindKeyFrame) {
                    if (frame.isKeyFrame()) {
                        SrsFlvMuxer.this.needToFindKeyFrame = false;
                        this.flvTagCacheAdd(frame);
                    }
                } else {
                    this.flvTagCacheAdd(frame);
                }
            } else if (frame.isAudio()) {
                this.flvTagCacheAdd(frame);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flvTagCacheAdd(SrsFlvFrame frame) {
            if (SrsFlvMuxer.this.started) {
                SrsFlvMuxer.this.mFlvTagCache.add(frame);
                if (frame.isVideo()) {
                    SrsFlvMuxer.this.getVideoFrameCacheNumber().incrementAndGet();
                }
            }
            Object object = SrsFlvMuxer.this.txFrameLock;
            synchronized (object) {
                SrsFlvMuxer.this.txFrameLock.notifyAll();
            }
        }
    }

    private class SrsRawAacStreamCodec {
        public byte protection_absent;
        public int aac_object;
        public byte sampling_frequency_index;
        public byte channel_configuration;
        public short frame_length;
        public byte sound_format;
        public byte sound_rate;
        public byte sound_size;
        public byte sound_type;
        public byte aac_packet_type;
        public byte[] frame;

        private SrsRawAacStreamCodec() {
        }
    }

    private class SrsRawH264Stream {
        private static final String TAG = "SrsFlvMuxer";
        private SrsAnnexbSearch annexb;
        private SrsFlvFrameBytes seq_hdr;
        private SrsFlvFrameBytes sps_hdr;
        private SrsFlvFrameBytes sps_bb;
        private SrsFlvFrameBytes pps_hdr;
        private SrsFlvFrameBytes pps_bb;

        private SrsRawH264Stream() {
            this.annexb = new SrsAnnexbSearch();
            this.seq_hdr = new SrsFlvFrameBytes();
            this.sps_hdr = new SrsFlvFrameBytes();
            this.sps_bb = new SrsFlvFrameBytes();
            this.pps_hdr = new SrsFlvFrameBytes();
            this.pps_bb = new SrsFlvFrameBytes();
        }

        public boolean isSps(SrsFlvFrameBytes frame) {
            return frame.size >= 1 && (frame.data.get(0) & 0x1F) == 7;
        }

        public boolean isPps(SrsFlvFrameBytes frame) {
            return frame.size >= 1 && (frame.data.get(0) & 0x1F) == 8;
        }

        public SrsFlvFrameBytes muxNaluHeader(SrsFlvFrameBytes frame) {
            SrsFlvFrameBytes nalu_hdr = new SrsFlvFrameBytes();
            nalu_hdr.data = ByteBuffer.allocate(4);
            nalu_hdr.size = 4;
            int NAL_unit_length = frame.size;
            nalu_hdr.data.putInt(NAL_unit_length);
            nalu_hdr.data.rewind();
            return nalu_hdr;
        }

        public void muxSequenceHeader(ByteBuffer sps, ByteBuffer pps, int dts, int pts, ArrayList<SrsFlvFrameBytes> frames) {
            if (this.seq_hdr.data == null) {
                this.seq_hdr.data = ByteBuffer.allocate(5);
                this.seq_hdr.size = 5;
            }
            this.seq_hdr.data.rewind();
            byte profile_idc = sps.get(1);
            byte level_idc = sps.get(3);
            this.seq_hdr.data.put((byte)1);
            this.seq_hdr.data.put(profile_idc);
            this.seq_hdr.data.put((byte)0);
            this.seq_hdr.data.put(level_idc);
            this.seq_hdr.data.put((byte)3);
            this.seq_hdr.data.rewind();
            frames.add(this.seq_hdr);
            if (this.sps_hdr.data == null) {
                this.sps_hdr.data = ByteBuffer.allocate(3);
                this.sps_hdr.size = 3;
            }
            this.sps_hdr.data.rewind();
            this.sps_hdr.data.put((byte)1);
            this.sps_hdr.data.putShort((short)sps.array().length);
            this.sps_hdr.data.rewind();
            frames.add(this.sps_hdr);
            this.sps_bb.size = sps.array().length;
            this.sps_bb.data = sps.duplicate();
            frames.add(this.sps_bb);
            if (this.pps_hdr.data == null) {
                this.pps_hdr.data = ByteBuffer.allocate(3);
                this.pps_hdr.size = 3;
            }
            this.pps_hdr.data.rewind();
            this.pps_hdr.data.put((byte)1);
            this.pps_hdr.data.putShort((short)pps.array().length);
            this.pps_hdr.data.rewind();
            frames.add(this.pps_hdr);
            this.pps_bb.size = pps.array().length;
            this.pps_bb.data = pps.duplicate();
            frames.add(this.pps_bb);
        }

        public SrsAllocator.Allocation muxFlvTag(ArrayList<SrsFlvFrameBytes> frames, int frame_type, int avc_packet_type, int dts, int pts) {
            int size = 5;
            for (int i = 0; i < frames.size(); ++i) {
                size += frames.get((int)i).size;
            }
            SrsAllocator.Allocation allocation = SrsFlvMuxer.this.mVideoAllocator.allocate(size);
            allocation.put((byte)(frame_type << 4 | 7));
            allocation.put((byte)avc_packet_type);
            int cts = pts - dts;
            allocation.put((byte)(cts >> 16));
            allocation.put((byte)(cts >> 8));
            allocation.put((byte)cts);
            for (int i = 0; i < frames.size(); ++i) {
                SrsFlvFrameBytes frame = frames.get(i);
                frame.data.get(allocation.array(), allocation.size(), frame.size);
                allocation.appendOffset(frame.size);
            }
            return allocation;
        }

        private SrsAnnexbSearch searchStartcode(ByteBuffer bb, MediaCodec.BufferInfo bi) {
            this.annexb.match = false;
            this.annexb.nb_start_code = 0;
            if (bi.size - 4 > 0) {
                if (bb.get(0) == 0 && bb.get(1) == 0 && bb.get(2) == 0 && bb.get(3) == 1) {
                    this.annexb.match = true;
                    this.annexb.nb_start_code = 4;
                } else if (bb.get(0) == 0 && bb.get(1) == 0 && bb.get(2) == 1) {
                    this.annexb.match = true;
                    this.annexb.nb_start_code = 3;
                }
            }
            return this.annexb;
        }

        private SrsAnnexbSearch searchAnnexb(ByteBuffer bb, MediaCodec.BufferInfo bi) {
            this.annexb.match = false;
            this.annexb.nb_start_code = 0;
            for (int i = bb.position(); i < bi.size - 4; ++i) {
                if (bb.get(i) != 0 || bb.get(i + 1) != 0) continue;
                if (bb.get(i + 2) == 1) {
                    this.annexb.match = true;
                    this.annexb.nb_start_code = i + 3 - bb.position();
                    break;
                }
                if (bb.get(i + 2) != 0 || bb.get(i + 3) != 1) continue;
                this.annexb.match = true;
                this.annexb.nb_start_code = i + 4 - bb.position();
                break;
            }
            return this.annexb;
        }

        public SrsFlvFrameBytes demuxAnnexb(ByteBuffer bb, MediaCodec.BufferInfo bi, boolean isOnlyChkHeader) {
            SrsFlvFrameBytes tbb = new SrsFlvFrameBytes();
            if (bb.position() < bi.size - 4) {
                SrsAnnexbSearch tbbsc;
                SrsAnnexbSearch srsAnnexbSearch = tbbsc = isOnlyChkHeader ? this.searchStartcode(bb, bi) : this.searchAnnexb(bb, bi);
                if (!tbbsc.match || tbbsc.nb_start_code < 3) {
                    Log.e((String)"SrsFlvMuxer", (String)"annexb not match.");
                } else {
                    for (int i = 0; i < tbbsc.nb_start_code; ++i) {
                        bb.get();
                    }
                    tbb.data = bb.slice();
                    tbb.size = bi.size - bb.position();
                }
            }
            return tbb;
        }
    }

    private class SrsFlvFrame {
        public SrsAllocator.Allocation flvTag;
        public int avc_aac_type;
        public int frame_type;
        public int type;
        public int dts;

        private SrsFlvFrame() {
        }

        public boolean isKeyFrame() {
            return this.isVideo() && this.frame_type == 1;
        }

        public boolean isSequenceHeader() {
            return this.avc_aac_type == 0;
        }

        public boolean isVideo() {
            return this.type == 9;
        }

        public boolean isAudio() {
            return this.type == 8;
        }
    }

    private class SrsFlvFrameBytes {
        public ByteBuffer data;
        public int size;

        private SrsFlvFrameBytes() {
        }
    }

    private class SrsAnnexbSearch {
        public int nb_start_code = 0;
        public boolean match = false;

        private SrsAnnexbSearch() {
        }
    }

    private class SrsAvcNaluType {
        public static final int Reserved = 0;
        public static final int NonIDR = 1;
        public static final int DataPartitionA = 2;
        public static final int DataPartitionB = 3;
        public static final int DataPartitionC = 4;
        public static final int IDR = 5;
        public static final int SEI = 6;
        public static final int SPS = 7;
        public static final int PPS = 8;
        public static final int AccessUnitDelimiter = 9;
        public static final int EOSequence = 10;
        public static final int EOStream = 11;
        public static final int FilterData = 12;
        public static final int SPSExt = 13;
        public static final int PrefixNALU = 14;
        public static final int SubsetSPS = 15;
        public static final int LayerWithoutPartition = 19;
        public static final int CodedSliceExt = 20;

        private SrsAvcNaluType() {
        }
    }

    private class SrsCodecAudioSampleRate {
        public static final int R5512 = 5512;
        public static final int R11025 = 11025;
        public static final int R22050 = 22050;
        public static final int R44100 = 44100;
        public static final int R32000 = 32000;
        public static final int R16000 = 16000;

        private SrsCodecAudioSampleRate() {
        }
    }

    private class SrsAacProfile {
        public static final int Reserved = 3;
        public static final int Main = 0;
        public static final int LC = 1;
        public static final int SSR = 2;

        private SrsAacProfile() {
        }
    }

    private class SrsAacObjectType {
        public static final int Reserved = 0;
        public static final int AacMain = 1;
        public static final int AacLC = 2;
        public static final int AacSSR = 3;
        public static final int AacHE = 5;
        public static final int AacHEV2 = 29;

        private SrsAacObjectType() {
        }
    }

    private class SrsCodecVideo {
        public static final int Reserved = 0;
        public static final int Reserved1 = 1;
        public static final int Reserved2 = 9;
        public static final int Disabled = 8;
        public static final int SorensonH263 = 2;
        public static final int ScreenVideo = 3;
        public static final int On2VP6 = 4;
        public static final int On2VP6WithAlphaChannel = 5;
        public static final int ScreenVideoVersion2 = 6;
        public static final int AVC = 7;

        private SrsCodecVideo() {
        }
    }

    private class SrsCodecFlvTag {
        public static final int Reserved = 0;
        public static final int Audio = 8;
        public static final int Video = 9;
        public static final int Script = 18;

        private SrsCodecFlvTag() {
        }
    }

    private class SrsCodecVideoAVCType {
        public static final int Reserved = 3;
        public static final int SequenceHeader = 0;
        public static final int NALU = 1;
        public static final int SequenceHeaderEOF = 2;

        private SrsCodecVideoAVCType() {
        }
    }

    private class SrsCodecVideoAVCFrame {
        public static final int Reserved = 0;
        public static final int Reserved1 = 6;
        public static final int KeyFrame = 1;
        public static final int InterFrame = 2;
        public static final int DisposableInterFrame = 3;
        public static final int GeneratedKeyFrame = 4;
        public static final int VideoInfoFrame = 5;

        private SrsCodecVideoAVCFrame() {
        }
    }
}

