/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.amf;

import com.github.faucamp.simplertmp.Util;
import com.github.faucamp.simplertmp.amf.AmfData;
import com.github.faucamp.simplertmp.amf.AmfType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AmfNumber
implements AmfData {
    public static final int SIZE = 9;
    double value;

    public AmfNumber(double value) {
        this.value = value;
    }

    public AmfNumber() {
    }

    public static double readNumberFrom(InputStream in) throws IOException {
        in.read();
        return Util.readDouble(in);
    }

    public static void writeNumberTo(OutputStream out, double number) throws IOException {
        out.write(AmfType.NUMBER.getValue());
        Util.writeDouble(out, number);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(AmfType.NUMBER.getValue());
        Util.writeDouble(out, this.value);
    }

    @Override
    public void readFrom(InputStream in) throws IOException {
        this.value = Util.readDouble(in);
    }

    @Override
    public int getSize() {
        return 9;
    }
}

