/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.fragment.SampleFlags;
import com.coremedia.iso.boxes.fragment.TrackExtendsBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class TrackRunBox
extends AbstractFullBox {
    public static final String TYPE = "trun";
    private int dataOffset;
    private SampleFlags firstSampleFlags;
    private List<Entry> entries = new ArrayList<Entry>();

    public TrackRunBox() {
        super(TYPE);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    public long[] getSampleCompositionTimeOffsets() {
        if (this.isSampleCompositionTimeOffsetPresent()) {
            long[] result = new long[this.entries.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.entries.get(i).getSampleCompositionTimeOffset();
            }
            return result;
        }
        return null;
    }

    public TrackExtendsBox getTrackExtendsBox() {
        TrackFragmentHeaderBox tfhd = ((TrackFragmentBox)this.getParent()).getTrackFragmentHeaderBox();
        List<MovieBox> movieBoxes = tfhd.getIsoFile().getBoxes(MovieBox.class);
        if (movieBoxes.size() == 0) {
            return null;
        }
        List<TrackExtendsBox> trexBoxes = movieBoxes.get(0).getBoxes(TrackExtendsBox.class, true);
        TrackExtendsBox trex = null;
        for (TrackExtendsBox aTrex : trexBoxes) {
            if (aTrex.getTrackId() != tfhd.getTrackId()) continue;
            trex = aTrex;
        }
        return trex;
    }

    @Override
    protected long getContentSize() {
        long size = 8L;
        int flags = this.getFlags();
        if ((flags & 1) == 1) {
            size += 4L;
        }
        if ((flags & 4) == 4) {
            size += 4L;
        }
        long entrySize = 0L;
        if ((flags & 0x100) == 256) {
            entrySize += 4L;
        }
        if ((flags & 0x200) == 512) {
            entrySize += 4L;
        }
        if ((flags & 0x400) == 1024) {
            entrySize += 4L;
        }
        if ((flags & 0x800) == 2048) {
            entrySize += 4L;
        }
        return size += entrySize * (long)this.entries.size();
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.entries.size());
        int flags = this.getFlags();
        if ((flags & 1) == 1) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.dataOffset);
        }
        if ((flags & 4) == 4) {
            this.firstSampleFlags.getContent(byteBuffer);
        }
        for (Entry entry : this.entries) {
            if ((flags & 0x100) == 256) {
                IsoTypeWriter.writeUInt32(byteBuffer, entry.sampleDuration);
            }
            if ((flags & 0x200) == 512) {
                IsoTypeWriter.writeUInt32(byteBuffer, entry.sampleSize);
            }
            if ((flags & 0x400) == 1024) {
                entry.sampleFlags.getContent(byteBuffer);
            }
            if ((flags & 0x800) != 2048) continue;
            byteBuffer.putInt(entry.sampleCompositionTimeOffset);
        }
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        long sampleCount = IsoTypeReader.readUInt32(content);
        this.dataOffset = (this.getFlags() & 1) == 1 ? CastUtils.l2i(IsoTypeReader.readUInt32(content)) : -1;
        if ((this.getFlags() & 4) == 4) {
            this.firstSampleFlags = new SampleFlags(content);
        }
        int i = 0;
        while ((long)i < sampleCount) {
            Entry entry = new Entry();
            if ((this.getFlags() & 0x100) == 256) {
                entry.sampleDuration = IsoTypeReader.readUInt32(content);
            }
            if ((this.getFlags() & 0x200) == 512) {
                entry.sampleSize = IsoTypeReader.readUInt32(content);
            }
            if ((this.getFlags() & 0x400) == 1024) {
                entry.sampleFlags = new SampleFlags(content);
            }
            if ((this.getFlags() & 0x800) == 2048) {
                entry.sampleCompositionTimeOffset = content.getInt();
            }
            this.entries.add(entry);
            ++i;
        }
    }

    public long getSampleCount() {
        return this.entries.size();
    }

    public boolean isDataOffsetPresent() {
        return (this.getFlags() & 1) == 1;
    }

    public void setDataOffsetPresent(boolean v) {
        if (v) {
            this.setFlags(this.getFlags() | 1);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFE);
        }
    }

    public boolean isFirstSampleFlagsPresent() {
        return (this.getFlags() & 4) == 4;
    }

    public boolean isSampleSizePresent() {
        return (this.getFlags() & 0x200) == 512;
    }

    public void setSampleSizePresent(boolean v) {
        if (v) {
            this.setFlags(this.getFlags() | 0x200);
        } else {
            this.setFlags(this.getFlags() & 0xFFFDFF);
        }
    }

    public boolean isSampleDurationPresent() {
        return (this.getFlags() & 0x100) == 256;
    }

    public void setSampleDurationPresent(boolean v) {
        if (v) {
            this.setFlags(this.getFlags() | 0x100);
        } else {
            this.setFlags(this.getFlags() & 0xFFFEFF);
        }
    }

    public boolean isSampleFlagsPresent() {
        return (this.getFlags() & 0x400) == 1024;
    }

    public void setSampleFlagsPresent(boolean v) {
        if (v) {
            this.setFlags(this.getFlags() | 0x400);
        } else {
            this.setFlags(this.getFlags() & 0xFFFBFF);
        }
    }

    public boolean isSampleCompositionTimeOffsetPresent() {
        return (this.getFlags() & 0x800) == 2048;
    }

    public void setSampleCompositionTimeOffsetPresent(boolean v) {
        if (v) {
            this.setFlags(this.getFlags() | 0x800);
        } else {
            this.setFlags(this.getFlags() & 0xFFF7FF);
        }
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public void setDataOffset(int dataOffset) {
        if (dataOffset == -1) {
            this.setFlags(this.getFlags() & 0xFFFFFE);
        } else {
            this.setFlags(this.getFlags() | 1);
        }
        this.dataOffset = dataOffset;
    }

    public SampleFlags getFirstSampleFlags() {
        return this.firstSampleFlags;
    }

    public void setFirstSampleFlags(SampleFlags firstSampleFlags) {
        if (firstSampleFlags == null) {
            this.setFlags(this.getFlags() & 0xFFFFFB);
        } else {
            this.setFlags(this.getFlags() | 4);
        }
        this.firstSampleFlags = firstSampleFlags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TrackRunBox");
        sb.append("{sampleCount=").append(this.entries.size());
        sb.append(", dataOffset=").append(this.dataOffset);
        sb.append(", dataOffsetPresent=").append(this.isDataOffsetPresent());
        sb.append(", sampleSizePresent=").append(this.isSampleSizePresent());
        sb.append(", sampleDurationPresent=").append(this.isSampleDurationPresent());
        sb.append(", sampleFlagsPresentPresent=").append(this.isSampleFlagsPresent());
        sb.append(", sampleCompositionTimeOffsetPresent=").append(this.isSampleCompositionTimeOffsetPresent());
        sb.append(", firstSampleFlags=").append(this.firstSampleFlags);
        sb.append('}');
        return sb.toString();
    }

    public static class Entry {
        private long sampleDuration;
        private long sampleSize;
        private SampleFlags sampleFlags;
        private int sampleCompositionTimeOffset;

        public Entry() {
        }

        public Entry(long sampleDuration, long sampleSize, SampleFlags sampleFlags, int sampleCompositionTimeOffset) {
            this.sampleDuration = sampleDuration;
            this.sampleSize = sampleSize;
            this.sampleFlags = sampleFlags;
            this.sampleCompositionTimeOffset = sampleCompositionTimeOffset;
        }

        public long getSampleDuration() {
            return this.sampleDuration;
        }

        public void setSampleDuration(long sampleDuration) {
            this.sampleDuration = sampleDuration;
        }

        public long getSampleSize() {
            return this.sampleSize;
        }

        public void setSampleSize(long sampleSize) {
            this.sampleSize = sampleSize;
        }

        public SampleFlags getSampleFlags() {
            return this.sampleFlags;
        }

        public void setSampleFlags(SampleFlags sampleFlags) {
            this.sampleFlags = sampleFlags;
        }

        public int getSampleCompositionTimeOffset() {
            return this.sampleCompositionTimeOffset;
        }

        public void setSampleCompositionTimeOffset(int sampleCompositionTimeOffset) {
            this.sampleCompositionTimeOffset = sampleCompositionTimeOffset;
        }

        public String toString() {
            return "Entry{sampleDuration=" + this.sampleDuration + ", sampleSize=" + this.sampleSize + ", sampleFlags=" + this.sampleFlags + ", sampleCompositionTimeOffset=" + this.sampleCompositionTimeOffset + '}';
        }
    }
}

