/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.Utf8;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class RatingBox
extends AbstractFullBox {
    public static final String TYPE = "rtng";
    private String ratingEntity;
    private String ratingCriteria;
    private String language;
    private String ratingInfo;

    public RatingBox() {
        super(TYPE);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getRatingEntity() {
        return this.ratingEntity;
    }

    public void setRatingEntity(String ratingEntity) {
        this.ratingEntity = ratingEntity;
    }

    public String getRatingCriteria() {
        return this.ratingCriteria;
    }

    public void setRatingCriteria(String ratingCriteria) {
        this.ratingCriteria = ratingCriteria;
    }

    public String getRatingInfo() {
        return this.ratingInfo;
    }

    public void setRatingInfo(String ratingInfo) {
        this.ratingInfo = ratingInfo;
    }

    @Override
    protected long getContentSize() {
        return 15 + Utf8.utf8StringLengthInBytes(this.ratingInfo);
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.ratingEntity = IsoTypeReader.read4cc(content);
        this.ratingCriteria = IsoTypeReader.read4cc(content);
        this.language = IsoTypeReader.readIso639(content);
        this.ratingInfo = IsoTypeReader.readString(content);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        byteBuffer.put(IsoFile.fourCCtoBytes(this.ratingEntity));
        byteBuffer.put(IsoFile.fourCCtoBytes(this.ratingCriteria));
        IsoTypeWriter.writeIso639(byteBuffer, this.language);
        byteBuffer.put(Utf8.convert(this.ratingInfo));
        byteBuffer.put((byte)0);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("RatingBox[language=").append(this.getLanguage());
        buffer.append("ratingEntity=").append(this.getRatingEntity());
        buffer.append(";ratingCriteria=").append(this.getRatingCriteria());
        buffer.append(";language=").append(this.getLanguage());
        buffer.append(";ratingInfo=").append(this.getRatingInfo());
        buffer.append("]");
        return buffer.toString();
    }
}

