/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.util;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Path {
    static Pattern component = Pattern.compile("(....|\\.\\.)(\\[(.*)\\])?");

    private Path() {
    }

    public static String createPath(Box box) {
        return Path.createPath(box, "");
    }

    private static String createPath(Box box, String path) {
        if (box instanceof IsoFile) {
            return path;
        }
        List<?> boxesOfBoxType = box.getParent().getBoxes(box.getClass());
        int index = boxesOfBoxType.indexOf(box);
        path = String.format("/%s[%d]", box.getType(), index) + path;
        return Path.createPath(box.getParent(), path);
    }

    public static Box getPath(Box box, String path) {
        List<Box> all = Path.getPaths(box, path);
        return all.isEmpty() ? null : all.get(0);
    }

    public static List<Box> getPaths(Box box, String path) {
        String now;
        String later;
        if (path.startsWith("/")) {
            Box isoFile = box;
            while (isoFile.getParent() != null) {
                isoFile = isoFile.getParent();
            }
            assert (isoFile instanceof IsoFile) : isoFile.getType() + " has no parent";
            return Path.getPaths(isoFile, path.substring(1));
        }
        if (path.isEmpty()) {
            return Collections.singletonList(box);
        }
        if (path.contains("/")) {
            later = path.substring(path.indexOf(47) + 1);
            now = path.substring(0, path.indexOf(47));
        } else {
            now = path;
            later = "";
        }
        Matcher m = component.matcher(now);
        if (m.matches()) {
            String type = m.group(1);
            if ("..".equals(type)) {
                return Path.getPaths(box.getParent(), later);
            }
            int index = -1;
            if (m.group(2) != null) {
                String indexString = m.group(3);
                index = Integer.parseInt(indexString);
            }
            LinkedList<Box> children = new LinkedList<Box>();
            int currentIndex = 0;
            for (Box box1 : ((ContainerBox)box).getBoxes()) {
                if (!box1.getType().matches(type)) continue;
                if (index == -1 || index == currentIndex) {
                    children.addAll(Path.getPaths(box1, later));
                }
                ++currentIndex;
            }
            return children;
        }
        throw new RuntimeException(now + " is invalid path.");
    }

    public static boolean isContained(Box box, String path) {
        assert (path.startsWith("/")) : "Absolute path required";
        return Path.getPaths(box, path).contains(box);
    }
}

