/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.io;

import com.github.faucamp.simplertmp.io.PacketRxHandler;
import com.github.faucamp.simplertmp.io.RtmpDecoder;
import com.github.faucamp.simplertmp.io.RtmpSessionInfo;
import com.github.faucamp.simplertmp.io.ThreadController;
import com.github.faucamp.simplertmp.io.packets.RtmpPacket;
import com.github.faucamp.simplertmp.util.L;
import java.io.InputStream;

public class ReadThread
extends Thread {
    private RtmpDecoder rtmpDecoder;
    private InputStream in;
    private PacketRxHandler packetRxHandler;
    private ThreadController threadController;

    public ReadThread(RtmpSessionInfo rtmpSessionInfo, InputStream in, PacketRxHandler packetRxHandler, ThreadController threadController) {
        super("RtmpReadThread");
        this.in = in;
        this.packetRxHandler = packetRxHandler;
        this.rtmpDecoder = new RtmpDecoder(rtmpSessionInfo);
        this.threadController = threadController;
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            try {
                RtmpPacket rtmpPacket = this.rtmpDecoder.readPacket(this.in);
                if (rtmpPacket == null) continue;
                this.packetRxHandler.handleRxPacket(rtmpPacket);
            }
            catch (Exception ex) {
                if (this.isInterrupted()) continue;
                L.e("ReadThread: Caught exception while reading/decoding packet, shutting down...", ex);
                this.interrupt();
            }
        }
        try {
            this.in.close();
        }
        catch (Exception ex) {
            L.w("ReadThread: Failed to close inputstream", ex);
        }
        L.i("ReadThread: exiting");
        if (this.threadController != null) {
            this.threadController.threadHasExited(this);
        }
    }

    public void shutdown() {
        L.d("ReadThread: Stopping read thread...");
        this.interrupt();
    }
}

