/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.amf;

import com.github.faucamp.simplertmp.amf.AmfBoolean;
import com.github.faucamp.simplertmp.amf.AmfData;
import com.github.faucamp.simplertmp.amf.AmfDecoder;
import com.github.faucamp.simplertmp.amf.AmfNumber;
import com.github.faucamp.simplertmp.amf.AmfString;
import com.github.faucamp.simplertmp.amf.AmfType;
import com.github.faucamp.simplertmp.util.L;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;

public class AmfObject
implements AmfData {
    protected static final byte[] OBJECT_END_MARKER = new byte[]{0, 0, 9};
    protected Map<String, AmfData> properties = new LinkedHashMap<String, AmfData>();
    protected int size = -1;

    public AmfData getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, AmfData value) {
        this.properties.put(key, value);
    }

    public void setProperty(String key, boolean value) {
        this.properties.put(key, new AmfBoolean(value));
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, new AmfString(value, false));
    }

    public void setProperty(String key, int value) {
        this.properties.put(key, new AmfNumber(value));
    }

    public void setProperty(String key, double value) {
        this.properties.put(key, new AmfNumber(value));
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(AmfType.OBJECT.getValue());
        for (Map.Entry<String, AmfData> entry : this.properties.entrySet()) {
            AmfString.writeStringTo(out, entry.getKey(), true);
            entry.getValue().writeTo(out);
        }
        out.write(OBJECT_END_MARKER);
    }

    @Override
    public void readFrom(InputStream in) throws IOException {
        this.size = 1;
        InputStream markInputStream = in.markSupported() ? in : new BufferedInputStream(in);
        while (true) {
            markInputStream.mark(3);
            byte[] endMarker = new byte[3];
            markInputStream.read(endMarker);
            if (endMarker[0] == OBJECT_END_MARKER[0] && endMarker[1] == OBJECT_END_MARKER[1] && endMarker[2] == OBJECT_END_MARKER[2]) {
                L.d("readFrom(): End marker found");
                this.size += 3;
                return;
            }
            markInputStream.reset();
            String key = AmfString.readStringFrom(in, true);
            this.size += AmfString.sizeOf(key, true);
            AmfData value = AmfDecoder.readFrom(markInputStream);
            this.size += value.getSize();
            this.properties.put(key, value);
        }
    }

    @Override
    public int getSize() {
        if (this.size == -1) {
            this.size = 1;
            for (Map.Entry<String, AmfData> entry : this.properties.entrySet()) {
                this.size += AmfString.sizeOf(entry.getKey(), true);
                this.size += entry.getValue().getSize();
            }
            this.size += 3;
        }
        return this.size;
    }
}

