/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.Utf8;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class DataEntryUrnBox
extends AbstractFullBox {
    public static final String TYPE = "urn ";
    private String name;
    private String location;

    public DataEntryUrnBox() {
        super(TYPE);
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    protected long getContentSize() {
        return Utf8.utf8StringLengthInBytes(this.name) + 1 + Utf8.utf8StringLengthInBytes(this.location) + 1;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.name = IsoTypeReader.readString(content);
        this.location = IsoTypeReader.readString(content);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        byteBuffer.put(Utf8.convert(this.name));
        byteBuffer.put((byte)0);
        byteBuffer.put(Utf8.convert(this.location));
        byteBuffer.put((byte)0);
    }

    public String toString() {
        return "DataEntryUrlBox[name=" + this.getName() + ";location=" + this.getLocation() + "]";
    }
}

