/*
 * Decompiled with CFR 0.152.
 */
package ir.mstajbakhsh.livehiddencamera.HiddenCameraLayout;

import android.content.Context;
import android.hardware.Camera;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import ir.mstajbakhsh.livehiddencamera.HiddenCameraLayout.CameraConfig;
import java.io.IOException;

public class CameraPreview
extends SurfaceView
implements SurfaceHolder.Callback {
    private SurfaceHolder mHolder;
    private Camera mCamera;
    private CameraConfig mCameraConfig;
    private volatile boolean safeToTakePicture = false;

    public CameraPreview(@NonNull Context context) {
        super(context);
        if (this.getHolder() == null) {
            this.initSurfaceView();
        }
    }

    private void initSurfaceView() {
        this.mHolder = super.getHolder();
        this.mHolder.addCallback((SurfaceHolder.Callback)this);
        this.mHolder.setType(3);
    }

    protected void onLayout(boolean b, int i, int i1, int i2, int i3) {
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i1, int i2) {
        if (this.mCamera == null) {
            Log.e((String)"HiddenCam", (String)"Error in openning camera.");
            return;
        }
        if (surfaceHolder.getSurface() == null) {
            Log.e((String)"HiddenCam", (String)"Error in openning camera.");
            return;
        }
        try {
            this.mCamera.stopPreview();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.requestLayout();
        try {
            this.mCamera.setPreviewDisplay(surfaceHolder);
            this.mCamera.startPreview();
            this.safeToTakePicture = true;
        }
        catch (IOException | NullPointerException e) {
            Log.e((String)"HiddenCam", (String)"Error in openning camera.");
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
        }
    }

    public void startCameraInternal(@NonNull CameraConfig cameraConfig) {
        this.mCameraConfig = cameraConfig;
        if (this.safeCameraOpen(this.mCameraConfig.getFacing())) {
            if (this.mCamera != null) {
                this.requestLayout();
                try {
                    this.mCamera.setPreviewDisplay(this.mHolder);
                    this.mCamera.startPreview();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Log.e((String)"HiddenCam", (String)"Error in openning camera.");
                }
            }
        } else {
            Log.e((String)"HiddenCam", (String)"Error in openning camera.");
        }
    }

    private boolean safeCameraOpen(int id) {
        boolean qOpened = false;
        try {
            this.stopPreviewAndFreeCamera();
            this.mCamera = Camera.open((int)id);
            qOpened = this.mCamera != null;
        }
        catch (Exception e) {
            Log.e((String)"CameraPreview", (String)"failed to open Camera");
            e.printStackTrace();
        }
        return qOpened;
    }

    boolean isSafeToTakePictureInternal() {
        return this.safeToTakePicture;
    }

    void stopPreviewAndFreeCamera() {
        this.safeToTakePicture = false;
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    public SurfaceHolder getHolder() {
        if (this.mHolder == null) {
            this.initSurfaceView();
        }
        return this.mHolder;
    }
}

