/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.mdat;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ChunkOffsetBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.fragment.MovieExtendsBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackExtendsBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import com.coremedia.iso.boxes.mdat.MediaDataBox;
import com.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SampleList
extends AbstractList<ByteBuffer> {
    long[] offsets;
    long[] sizes;
    IsoFile isoFile;
    HashMap<MediaDataBox, Long> mdatStartCache = new HashMap();
    HashMap<MediaDataBox, Long> mdatEndCache = new HashMap();
    MediaDataBox[] mdats;

    public SampleList(TrackBox trackBox) {
        List<MovieExtendsBox> movieExtendsBoxes;
        long[] chunkOffsets;
        this.initIsoFile(trackBox.getIsoFile());
        SampleSizeBox sampleSizeBox = trackBox.getSampleTableBox().getSampleSizeBox();
        ChunkOffsetBox chunkOffsetBox = trackBox.getSampleTableBox().getChunkOffsetBox();
        SampleToChunkBox sampleToChunkBox = trackBox.getSampleTableBox().getSampleToChunkBox();
        long[] lArray = chunkOffsets = chunkOffsetBox != null ? chunkOffsetBox.getChunkOffsets() : new long[]{};
        if (sampleToChunkBox != null && sampleToChunkBox.getEntries().size() > 0 && chunkOffsets.length > 0 && sampleSizeBox != null && sampleSizeBox.getSampleCount() > 0L) {
            long[] numberOfSamplesInChunk = sampleToChunkBox.blowup(chunkOffsets.length);
            int sampleIndex = 0;
            if (sampleSizeBox.getSampleSize() > 0L) {
                this.sizes = new long[CastUtils.l2i(sampleSizeBox.getSampleCount())];
                Arrays.fill(this.sizes, sampleSizeBox.getSampleSize());
            } else {
                this.sizes = sampleSizeBox.getSampleSizes();
            }
            this.offsets = new long[this.sizes.length];
            for (int i = 0; i < numberOfSamplesInChunk.length; ++i) {
                long thisChunksNumberOfSamples = numberOfSamplesInChunk[i];
                long sampleOffset = chunkOffsets[i];
                int j = 0;
                while ((long)j < thisChunksNumberOfSamples) {
                    long sampleSize = this.sizes[sampleIndex];
                    this.offsets[sampleIndex] = sampleOffset;
                    sampleOffset += sampleSize;
                    ++sampleIndex;
                    ++j;
                }
            }
        }
        if ((movieExtendsBoxes = trackBox.getParent().getBoxes(MovieExtendsBox.class)).size() > 0) {
            HashMap<Long, Long> offsets2Sizes = new HashMap<Long, Long>();
            List<TrackExtendsBox> trackExtendsBoxes = movieExtendsBoxes.get(0).getBoxes(TrackExtendsBox.class);
            for (TrackExtendsBox trackExtendsBox : trackExtendsBoxes) {
                if (trackExtendsBox.getTrackId() != trackBox.getTrackHeaderBox().getTrackId()) continue;
                for (MovieFragmentBox movieFragmentBox : trackBox.getIsoFile().getBoxes(MovieFragmentBox.class)) {
                    offsets2Sizes.putAll(this.getOffsets(movieFragmentBox, trackBox.getTrackHeaderBox().getTrackId(), trackExtendsBox));
                }
            }
            if (this.sizes == null || this.offsets == null) {
                this.sizes = new long[0];
                this.offsets = new long[0];
            }
            this.splitToArrays(offsets2Sizes);
        }
    }

    public SampleList(TrackFragmentBox traf) {
        this.sizes = new long[0];
        this.offsets = new long[0];
        HashMap<Long, Long> offsets2Sizes = new HashMap<Long, Long>();
        this.initIsoFile(traf.getIsoFile());
        List<MovieFragmentBox> movieFragmentBoxList = this.isoFile.getBoxes(MovieFragmentBox.class);
        long trackId = traf.getTrackFragmentHeaderBox().getTrackId();
        for (MovieFragmentBox moof : movieFragmentBoxList) {
            List<TrackFragmentHeaderBox> trackFragmentHeaderBoxes = moof.getTrackFragmentHeaderBoxes();
            for (TrackFragmentHeaderBox tfhd : trackFragmentHeaderBoxes) {
                if (tfhd.getTrackId() != trackId) continue;
                offsets2Sizes.putAll(this.getOffsets(moof, trackId, null));
            }
        }
        this.splitToArrays(offsets2Sizes);
    }

    public long[] getOffsetKeys() {
        return this.offsets;
    }

    private void splitToArrays(Map<Long, Long> offsets2Sizes) {
        ArrayList<Long> keys = new ArrayList<Long>(offsets2Sizes.keySet());
        Collections.sort(keys);
        long[] nuSizes = new long[this.sizes.length + keys.size()];
        System.arraycopy(this.sizes, 0, nuSizes, 0, this.sizes.length);
        long[] nuOffsets = new long[this.offsets.length + keys.size()];
        System.arraycopy(this.offsets, 0, nuOffsets, 0, this.offsets.length);
        for (int i = 0; i < keys.size(); ++i) {
            nuOffsets[i + this.offsets.length] = (Long)keys.get(i);
            nuSizes[i + this.sizes.length] = offsets2Sizes.get(keys.get(i));
        }
        this.sizes = nuSizes;
        this.offsets = nuOffsets;
    }

    private void initIsoFile(IsoFile isoFile) {
        this.isoFile = isoFile;
        long currentOffset = 0L;
        LinkedList<MediaDataBox> mdats = new LinkedList<MediaDataBox>();
        for (Box b : this.isoFile.getBoxes()) {
            long currentSize = b.getSize();
            if ("mdat".equals(b.getType())) {
                if (b instanceof MediaDataBox) {
                    long contentOffset = currentOffset + (long)((MediaDataBox)b).getHeader().limit();
                    this.mdatStartCache.put((MediaDataBox)b, contentOffset);
                    this.mdatEndCache.put((MediaDataBox)b, contentOffset + currentSize);
                    mdats.add((MediaDataBox)b);
                } else {
                    throw new RuntimeException("Sample need to be in mdats and mdats need to be instanceof MediaDataBox");
                }
            }
            currentOffset += currentSize;
        }
        this.mdats = mdats.toArray(new MediaDataBox[mdats.size()]);
    }

    @Override
    public int size() {
        return this.sizes.length;
    }

    @Override
    public ByteBuffer get(int index) {
        long offset = this.offsets[index];
        int sampleSize = CastUtils.l2i(this.sizes[index]);
        for (MediaDataBox mediaDataBox : this.mdats) {
            long start = this.mdatStartCache.get(mediaDataBox);
            long end = this.mdatEndCache.get(mediaDataBox);
            if (start > offset || offset + (long)sampleSize > end) continue;
            return mediaDataBox.getContent(offset - start, sampleSize);
        }
        throw new RuntimeException("The sample with offset " + offset + " and size " + sampleSize + " is NOT located within an mdat");
    }

    Map<Long, Long> getOffsets(MovieFragmentBox moof, long trackId, TrackExtendsBox trex) {
        HashMap<Long, Long> offsets2Sizes = new HashMap<Long, Long>();
        List<TrackFragmentBox> traf = moof.getBoxes(TrackFragmentBox.class);
        for (TrackFragmentBox trackFragmentBox : traf) {
            if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != trackId) continue;
            long baseDataOffset = trackFragmentBox.getTrackFragmentHeaderBox().hasBaseDataOffset() ? trackFragmentBox.getTrackFragmentHeaderBox().getBaseDataOffset() : moof.getOffset();
            for (TrackRunBox trun : trackFragmentBox.getBoxes(TrackRunBox.class)) {
                long sampleBaseOffset = baseDataOffset + (long)trun.getDataOffset();
                TrackFragmentHeaderBox tfhd = ((TrackFragmentBox)trun.getParent()).getTrackFragmentHeaderBox();
                long offset = 0L;
                for (TrackRunBox.Entry entry : trun.getEntries()) {
                    long sampleSize;
                    if (trun.isSampleSizePresent()) {
                        sampleSize = entry.getSampleSize();
                        offsets2Sizes.put(offset + sampleBaseOffset, sampleSize);
                        offset += sampleSize;
                        continue;
                    }
                    if (tfhd.hasDefaultSampleSize()) {
                        sampleSize = tfhd.getDefaultSampleSize();
                        offsets2Sizes.put(offset + sampleBaseOffset, sampleSize);
                        offset += sampleSize;
                        continue;
                    }
                    if (trex == null) {
                        throw new RuntimeException("File doesn't contain trex box but track fragments aren't fully self contained. Cannot determine sample size.");
                    }
                    sampleSize = trex.getDefaultSampleSize();
                    offsets2Sizes.put(offset + sampleBaseOffset, sampleSize);
                    offset += sampleSize;
                }
            }
        }
        return offsets2Sizes;
    }
}

