/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.mdat;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.ChannelHelper;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.googlecode.mp4parser.AbstractBox;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public final class MediaDataBox
implements Box {
    public static final String TYPE = "mdat";
    public static final int BUFFER_SIZE = 0xA00000;
    private static Logger LOG = Logger.getLogger(MediaDataBox.class.getName());
    ContainerBox parent;
    ByteBuffer header;
    private FileChannel fileChannel;
    private long startPosition;
    private long contentSize;
    private Map<Long, Reference<ByteBuffer>> cache = new HashMap<Long, Reference<ByteBuffer>>();
    private ByteBuffer content;

    private static void transfer(FileChannel from, long position, long count, WritableByteChannel to) throws IOException {
        long maxCount = 67076096L;
        for (long offset = 0L; offset < count; offset += from.transferTo(position + offset, Math.min(maxCount, count - offset), to)) {
        }
    }

    @Override
    public ContainerBox getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ContainerBox parent) {
        this.parent = parent;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        if (this.fileChannel != null) {
            assert (this.checkStillOk());
            MediaDataBox.transfer(this.fileChannel, this.startPosition - (long)this.header.limit(), this.contentSize + (long)this.header.limit(), writableByteChannel);
        } else {
            this.header.rewind();
            writableByteChannel.write(this.header);
            writableByteChannel.write(this.content);
        }
    }

    private boolean checkStillOk() {
        try {
            this.fileChannel.position(this.startPosition - (long)this.header.limit());
            ByteBuffer h2 = ByteBuffer.allocate(this.header.limit());
            this.fileChannel.read(h2);
            this.header.rewind();
            h2.rewind();
            assert (h2.equals(this.header)) : "It seems that the content I want to read has already been overwritten.";
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public long getSize() {
        long size = this.header.limit();
        return size += this.contentSize;
    }

    @Override
    public void parse(ReadableByteChannel readableByteChannel, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        this.header = header;
        this.contentSize = contentSize;
        if (readableByteChannel instanceof FileChannel && contentSize > (long)AbstractBox.MEM_MAP_THRESHOLD) {
            this.fileChannel = (FileChannel)readableByteChannel;
            this.startPosition = ((FileChannel)readableByteChannel).position();
            ((FileChannel)readableByteChannel).position(((FileChannel)readableByteChannel).position() + contentSize);
        } else {
            this.content = ChannelHelper.readFully(readableByteChannel, CastUtils.l2i(contentSize));
            this.cache.put(0L, new SoftReference<ByteBuffer>(this.content));
        }
    }

    public synchronized ByteBuffer getContent(long offset, int length) {
        MappedByteBuffer cacheEntry;
        for (Long chacheEntryOffset : this.cache.keySet()) {
            ByteBuffer cacheEntry2;
            if (chacheEntryOffset > offset || offset > chacheEntryOffset + 0xA00000L || (cacheEntry2 = this.cache.get(chacheEntryOffset).get()) == null || chacheEntryOffset + (long)cacheEntry2.limit() < offset + (long)length) continue;
            cacheEntry2.position((int)(offset - chacheEntryOffset));
            ByteBuffer cachedSample = cacheEntry2.slice();
            cachedSample.limit(length);
            return cachedSample;
        }
        try {
            cacheEntry = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, this.startPosition + offset, Math.min(0xA00000L, this.contentSize - offset));
        }
        catch (IOException e1) {
            LOG.fine("Even mapping just 10MB of the source file into the memory failed. " + e1);
            throw new RuntimeException("Delayed reading of mdat content failed. Make sure not to close the FileChannel that has been used to create the IsoFile!", e1);
        }
        this.cache.put(offset, new SoftReference<MappedByteBuffer>(cacheEntry));
        ((ByteBuffer)cacheEntry).position(0);
        ByteBuffer cachedSample = ((ByteBuffer)cacheEntry).slice();
        cachedSample.limit(length);
        return cachedSample;
    }

    public ByteBuffer getHeader() {
        return this.header;
    }
}

