/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.h264;

import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitWriterBuffer;
import com.googlecode.mp4parser.h264.model.PictureParameterSet;
import com.googlecode.mp4parser.h264.model.SeqParameterSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AvcConfigurationBox
extends AbstractBox {
    public static final String TYPE = "avcC";
    public AVCDecoderConfigurationRecord avcDecoderConfigurationRecord = new AVCDecoderConfigurationRecord();

    public AvcConfigurationBox() {
        super(TYPE);
    }

    public int getConfigurationVersion() {
        return this.avcDecoderConfigurationRecord.configurationVersion;
    }

    public void setConfigurationVersion(int configurationVersion) {
        this.avcDecoderConfigurationRecord.configurationVersion = configurationVersion;
    }

    public int getAvcProfileIndication() {
        return this.avcDecoderConfigurationRecord.avcProfileIndication;
    }

    public void setAvcProfileIndication(int avcProfileIndication) {
        this.avcDecoderConfigurationRecord.avcProfileIndication = avcProfileIndication;
    }

    public int getProfileCompatibility() {
        return this.avcDecoderConfigurationRecord.profileCompatibility;
    }

    public void setProfileCompatibility(int profileCompatibility) {
        this.avcDecoderConfigurationRecord.profileCompatibility = profileCompatibility;
    }

    public int getAvcLevelIndication() {
        return this.avcDecoderConfigurationRecord.avcLevelIndication;
    }

    public void setAvcLevelIndication(int avcLevelIndication) {
        this.avcDecoderConfigurationRecord.avcLevelIndication = avcLevelIndication;
    }

    public int getLengthSizeMinusOne() {
        return this.avcDecoderConfigurationRecord.lengthSizeMinusOne;
    }

    public void setLengthSizeMinusOne(int lengthSizeMinusOne) {
        this.avcDecoderConfigurationRecord.lengthSizeMinusOne = lengthSizeMinusOne;
    }

    public List<byte[]> getSequenceParameterSets() {
        return Collections.unmodifiableList(this.avcDecoderConfigurationRecord.sequenceParameterSets);
    }

    public void setSequenceParameterSets(List<byte[]> sequenceParameterSets) {
        this.avcDecoderConfigurationRecord.sequenceParameterSets = sequenceParameterSets;
    }

    public List<byte[]> getPictureParameterSets() {
        return Collections.unmodifiableList(this.avcDecoderConfigurationRecord.pictureParameterSets);
    }

    public void setPictureParameterSets(List<byte[]> pictureParameterSets) {
        this.avcDecoderConfigurationRecord.pictureParameterSets = pictureParameterSets;
    }

    public int getChromaFormat() {
        return this.avcDecoderConfigurationRecord.chromaFormat;
    }

    public void setChromaFormat(int chromaFormat) {
        this.avcDecoderConfigurationRecord.chromaFormat = chromaFormat;
    }

    public int getBitDepthLumaMinus8() {
        return this.avcDecoderConfigurationRecord.bitDepthLumaMinus8;
    }

    public void setBitDepthLumaMinus8(int bitDepthLumaMinus8) {
        this.avcDecoderConfigurationRecord.bitDepthLumaMinus8 = bitDepthLumaMinus8;
    }

    public int getBitDepthChromaMinus8() {
        return this.avcDecoderConfigurationRecord.bitDepthChromaMinus8;
    }

    public void setBitDepthChromaMinus8(int bitDepthChromaMinus8) {
        this.avcDecoderConfigurationRecord.bitDepthChromaMinus8 = bitDepthChromaMinus8;
    }

    public List<byte[]> getSequenceParameterSetExts() {
        return this.avcDecoderConfigurationRecord.sequenceParameterSetExts;
    }

    public void setSequenceParameterSetExts(List<byte[]> sequenceParameterSetExts) {
        this.avcDecoderConfigurationRecord.sequenceParameterSetExts = sequenceParameterSetExts;
    }

    public boolean hasExts() {
        return this.avcDecoderConfigurationRecord.hasExts;
    }

    public void setHasExts(boolean hasExts) {
        this.avcDecoderConfigurationRecord.hasExts = hasExts;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.avcDecoderConfigurationRecord = new AVCDecoderConfigurationRecord(content);
    }

    @Override
    public long getContentSize() {
        return this.avcDecoderConfigurationRecord.getContentSize();
    }

    @Override
    public void getContent(ByteBuffer byteBuffer) {
        this.avcDecoderConfigurationRecord.getContent(byteBuffer);
    }

    public String[] getSPS() {
        return this.avcDecoderConfigurationRecord.getSPS();
    }

    public String[] getPPS() {
        return this.avcDecoderConfigurationRecord.getPPS();
    }

    public List<String> getSequenceParameterSetsAsStrings() {
        return this.avcDecoderConfigurationRecord.getSequenceParameterSetsAsStrings();
    }

    public List<String> getSequenceParameterSetExtsAsStrings() {
        return this.avcDecoderConfigurationRecord.getSequenceParameterSetExtsAsStrings();
    }

    public List<String> getPictureParameterSetsAsStrings() {
        return this.avcDecoderConfigurationRecord.getPictureParameterSetsAsStrings();
    }

    public AVCDecoderConfigurationRecord getavcDecoderConfigurationRecord() {
        return this.avcDecoderConfigurationRecord;
    }

    public static class AVCDecoderConfigurationRecord {
        public int configurationVersion;
        public int avcProfileIndication;
        public int profileCompatibility;
        public int avcLevelIndication;
        public int lengthSizeMinusOne;
        public List<byte[]> sequenceParameterSets = new ArrayList<byte[]>();
        public List<byte[]> pictureParameterSets = new ArrayList<byte[]>();
        public boolean hasExts = true;
        public int chromaFormat = 1;
        public int bitDepthLumaMinus8 = 0;
        public int bitDepthChromaMinus8 = 0;
        public List<byte[]> sequenceParameterSetExts = new ArrayList<byte[]>();
        public int lengthSizeMinusOnePaddingBits = 60;
        public int numberOfSequenceParameterSetsPaddingBits = 7;
        public int chromaFormatPaddingBits = 31;
        public int bitDepthLumaMinus8PaddingBits = 31;
        public int bitDepthChromaMinus8PaddingBits = 31;

        public AVCDecoderConfigurationRecord() {
        }

        public AVCDecoderConfigurationRecord(ByteBuffer content) {
            this.configurationVersion = IsoTypeReader.readUInt8(content);
            this.avcProfileIndication = IsoTypeReader.readUInt8(content);
            this.profileCompatibility = IsoTypeReader.readUInt8(content);
            this.avcLevelIndication = IsoTypeReader.readUInt8(content);
            BitReaderBuffer brb = new BitReaderBuffer(content);
            this.lengthSizeMinusOnePaddingBits = brb.readBits(6);
            this.lengthSizeMinusOne = brb.readBits(2);
            this.numberOfSequenceParameterSetsPaddingBits = brb.readBits(3);
            int numberOfSeuqenceParameterSets = brb.readBits(5);
            for (int i = 0; i < numberOfSeuqenceParameterSets; ++i) {
                int sequenceParameterSetLength = IsoTypeReader.readUInt16(content);
                byte[] sequenceParameterSetNALUnit = new byte[sequenceParameterSetLength];
                content.get(sequenceParameterSetNALUnit);
                this.sequenceParameterSets.add(sequenceParameterSetNALUnit);
            }
            long numberOfPictureParameterSets = IsoTypeReader.readUInt8(content);
            int i = 0;
            while ((long)i < numberOfPictureParameterSets) {
                int pictureParameterSetLength = IsoTypeReader.readUInt16(content);
                byte[] pictureParameterSetNALUnit = new byte[pictureParameterSetLength];
                content.get(pictureParameterSetNALUnit);
                this.pictureParameterSets.add(pictureParameterSetNALUnit);
                ++i;
            }
            if (content.remaining() < 4) {
                this.hasExts = false;
            }
            if (this.hasExts && (this.avcProfileIndication == 100 || this.avcProfileIndication == 110 || this.avcProfileIndication == 122 || this.avcProfileIndication == 144)) {
                brb = new BitReaderBuffer(content);
                this.chromaFormatPaddingBits = brb.readBits(6);
                this.chromaFormat = brb.readBits(2);
                this.bitDepthLumaMinus8PaddingBits = brb.readBits(5);
                this.bitDepthLumaMinus8 = brb.readBits(3);
                this.bitDepthChromaMinus8PaddingBits = brb.readBits(5);
                this.bitDepthChromaMinus8 = brb.readBits(3);
                long numOfSequenceParameterSetExt = IsoTypeReader.readUInt8(content);
                int i2 = 0;
                while ((long)i2 < numOfSequenceParameterSetExt) {
                    int sequenceParameterSetExtLength = IsoTypeReader.readUInt16(content);
                    byte[] sequenceParameterSetExtNALUnit = new byte[sequenceParameterSetExtLength];
                    content.get(sequenceParameterSetExtNALUnit);
                    this.sequenceParameterSetExts.add(sequenceParameterSetExtNALUnit);
                    ++i2;
                }
            } else {
                this.chromaFormat = -1;
                this.bitDepthLumaMinus8 = -1;
                this.bitDepthChromaMinus8 = -1;
            }
        }

        public void getContent(ByteBuffer byteBuffer) {
            IsoTypeWriter.writeUInt8(byteBuffer, this.configurationVersion);
            IsoTypeWriter.writeUInt8(byteBuffer, this.avcProfileIndication);
            IsoTypeWriter.writeUInt8(byteBuffer, this.profileCompatibility);
            IsoTypeWriter.writeUInt8(byteBuffer, this.avcLevelIndication);
            BitWriterBuffer bwb = new BitWriterBuffer(byteBuffer);
            bwb.writeBits(this.lengthSizeMinusOnePaddingBits, 6);
            bwb.writeBits(this.lengthSizeMinusOne, 2);
            bwb.writeBits(this.numberOfSequenceParameterSetsPaddingBits, 3);
            bwb.writeBits(this.pictureParameterSets.size(), 5);
            for (byte[] sequenceParameterSetNALUnit : this.sequenceParameterSets) {
                IsoTypeWriter.writeUInt16(byteBuffer, sequenceParameterSetNALUnit.length);
                byteBuffer.put(sequenceParameterSetNALUnit);
            }
            IsoTypeWriter.writeUInt8(byteBuffer, this.pictureParameterSets.size());
            for (byte[] pictureParameterSetNALUnit : this.pictureParameterSets) {
                IsoTypeWriter.writeUInt16(byteBuffer, pictureParameterSetNALUnit.length);
                byteBuffer.put(pictureParameterSetNALUnit);
            }
            if (this.hasExts && (this.avcProfileIndication == 100 || this.avcProfileIndication == 110 || this.avcProfileIndication == 122 || this.avcProfileIndication == 144)) {
                bwb = new BitWriterBuffer(byteBuffer);
                bwb.writeBits(this.chromaFormatPaddingBits, 6);
                bwb.writeBits(this.chromaFormat, 2);
                bwb.writeBits(this.bitDepthLumaMinus8PaddingBits, 5);
                bwb.writeBits(this.bitDepthLumaMinus8, 3);
                bwb.writeBits(this.bitDepthChromaMinus8PaddingBits, 5);
                bwb.writeBits(this.bitDepthChromaMinus8, 3);
                for (byte[] sequenceParameterSetExtNALUnit : this.sequenceParameterSetExts) {
                    IsoTypeWriter.writeUInt16(byteBuffer, sequenceParameterSetExtNALUnit.length);
                    byteBuffer.put(sequenceParameterSetExtNALUnit);
                }
            }
        }

        public long getContentSize() {
            long size = 5L;
            ++size;
            for (byte[] sequenceParameterSetNALUnit : this.sequenceParameterSets) {
                size += 2L;
                size += (long)sequenceParameterSetNALUnit.length;
            }
            ++size;
            for (byte[] pictureParameterSetNALUnit : this.pictureParameterSets) {
                size += 2L;
                size += (long)pictureParameterSetNALUnit.length;
            }
            if (this.hasExts && (this.avcProfileIndication == 100 || this.avcProfileIndication == 110 || this.avcProfileIndication == 122 || this.avcProfileIndication == 144)) {
                size += 4L;
                for (byte[] sequenceParameterSetExtNALUnit : this.sequenceParameterSetExts) {
                    size += 2L;
                    size += (long)sequenceParameterSetExtNALUnit.length;
                }
            }
            return size;
        }

        public String[] getPPS() {
            ArrayList<String> l = new ArrayList<String>();
            for (byte[] pictureParameterSet : this.pictureParameterSets) {
                String details = "not parsable";
                try {
                    details = PictureParameterSet.read(pictureParameterSet).toString();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                l.add(details);
            }
            return l.toArray(new String[l.size()]);
        }

        public String[] getSPS() {
            ArrayList<String> l = new ArrayList<String>();
            for (byte[] sequenceParameterSet : this.sequenceParameterSets) {
                String detail = "not parsable";
                try {
                    detail = SeqParameterSet.read(new ByteArrayInputStream(sequenceParameterSet)).toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                l.add(detail);
            }
            return l.toArray(new String[l.size()]);
        }

        public List<String> getSequenceParameterSetsAsStrings() {
            ArrayList<String> result = new ArrayList<String>(this.sequenceParameterSets.size());
            for (byte[] parameterSet : this.sequenceParameterSets) {
                result.add(Hex.encodeHex(parameterSet));
            }
            return result;
        }

        public List<String> getSequenceParameterSetExtsAsStrings() {
            ArrayList<String> result = new ArrayList<String>(this.sequenceParameterSetExts.size());
            for (byte[] parameterSet : this.sequenceParameterSetExts) {
                result.add(Hex.encodeHex(parameterSet));
            }
            return result;
        }

        public List<String> getPictureParameterSetsAsStrings() {
            ArrayList<String> result = new ArrayList<String>(this.pictureParameterSets.size());
            for (byte[] parameterSet : this.pictureParameterSets) {
                result.add(Hex.encodeHex(parameterSet));
            }
            return result;
        }
    }
}

