/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class SampleAuxiliaryInformationOffsetsBox
extends AbstractFullBox {
    public static final String TYPE = "saio";
    private List<Long> offsets = new LinkedList<Long>();
    private long auxInfoType;
    private long auxInfoTypeParameter;

    public SampleAuxiliaryInformationOffsetsBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return 8 + (this.getVersion() == 0 ? 4 * this.offsets.size() : 8 * this.offsets.size()) + ((this.getFlags() & 1) == 1 ? 8 : 0);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        if ((this.getFlags() & 1) == 1) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.auxInfoType);
            IsoTypeWriter.writeUInt32(byteBuffer, this.auxInfoTypeParameter);
        }
        IsoTypeWriter.writeUInt32(byteBuffer, this.offsets.size());
        for (Long offset : this.offsets) {
            if (this.getVersion() == 0) {
                IsoTypeWriter.writeUInt32(byteBuffer, offset);
                continue;
            }
            IsoTypeWriter.writeUInt64(byteBuffer, offset);
        }
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        if ((this.getFlags() & 1) == 1) {
            this.auxInfoType = IsoTypeReader.readUInt32(content);
            this.auxInfoTypeParameter = IsoTypeReader.readUInt32(content);
        }
        int entryCount = CastUtils.l2i(IsoTypeReader.readUInt32(content));
        this.offsets.clear();
        for (int i = 0; i < entryCount; ++i) {
            if (this.getVersion() == 0) {
                this.offsets.add(IsoTypeReader.readUInt32(content));
                continue;
            }
            this.offsets.add(IsoTypeReader.readUInt64(content));
        }
    }

    public long getAuxInfoType() {
        return this.auxInfoType;
    }

    public void setAuxInfoType(long auxInfoType) {
        this.auxInfoType = auxInfoType;
    }

    public long getAuxInfoTypeParameter() {
        return this.auxInfoTypeParameter;
    }

    public void setAuxInfoTypeParameter(long auxInfoTypeParameter) {
        this.auxInfoTypeParameter = auxInfoTypeParameter;
    }

    public List<Long> getOffsets() {
        return this.offsets;
    }

    public void setOffsets(List<Long> offsets) {
        this.offsets = offsets;
    }
}

