/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres.embedded;

import io.zonky.test.db.postgres.embedded.ConnectionInfo;
import io.zonky.test.db.postgres.embedded.DatabasePreparer;
import io.zonky.test.db.postgres.embedded.EmbeddedPostgres;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.commons.lang3.RandomStringUtils;
import org.postgresql.ds.PGSimpleDataSource;

public class PreparedDbProvider {
    private static final String JDBC_FORMAT = "jdbc:postgresql://localhost:%d/%s";
    private static final Map<ClusterKey, PrepPipeline> CLUSTERS = new HashMap<ClusterKey, PrepPipeline>();
    private final PrepPipeline dbPreparer;

    public static PreparedDbProvider forPreparer(DatabasePreparer preparer) {
        return PreparedDbProvider.forPreparer(preparer, Collections.emptyList());
    }

    public static PreparedDbProvider forPreparer(DatabasePreparer preparer, Iterable<Consumer<EmbeddedPostgres.Builder>> customizers) {
        return new PreparedDbProvider(preparer, customizers);
    }

    private PreparedDbProvider(DatabasePreparer preparer, Iterable<Consumer<EmbeddedPostgres.Builder>> customizers) {
        try {
            this.dbPreparer = PreparedDbProvider.createOrFindPreparer(preparer, customizers);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static synchronized PrepPipeline createOrFindPreparer(DatabasePreparer preparer, Iterable<Consumer<EmbeddedPostgres.Builder>> customizers) throws IOException, SQLException {
        ClusterKey key = new ClusterKey(preparer, customizers);
        PrepPipeline result = CLUSTERS.get(key);
        if (result != null) {
            return result;
        }
        EmbeddedPostgres.Builder builder = EmbeddedPostgres.builder();
        customizers.forEach(c -> c.accept(builder));
        EmbeddedPostgres pg = builder.start();
        preparer.prepare(pg.getTemplateDatabase());
        result = new PrepPipeline(pg).start();
        CLUSTERS.put(key, result);
        return result;
    }

    public String createDatabase() throws SQLException {
        return this.getJdbcUri(this.createNewDB());
    }

    private DbInfo createNewDB() throws SQLException {
        return this.dbPreparer.getNextDb();
    }

    public ConnectionInfo createNewDatabase() throws SQLException {
        DbInfo dbInfo = this.createNewDB();
        return dbInfo == null || !dbInfo.isSuccess() ? null : new ConnectionInfo(dbInfo.getDbName(), dbInfo.getPort(), dbInfo.getUser(), dbInfo.getProperties());
    }

    public DataSource createDataSourceFromConnectionInfo(ConnectionInfo connectionInfo) throws SQLException {
        PGSimpleDataSource ds = new PGSimpleDataSource();
        ds.setPortNumber(connectionInfo.getPort());
        ds.setDatabaseName(connectionInfo.getDbName());
        ds.setUser(connectionInfo.getUser());
        Set<Map.Entry<String, String>> properties = connectionInfo.getProperties().entrySet();
        for (Map.Entry<String, String> property : properties) {
            ds.setProperty(property.getKey(), property.getValue());
        }
        return ds;
    }

    public DataSource createDataSource() throws SQLException {
        return this.createDataSourceFromConnectionInfo(this.createNewDatabase());
    }

    String getJdbcUri(DbInfo db) {
        return String.format(JDBC_FORMAT, db.port, db.dbName);
    }

    public Map<String, String> getConfigurationTweak(String dbModuleName) throws SQLException {
        DbInfo db = this.dbPreparer.getNextDb();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("ot.db." + dbModuleName + ".uri", this.getJdbcUri(db));
        result.put("ot.db." + dbModuleName + ".ds.user", db.user);
        return result;
    }

    private static void create(DataSource connectDb, String dbName, String userName) throws SQLException {
        if (dbName == null) {
            throw new IllegalStateException("the database name must not be null!");
        }
        if (userName == null) {
            throw new IllegalStateException("the user name must not be null!");
        }
        try (Connection c = connectDb.getConnection();
             PreparedStatement stmt = c.prepareStatement(String.format("CREATE DATABASE %s OWNER %s ENCODING = 'utf8'", dbName, userName));){
            stmt.execute();
        }
    }

    public static class DbInfo {
        private final String dbName;
        private final int port;
        private final String user;
        private final Map<String, String> properties;
        private final SQLException ex;

        public static DbInfo ok(String dbName, int port, String user) {
            return DbInfo.ok(dbName, port, user, Collections.emptyMap());
        }

        private static DbInfo ok(String dbName, int port, String user, Map<String, String> properties) {
            return new DbInfo(dbName, port, user, properties, null);
        }

        public static DbInfo error(SQLException e) {
            return new DbInfo(null, -1, null, Collections.emptyMap(), e);
        }

        private DbInfo(String dbName, int port, String user, Map<String, String> properties, SQLException e) {
            this.dbName = dbName;
            this.port = port;
            this.user = user;
            this.properties = properties;
            this.ex = e;
        }

        public int getPort() {
            return this.port;
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getUser() {
            return this.user;
        }

        public Map<String, String> getProperties() {
            return Collections.unmodifiableMap(this.properties);
        }

        public SQLException getException() {
            return this.ex;
        }

        public boolean isSuccess() {
            return this.ex == null;
        }
    }

    private static class ClusterKey {
        private final DatabasePreparer preparer;
        private final EmbeddedPostgres.Builder builder;

        ClusterKey(DatabasePreparer preparer, Iterable<Consumer<EmbeddedPostgres.Builder>> customizers) {
            this.preparer = preparer;
            this.builder = EmbeddedPostgres.builder();
            customizers.forEach(c -> c.accept(this.builder));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterKey that = (ClusterKey)o;
            return Objects.equals(this.preparer, that.preparer) && Objects.equals(this.builder, that.builder);
        }

        public int hashCode() {
            return Objects.hash(this.preparer, this.builder);
        }
    }

    private static class PrepPipeline
    implements Runnable {
        private final EmbeddedPostgres pg;
        private final SynchronousQueue<DbInfo> nextDatabase = new SynchronousQueue();

        PrepPipeline(EmbeddedPostgres pg) {
            this.pg = pg;
        }

        PrepPipeline start() {
            ExecutorService service = Executors.newSingleThreadExecutor(r -> {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("cluster-" + this.pg + "-preparer");
                return t;
            });
            service.submit(this);
            service.shutdown();
            return this;
        }

        DbInfo getNextDb() throws SQLException {
            try {
                DbInfo next = this.nextDatabase.take();
                if (next.ex != null) {
                    throw next.ex;
                }
                return next;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void run() {
            while (true) {
                String newDbName = RandomStringUtils.randomAlphabetic((int)12).toLowerCase(Locale.ENGLISH);
                SQLException failure = null;
                try {
                    PreparedDbProvider.create(this.pg.getPostgresDatabase(), newDbName, "postgres");
                }
                catch (SQLException e) {
                    failure = e;
                }
                try {
                    if (failure == null) {
                        this.nextDatabase.put(DbInfo.ok(newDbName, this.pg.getPort(), "postgres", this.pg.getConnectConfig()));
                        continue;
                    }
                    this.nextDatabase.put(DbInfo.error(failure));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }
}

