/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.mariadb;

import io.zonky.test.db.provider.support.AbstractEmbeddedDatabase;
import io.zonky.test.db.util.ReflectionUtils;
import java.util.List;
import javax.sql.DataSource;
import org.mariadb.jdbc.MariaDbDataSource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MariaDBEmbeddedDatabase
extends AbstractEmbeddedDatabase {
    private final MariaDbDataSource dataSource;
    private final Object conf;

    public MariaDBEmbeddedDatabase(MariaDbDataSource dataSource, Runnable closeCallback) {
        super(closeCallback);
        this.dataSource = dataSource;
        this.conf = ClassUtils.hasMethod(MariaDbDataSource.class, (String)"getUrl", (Class[])new Class[0]) ? ReflectionUtils.getField(dataSource, "conf") : null;
    }

    @Override
    protected DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getJdbcUrl() {
        String url = String.format("jdbc:mariadb://%s:%s/%s?user=%s", this.getServerName(), this.getPortNumber(), this.getDatabaseName(), this.dataSource.getUser());
        if (StringUtils.hasText((String)this.getPassword())) {
            url = url + String.format("&password=%s", this.getPassword());
        }
        return url;
    }

    public String getServerName() {
        if (this.conf != null) {
            return (String)ReflectionUtils.getField(this.getHostAddress(), "host");
        }
        return (String)ReflectionUtils.invokeMethod(this.dataSource, "getServerName", new Object[0]);
    }

    public int getPortNumber() {
        if (this.conf != null) {
            return (Integer)ReflectionUtils.getField(this.getHostAddress(), "port");
        }
        return (Integer)ReflectionUtils.invokeMethod(this.dataSource, "getPortNumber", new Object[0]);
    }

    public String getDatabaseName() {
        if (this.conf != null) {
            return (String)ReflectionUtils.getField(this.conf, "database");
        }
        return (String)ReflectionUtils.invokeMethod(this.dataSource, "getDatabaseName", new Object[0]);
    }

    private String getPassword() {
        return (String)ReflectionUtils.getField(this.dataSource, "password");
    }

    private Object getHostAddress() {
        List addresses = (List)ReflectionUtils.invokeMethod(this.conf, "addresses", new Object[0]);
        if (addresses != null && addresses.size() > 0) {
            return addresses.get(0);
        }
        throw new IllegalStateException("Missing host address");
    }
}

