/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.context;

import io.zonky.test.db.context.DatabaseContext;
import io.zonky.test.db.context.DatabaseTargetSource;
import javax.sql.DataSource;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.core.Ordered;

public class EmbeddedDatabaseFactoryBean
implements FactoryBean<DataSource>,
Ordered {
    private final ObjectFactory<DatabaseContext> databaseContextProvider;
    private DataSource dataSource;

    public EmbeddedDatabaseFactoryBean(ObjectFactory<DatabaseContext> databaseContextProvider) {
        this.databaseContextProvider = databaseContextProvider;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return DataSource.class;
    }

    public synchronized DataSource getObject() {
        if (this.dataSource == null) {
            DatabaseContext databaseContext = (DatabaseContext)this.databaseContextProvider.getObject();
            this.dataSource = (DataSource)ProxyFactory.getProxy(DataSource.class, (TargetSource)new DatabaseTargetSource(databaseContext));
        }
        return this.dataSource;
    }
}

