/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.support;

import io.zonky.test.db.config.MissingDatabaseProviderException;
import io.zonky.test.db.config.Provider;
import io.zonky.test.db.provider.DatabaseProvider;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableMap;
import io.zonky.test.db.support.ProviderDescriptor;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.core.type.MethodMetadata;

public class DatabaseProviders {
    private final Map<ProviderDescriptor, ObjectFactory<DatabaseProvider>> databaseProviders;

    public DatabaseProviders(ConfigurableListableBeanFactory beanFactory) {
        String[] beanNames;
        ImmutableMap.Builder<ProviderDescriptor, ObjectFactory> builder = ImmutableMap.builder();
        for (String beanName : beanNames = beanFactory.getBeanNamesForType(DatabaseProvider.class, true, false)) {
            ProviderDescriptor descriptor = DatabaseProviders.resolveDescriptor(beanFactory, beanName);
            if (descriptor == null) continue;
            builder.put(descriptor, () -> (DatabaseProvider)beanFactory.getBean(beanName, DatabaseProvider.class));
        }
        this.databaseProviders = builder.build();
    }

    public DatabaseProvider getProvider(ProviderDescriptor descriptor) {
        ObjectFactory<DatabaseProvider> factory = this.databaseProviders.get(descriptor);
        if (factory == null) {
            List<String> availableProviders = this.databaseProviders.keySet().stream().filter(d -> d.getDatabaseName().equals(descriptor.getDatabaseName())).map(ProviderDescriptor::getProviderName).collect(Collectors.toList());
            throw new MissingDatabaseProviderException(descriptor, availableProviders);
        }
        return (DatabaseProvider)factory.getObject();
    }

    private static ProviderDescriptor resolveDescriptor(ConfigurableListableBeanFactory beanFactory, String beanName) {
        Map qualifier;
        MethodMetadata factoryMethodMetadata;
        AutowireCandidateQualifier qualifier2;
        BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
        if (!beanDefinition.isAbstract() && beanDefinition instanceof AbstractBeanDefinition && (qualifier2 = ((AbstractBeanDefinition)beanDefinition).getQualifier(Provider.class.getName())) != null) {
            String providerType = (String)qualifier2.getAttribute("type");
            String databaseType = (String)qualifier2.getAttribute("database");
            return ProviderDescriptor.of(providerType, databaseType);
        }
        if (!beanDefinition.isAbstract() && beanDefinition instanceof AnnotatedBeanDefinition && (factoryMethodMetadata = ((AnnotatedBeanDefinition)beanDefinition).getFactoryMethodMetadata()) != null && (qualifier = factoryMethodMetadata.getAnnotationAttributes(Provider.class.getName(), true)) != null) {
            String providerType = (String)qualifier.get("type");
            String databaseType = (String)qualifier.get("database");
            return ProviderDescriptor.of(providerType, databaseType);
        }
        return null;
    }
}

