/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.mariadb;

import io.zonky.test.db.provider.support.AbstractEmbeddedDatabase;
import io.zonky.test.db.util.ReflectionUtils;
import javax.sql.DataSource;
import org.mariadb.jdbc.MariaDbDataSource;
import org.springframework.util.StringUtils;

public class MariaDBEmbeddedDatabase
extends AbstractEmbeddedDatabase {
    private final MariaDbDataSource dataSource;

    public MariaDBEmbeddedDatabase(MariaDbDataSource dataSource, Runnable closeCallback) {
        super(closeCallback);
        this.dataSource = dataSource;
    }

    @Override
    protected DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getJdbcUrl() {
        String url = String.format("jdbc:mariadb://%s:%s/%s?user=%s", this.dataSource.getServerName(), this.dataSource.getPort(), this.dataSource.getDatabaseName(), this.dataSource.getUser());
        if (StringUtils.hasText((String)this.getPassword())) {
            url = url + String.format("&password=%s", this.getPassword());
        }
        return url;
    }

    private String getPassword() {
        return (String)ReflectionUtils.getField(this.dataSource, "password");
    }
}

