/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.api.resolver.MigrationResolver;

public class FlywayConfigSnapshot
implements FlywayConfiguration {
    private final ClassLoader classLoader;
    private final DataSource dataSource;
    private final FlywayCallback[] callbacks;
    private final MigrationResolver[] resolvers;
    private final String[] locations;
    private final String[] schemas;
    private final MigrationVersion baselineVersion;
    private final MigrationVersion target;
    private final Map<String, String> placeholders;
    private final String table;
    private final String baselineDescription;
    private final String repeatableSqlMigrationPrefix;
    private final String sqlMigrationSeparator;
    private final String sqlMigrationPrefix;
    private final String sqlMigrationSuffix;
    private final String placeholderPrefix;
    private final String placeholderSuffix;
    private final String encoding;
    private final boolean skipDefaultResolvers;
    private final boolean skipDefaultCallbacks;
    private final boolean placeholderReplacement;
    private final boolean baselineOnMigrate;
    private final boolean outOfOrder;
    private final boolean ignoreMissingMigrations;
    private final boolean ignoreFutureMigrations;
    private final boolean validateOnMigrate;
    private final boolean cleanOnValidationError;
    private final boolean cleanDisabled;
    private final boolean allowMixedMigrations;
    private final boolean mixed;
    private final boolean group;
    private final String installedBy;

    public FlywayConfigSnapshot(Flyway flyway) {
        this.classLoader = flyway.getClassLoader();
        this.dataSource = flyway.getDataSource();
        this.baselineVersion = flyway.getBaselineVersion();
        this.baselineDescription = flyway.getBaselineDescription();
        this.resolvers = flyway.getResolvers();
        this.skipDefaultResolvers = flyway.isSkipDefaultResolvers();
        this.callbacks = flyway.getCallbacks();
        this.skipDefaultCallbacks = flyway.isSkipDefaultCallbacks();
        this.sqlMigrationSuffix = flyway.getSqlMigrationSuffix();
        this.repeatableSqlMigrationPrefix = flyway.getRepeatableSqlMigrationPrefix();
        this.sqlMigrationSeparator = flyway.getSqlMigrationSeparator();
        this.sqlMigrationPrefix = flyway.getSqlMigrationPrefix();
        this.placeholderReplacement = flyway.isPlaceholderReplacement();
        this.placeholderSuffix = flyway.getPlaceholderSuffix();
        this.placeholderPrefix = flyway.getPlaceholderPrefix();
        this.placeholders = flyway.getPlaceholders();
        this.target = flyway.getTarget();
        this.table = flyway.getTable();
        this.schemas = flyway.getSchemas();
        this.encoding = flyway.getEncoding();
        this.locations = flyway.getLocations();
        this.baselineOnMigrate = flyway.isBaselineOnMigrate();
        this.outOfOrder = flyway.isOutOfOrder();
        this.ignoreMissingMigrations = flyway.isIgnoreMissingMigrations();
        this.ignoreFutureMigrations = flyway.isIgnoreFutureMigrations();
        this.validateOnMigrate = flyway.isValidateOnMigrate();
        this.cleanOnValidationError = flyway.isCleanOnValidationError();
        this.cleanDisabled = flyway.isCleanDisabled();
        this.allowMixedMigrations = flyway.isAllowMixedMigrations();
        this.mixed = flyway.isMixed();
        this.group = flyway.isGroup();
        this.installedBy = flyway.getInstalledBy();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public MigrationVersion getBaselineVersion() {
        return this.baselineVersion;
    }

    public String getBaselineDescription() {
        return this.baselineDescription;
    }

    public MigrationResolver[] getResolvers() {
        return this.resolvers;
    }

    public boolean isSkipDefaultResolvers() {
        return this.skipDefaultResolvers;
    }

    public FlywayCallback[] getCallbacks() {
        return this.callbacks;
    }

    public boolean isSkipDefaultCallbacks() {
        return this.skipDefaultCallbacks;
    }

    public String getSqlMigrationSuffix() {
        return this.sqlMigrationSuffix;
    }

    public String getRepeatableSqlMigrationPrefix() {
        return this.repeatableSqlMigrationPrefix;
    }

    public String getSqlMigrationSeparator() {
        return this.sqlMigrationSeparator;
    }

    public String getSqlMigrationPrefix() {
        return this.sqlMigrationPrefix;
    }

    public boolean isPlaceholderReplacement() {
        return this.placeholderReplacement;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public MigrationVersion getTarget() {
        return this.target;
    }

    public String getTable() {
        return this.table;
    }

    public String[] getSchemas() {
        return this.schemas;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public boolean isBaselineOnMigrate() {
        return this.baselineOnMigrate;
    }

    public boolean isOutOfOrder() {
        return this.outOfOrder;
    }

    public boolean isIgnoreMissingMigrations() {
        return this.ignoreMissingMigrations;
    }

    public boolean isIgnoreFutureMigrations() {
        return this.ignoreFutureMigrations;
    }

    public boolean isValidateOnMigrate() {
        return this.validateOnMigrate;
    }

    public boolean isCleanOnValidationError() {
        return this.cleanOnValidationError;
    }

    public boolean isCleanDisabled() {
        return this.cleanDisabled;
    }

    public boolean isAllowMixedMigrations() {
        return this.allowMixedMigrations;
    }

    public boolean isMixed() {
        return this.mixed;
    }

    public boolean isGroup() {
        return this.group;
    }

    public String getInstalledBy() {
        return this.installedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlywayConfigSnapshot that = (FlywayConfigSnapshot)o;
        return this.skipDefaultResolvers == that.skipDefaultResolvers && this.skipDefaultCallbacks == that.skipDefaultCallbacks && this.placeholderReplacement == that.placeholderReplacement && this.baselineOnMigrate == that.baselineOnMigrate && this.outOfOrder == that.outOfOrder && this.ignoreMissingMigrations == that.ignoreMissingMigrations && this.ignoreFutureMigrations == that.ignoreFutureMigrations && this.validateOnMigrate == that.validateOnMigrate && this.cleanOnValidationError == that.cleanOnValidationError && this.cleanDisabled == that.cleanDisabled && this.allowMixedMigrations == that.allowMixedMigrations && this.mixed == that.mixed && this.group == that.group && Arrays.equals(this.resolvers, that.resolvers) && Arrays.equals(this.locations, that.locations) && Arrays.equals(this.schemas, that.schemas) && Objects.equals(this.baselineVersion, that.baselineVersion) && Objects.equals(this.target, that.target) && Objects.equals(this.placeholders, that.placeholders) && Objects.equals(this.table, that.table) && Objects.equals(this.baselineDescription, that.baselineDescription) && Objects.equals(this.repeatableSqlMigrationPrefix, that.repeatableSqlMigrationPrefix) && Objects.equals(this.sqlMigrationSeparator, that.sqlMigrationSeparator) && Objects.equals(this.sqlMigrationPrefix, that.sqlMigrationPrefix) && Objects.equals(this.sqlMigrationSuffix, that.sqlMigrationSuffix) && Objects.equals(this.placeholderPrefix, that.placeholderPrefix) && Objects.equals(this.placeholderSuffix, that.placeholderSuffix) && Objects.equals(this.encoding, that.encoding) && Objects.equals(this.installedBy, that.installedBy);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.resolvers), Arrays.hashCode(this.locations), Arrays.hashCode(this.schemas), this.baselineVersion, this.target, this.placeholders, this.table, this.baselineDescription, this.repeatableSqlMigrationPrefix, this.sqlMigrationSeparator, this.sqlMigrationPrefix, this.sqlMigrationSuffix, this.placeholderPrefix, this.placeholderSuffix, this.encoding, this.skipDefaultResolvers, this.skipDefaultCallbacks, this.placeholderReplacement, this.baselineOnMigrate, this.outOfOrder, this.ignoreMissingMigrations, this.ignoreFutureMigrations, this.validateOnMigrate, this.cleanOnValidationError, this.cleanDisabled, this.allowMixedMigrations, this.mixed, this.group, this.installedBy);
    }
}

