/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.storage.ITStorage;
import zipkin2.storage.QueryRequest;
import zipkin2.storage.StorageComponent;

public abstract class ITSpanStoreHeavy<T extends StorageComponent>
extends ITStorage<T> {
    @Override
    protected boolean initializeStoragePerTest() {
        return true;
    }

    @Override
    protected final void configureStorageForTest(StorageComponent.Builder storage) {
    }

    @Test
    protected void traceWithManySpans(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStoreHeavy.testSuffix(testInfo);
        Span span = TestObjects.spanBuilder(testSuffix).build();
        int traceCount = 101;
        Span[] spans = new Span[traceCount];
        spans[0] = span;
        IntStream.range(1, spans.length).forEach(i -> {
            spans[i] = span.toBuilder().parentId(span.id()).id((long)i).timestamp((TestObjects.TODAY + (long)i) * 1000L).duration(10L).build();
        });
        this.accept(spans);
        this.assertGetTracesReturns(ITSpanStoreHeavy.requestBuilder().build(), List.of(spans));
        this.assertGetTraceReturns(span.traceId(), List.of(spans));
    }

    @Test
    protected void getTraces_manyTraces(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStoreHeavy.testSuffix(testInfo);
        Span span = TestObjects.spanBuilder(testSuffix).build();
        Map.Entry tag = span.tags().entrySet().iterator().next();
        int traceCount = 1000;
        Span[] traces = new Span[traceCount];
        traces[0] = span;
        IntStream.range(1, traces.length).forEach(i -> {
            traces[i] = TestObjects.spanBuilder(testSuffix).timestamp((TestObjects.TODAY + (long)i) * 1000L).duration(10L).build();
        });
        this.accept(traces);
        this.assertGetTracesReturnsCount(ITSpanStoreHeavy.requestBuilder().limit(traceCount).build(), traceCount);
        QueryRequest.Builder builder = ITSpanStoreHeavy.requestBuilder().limit(traceCount).serviceName(span.localServiceName());
        this.assertGetTracesReturnsCount(builder.build(), traceCount);
        this.assertGetTracesReturnsCount(builder.remoteServiceName(span.remoteServiceName()).build(), traceCount);
        this.assertGetTracesReturnsCount(builder.spanName(span.name()).build(), traceCount);
        this.assertGetTracesReturnsCount(builder.parseAnnotationQuery((String)tag.getKey() + "=" + (String)tag.getValue()).build(), traceCount);
    }
}

