/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestInstance;
import zipkin2.Annotation;
import zipkin2.DependencyLink;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.internal.DependencyLinker;
import zipkin2.storage.GroupByTraceId;
import zipkin2.storage.ITStorage;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StorageComponent;
import zipkin2.v1.V1Span;
import zipkin2.v1.V1SpanConverter;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class ITDependencies<T extends StorageComponent>
extends ITStorage<T> {
    @Override
    protected final void configureStorageForTest(StorageComponent.Builder storage) {
    }

    protected void processDependencies(List<Span> spans) throws Exception {
        Assertions.assertThat(spans).isNotEmpty();
        this.storage.spanConsumer().accept(spans).execute();
        this.blockWhileInFlight();
    }

    @Test
    protected void getDependencies(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        List<Span> trace = TestObjects.newTrace(testSuffix);
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(trace), TestObjects.DAY).execute())).containsExactlyInAnyOrderElementsOf(ITDependencies.links(testSuffix));
    }

    @Test
    protected void getDependencies_linksMixedTraceId(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        String traceId = TestObjects.newTraceId();
        Endpoint frontend = TestObjects.suffixServiceName(TestObjects.FRONTEND, testSuffix);
        Endpoint backend = TestObjects.suffixServiceName(TestObjects.BACKEND, testSuffix);
        List<Span> mixedTrace = List.of(Span.newBuilder().traceId(traceId).id("1").name("get").kind(Span.Kind.SERVER).timestamp(TestObjects.TODAY * 1000L).duration(350000L).localEndpoint(frontend).build(), Span.newBuilder().traceId(traceId.substring(16)).parentId("1").id("2").name("get").kind(Span.Kind.SERVER).shared(true).timestamp((TestObjects.TODAY + 100L) * 1000L).duration(250000L).localEndpoint(backend).build(), Span.newBuilder().traceId(traceId).parentId("1").id("2").kind(Span.Kind.CLIENT).timestamp((TestObjects.TODAY + 50L) * 1000L).duration(300000L).localEndpoint(frontend).build());
        this.processDependencies(mixedTrace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(mixedTrace), TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent(frontend.serviceName()).child(backend.serviceName()).callCount(1L).build()});
    }

    @Test
    protected void replayOverwrites(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        List<Span> trace = TestObjects.newTrace(testSuffix);
        this.processDependencies(trace);
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(trace), TestObjects.DAY).execute())).containsExactlyInAnyOrderElementsOf(ITDependencies.links(testSuffix));
    }

    @Test
    protected void empty() throws Exception {
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TODAY, TestObjects.DAY).execute())).isEmpty();
    }

    @Test
    protected void getDependenciesAllInstrumented(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        String traceId = TestObjects.newTraceId();
        String frontend = TestObjects.appendSuffix(TestObjects.FRONTEND.serviceName(), testSuffix);
        String backend = TestObjects.appendSuffix(TestObjects.BACKEND.serviceName(), testSuffix);
        String db = TestObjects.appendSuffix(TestObjects.DB.serviceName(), testSuffix);
        Endpoint one = Endpoint.newBuilder().serviceName(frontend).ip("127.0.0.1").build();
        Endpoint onePort3001 = one.toBuilder().port(3001).build();
        Endpoint two = Endpoint.newBuilder().serviceName(backend).ip("127.0.0.2").build();
        Endpoint twoPort3002 = two.toBuilder().port(3002).build();
        Endpoint three = Endpoint.newBuilder().serviceName(db).ip("127.0.0.3").build();
        List<Span> trace = List.of(Span.newBuilder().traceId(traceId).id("10").name("get").kind(Span.Kind.SERVER).timestamp(TestObjects.TODAY * 1000L).duration(350000L).localEndpoint(one).build(), Span.newBuilder().traceId(traceId).parentId("10").id("20").name("get").kind(Span.Kind.CLIENT).timestamp((TestObjects.TODAY + 50L) * 1000L).duration(250000L).localEndpoint(onePort3001).build(), Span.newBuilder().traceId(traceId).parentId("10").id("20").name("get").shared(true).kind(Span.Kind.SERVER).timestamp((TestObjects.TODAY + 100L) * 1000L).duration(150000L).localEndpoint(two).build(), Span.newBuilder().traceId(traceId).parentId("20").id("30").name("query").kind(Span.Kind.CLIENT).timestamp((TestObjects.TODAY + 150L) * 1000L).duration(50000L).localEndpoint(twoPort3002).build(), Span.newBuilder().traceId(traceId).parentId("20").id("30").name("query").shared(true).kind(Span.Kind.SERVER).timestamp((TestObjects.TODAY + 160L) * 1000L).duration(20000L).localEndpoint(three).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(trace), TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent(frontend).child(backend).callCount(1L).build(), DependencyLink.newBuilder().parent(backend).child(db).callCount(1L).build()});
    }

    @Test
    protected void dependencies_loopback(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        List<Span> trace = TestObjects.newTrace(testSuffix);
        List<Span> traceWithLoopback = List.of(trace.get(0), trace.get(1).toBuilder().remoteEndpoint(trace.get(0).localEndpoint()).build());
        this.processDependencies(traceWithLoopback);
        String frontend = TestObjects.appendSuffix(TestObjects.FRONTEND.serviceName(), testSuffix);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(trace), TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent(frontend).child(frontend).callCount(1L).build()});
    }

    @Test
    protected void dependencies_headlessTrace(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        ArrayList<Span> trace = new ArrayList<Span>(TestObjects.newTrace(testSuffix));
        trace.remove(0);
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(trace), TestObjects.DAY).execute())).containsExactlyInAnyOrderElementsOf(ITDependencies.links(testSuffix));
    }

    @Test
    protected void looksBackIndefinitely(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        List<Span> trace = TestObjects.newTrace(testSuffix);
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(trace), TestObjects.DAY).execute())).containsExactlyInAnyOrderElementsOf(ITDependencies.links(testSuffix));
    }

    @Test
    protected void endTsInsideTheTrace(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        List<Span> trace = TestObjects.newTrace(testSuffix);
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.startTs(trace) + 100L, 200L).execute())).containsExactlyInAnyOrderElementsOf(ITDependencies.links(testSuffix));
    }

    @Test
    protected void endTimeBeforeData(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        List<Span> trace = TestObjects.newTrace(testSuffix);
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.startTs(trace) - 1000L, 1000L).execute())).isEmpty();
    }

    @Test
    protected void lookbackAfterData(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        List<Span> trace = TestObjects.newTrace(testSuffix);
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TODAY + 2L * TestObjects.DAY, TestObjects.DAY).execute())).isEmpty();
    }

    @Test
    protected void notInstrumentedClientAndServer(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        String traceId = TestObjects.newTraceId();
        Endpoint kafka = TestObjects.suffixServiceName(TestObjects.KAFKA, testSuffix);
        Endpoint frontend = TestObjects.suffixServiceName(TestObjects.FRONTEND, testSuffix);
        Endpoint backend = TestObjects.suffixServiceName(TestObjects.BACKEND, testSuffix);
        Endpoint db = TestObjects.suffixServiceName(TestObjects.DB, testSuffix);
        List<Span> trace = List.of(Span.newBuilder().traceId(traceId).id("20").name("get").timestamp(TestObjects.TODAY * 1000L).duration(350000L).kind(Span.Kind.SERVER).localEndpoint(frontend).remoteEndpoint(kafka).build(), Span.newBuilder().traceId(traceId).parentId("20").id("21").name("get").timestamp((TestObjects.TODAY + 50L) * 1000L).duration(250000L).kind(Span.Kind.CLIENT).localEndpoint(frontend).build(), Span.newBuilder().traceId(traceId).parentId("20").id("21").name("get").shared(true).timestamp((TestObjects.TODAY + 250L) * 1000L).duration(50000L).kind(Span.Kind.SERVER).localEndpoint(backend).build(), Span.newBuilder().traceId(traceId).parentId("21").id("22").name("get").timestamp((TestObjects.TODAY + 150L) * 1000L).duration(50000L).kind(Span.Kind.CLIENT).localEndpoint(backend).remoteEndpoint(db).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(trace), TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent(kafka.serviceName()).child(frontend.serviceName()).callCount(1L).build(), DependencyLink.newBuilder().parent(frontend.serviceName()).child(backend.serviceName()).callCount(1L).build(), DependencyLink.newBuilder().parent(backend.serviceName()).child(db.serviceName()).callCount(1L).build()});
    }

    @Test
    protected void endTsAndLookbackMustBePositive() {
        SpanStore store = this.store();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> store.getDependencies(0L, TestObjects.DAY)).isInstanceOf(IllegalArgumentException.class)).hasMessage("endTs <= 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> store.getDependencies(TestObjects.TODAY, 0L)).isInstanceOf(IllegalArgumentException.class)).hasMessage("lookback <= 0");
    }

    @Test
    protected void instrumentedClientAndServer(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        String traceId = TestObjects.newTraceId();
        Endpoint frontend = TestObjects.suffixServiceName(TestObjects.FRONTEND, testSuffix);
        Endpoint backend = TestObjects.suffixServiceName(TestObjects.BACKEND, testSuffix);
        Endpoint db = TestObjects.suffixServiceName(TestObjects.DB, testSuffix);
        List<Span> trace = List.of(Span.newBuilder().traceId(traceId).id("10").name("get").timestamp((TestObjects.TODAY + 50L) * 1000L).duration(250000L).kind(Span.Kind.CLIENT).localEndpoint(frontend).build(), Span.newBuilder().traceId(traceId).id("10").name("get").shared(true).timestamp((TestObjects.TODAY + 100L) * 1000L).duration(150000L).kind(Span.Kind.SERVER).localEndpoint(backend).build(), Span.newBuilder().traceId(traceId).parentId("10").id("11").name("get").timestamp((TestObjects.TODAY + 150L) * 1000L).duration(50000L).kind(Span.Kind.CLIENT).localEndpoint(backend).remoteEndpoint(db).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(trace), TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent(frontend.serviceName()).child(backend.serviceName()).callCount(1L).build(), DependencyLink.newBuilder().parent(backend.serviceName()).child(db.serviceName()).callCount(1L).build()});
    }

    @Test
    protected void instrumentedProducerAndConsumer(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        String traceId = TestObjects.newTraceId();
        Endpoint kafka = TestObjects.suffixServiceName(TestObjects.KAFKA, testSuffix);
        Endpoint frontend = TestObjects.suffixServiceName(TestObjects.FRONTEND, testSuffix);
        Endpoint backend = TestObjects.suffixServiceName(TestObjects.BACKEND, testSuffix);
        List<Span> trace = List.of(Span.newBuilder().traceId(traceId).id("10").name("send").timestamp((TestObjects.TODAY + 50L) * 1000L).duration(1L).kind(Span.Kind.PRODUCER).localEndpoint(frontend).remoteEndpoint(kafka).build(), Span.newBuilder().traceId(traceId).parentId("10").id("11").name("receive").timestamp((TestObjects.TODAY + 100L) * 1000L).duration(1L).kind(Span.Kind.CONSUMER).remoteEndpoint(kafka).localEndpoint(backend).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(trace), TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent(frontend.serviceName()).child(kafka.serviceName()).callCount(1L).build(), DependencyLink.newBuilder().parent(kafka.serviceName()).child(backend.serviceName()).callCount(1L).build()});
    }

    @Test
    protected void missingIntermediateSpan(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        String traceId = TestObjects.newTraceId();
        Endpoint frontend = TestObjects.suffixServiceName(TestObjects.FRONTEND, testSuffix);
        Endpoint backend = TestObjects.suffixServiceName(TestObjects.BACKEND, testSuffix);
        List<Span> trace = List.of(Span.newBuilder().traceId(traceId).id("20").name("get").timestamp(TestObjects.TODAY * 1000L).duration(350000L).kind(Span.Kind.SERVER).localEndpoint(frontend).build(), Span.newBuilder().traceId(traceId).parentId("21").id("22").name("get").timestamp((TestObjects.TODAY + 150L) * 1000L).duration(50000L).kind(Span.Kind.CLIENT).localEndpoint(backend).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(trace), TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent(frontend.serviceName()).child(backend.serviceName()).callCount(1L).build()});
    }

    @Test
    protected void canSearchForIntervalsBesidesToday(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        List<Span> trace = TestObjects.newTrace(testSuffix);
        this.processDependencies(this.subtractDay(trace));
        this.processDependencies(trace);
        long lookback = trace.get(0).durationAsLong() / 1000L;
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(trace), lookback).execute())).containsExactlyInAnyOrderElementsOf(ITDependencies.links(testSuffix));
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(trace) - TestObjects.DAY, TestObjects.DAY).execute())).containsExactlyInAnyOrderElementsOf(ITDependencies.links(testSuffix));
        String frontend = TestObjects.appendSuffix(TestObjects.FRONTEND.serviceName(), testSuffix);
        String backend = TestObjects.appendSuffix(TestObjects.BACKEND.serviceName(), testSuffix);
        String db = TestObjects.appendSuffix(TestObjects.DB.serviceName(), testSuffix);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(trace), TestObjects.DAY * 2L).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent(frontend).child(backend).callCount(2L).build(), DependencyLink.newBuilder().parent(backend).child(db).callCount(2L).errorCount(2L).build()});
    }

    @Test
    protected void spanKindIsNotRequiredWhenEndpointsArePresent(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        String traceId = TestObjects.newTraceId();
        Endpoint kafka = TestObjects.suffixServiceName(TestObjects.KAFKA, testSuffix);
        Endpoint frontend = TestObjects.suffixServiceName(TestObjects.FRONTEND, testSuffix);
        Endpoint backend = TestObjects.suffixServiceName(TestObjects.BACKEND, testSuffix);
        Endpoint db = TestObjects.suffixServiceName(TestObjects.DB, testSuffix);
        List<Span> trace = List.of(Span.newBuilder().traceId(traceId).id("20").name("get").timestamp(TestObjects.TODAY * 1000L).duration(350000L).localEndpoint(kafka).remoteEndpoint(frontend).build(), Span.newBuilder().traceId(traceId).parentId("20").id("21").name("get").timestamp((TestObjects.TODAY + 50L) * 1000L).duration(250000L).localEndpoint(frontend).remoteEndpoint(backend).build(), Span.newBuilder().traceId(traceId).parentId("21").id("22").name("get").timestamp((TestObjects.TODAY + 150L) * 1000L).duration(50000L).localEndpoint(backend).remoteEndpoint(db).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TODAY + 1000L, 1000L).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent(kafka.serviceName()).child(frontend.serviceName()).callCount(1L).build(), DependencyLink.newBuilder().parent(frontend.serviceName()).child(backend.serviceName()).callCount(1L).build(), DependencyLink.newBuilder().parent(backend.serviceName()).child(db.serviceName()).callCount(1L).build()});
    }

    @Test
    protected void unnamedEndpointsAreSkipped(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        String traceId = TestObjects.newTraceId();
        Endpoint frontend = TestObjects.suffixServiceName(TestObjects.FRONTEND, testSuffix);
        Endpoint backend = TestObjects.suffixServiceName(TestObjects.BACKEND, testSuffix);
        Endpoint db = TestObjects.suffixServiceName(TestObjects.DB, testSuffix);
        List<Span> trace = List.of(Span.newBuilder().traceId(traceId).id("20").name("get").timestamp(TestObjects.TODAY * 1000L).duration(350000L).localEndpoint(Endpoint.newBuilder().ip("172.17.0.4").build()).remoteEndpoint(frontend).build(), Span.newBuilder().traceId(traceId).parentId("20").id("21").name("get").timestamp((TestObjects.TODAY + 50L) * 1000L).duration(250000L).localEndpoint(frontend).remoteEndpoint(backend).build(), Span.newBuilder().traceId(traceId).parentId("21").id("22").name("get").timestamp((TestObjects.TODAY + 150L) * 1000L).duration(50000L).localEndpoint(backend).remoteEndpoint(db).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TODAY + 1000L, 1000L).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent(frontend.serviceName()).child(backend.serviceName()).callCount(1L).build(), DependencyLink.newBuilder().parent(backend.serviceName()).child(db.serviceName()).callCount(1L).build()});
    }

    @Test
    protected void intermediateSpans(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        String traceId = TestObjects.newTraceId();
        Endpoint frontend = TestObjects.suffixServiceName(TestObjects.FRONTEND, testSuffix);
        Endpoint backend = TestObjects.suffixServiceName(TestObjects.BACKEND, testSuffix);
        Endpoint db = TestObjects.suffixServiceName(TestObjects.DB, testSuffix);
        List<Span> trace = List.of(Span.newBuilder().traceId(traceId).id("20").name("get").timestamp(TestObjects.TODAY * 1000L).duration(350000L).kind(Span.Kind.SERVER).localEndpoint(frontend).build(), Span.newBuilder().traceId(traceId).parentId("20").id("21").name("call").timestamp((TestObjects.TODAY + 25L) * 1000L).duration(325000L).localEndpoint(frontend).build(), Span.newBuilder().traceId(traceId).parentId("21").id("22").name("get").timestamp((TestObjects.TODAY + 50L) * 1000L).duration(250000L).kind(Span.Kind.CLIENT).localEndpoint(frontend).build(), Span.newBuilder().traceId(traceId).parentId("21").id("22").name("get").timestamp((TestObjects.TODAY + 100L) * 1000L).duration(150000L).shared(true).kind(Span.Kind.SERVER).localEndpoint(backend).build(), Span.newBuilder().traceId(traceId).parentId("22").id(23L).name("call").timestamp((TestObjects.TODAY + 110L) * 1000L).duration(130000L).name("depth4").localEndpoint(backend).build(), Span.newBuilder().traceId(traceId).parentId(23L).id(24L).name("call").timestamp((TestObjects.TODAY + 125L) * 1000L).duration(105000L).name("depth5").localEndpoint(backend).build(), Span.newBuilder().traceId(traceId).parentId(24L).id(25L).name("get").timestamp((TestObjects.TODAY + 150L) * 1000L).duration(50000L).kind(Span.Kind.CLIENT).localEndpoint(backend).remoteEndpoint(db).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TODAY + 1000L, 1000L).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent(frontend.serviceName()).child(backend.serviceName()).callCount(1L).build(), DependencyLink.newBuilder().parent(backend.serviceName()).child(db.serviceName()).callCount(1L).build()});
    }

    @Test
    protected void duplicateAddress(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        String traceId = TestObjects.newTraceId();
        Endpoint frontend = TestObjects.suffixServiceName(TestObjects.FRONTEND, testSuffix);
        Endpoint backend = TestObjects.suffixServiceName(TestObjects.BACKEND, testSuffix);
        V1SpanConverter converter = V1SpanConverter.create();
        ArrayList<Span> trace = new ArrayList<Span>();
        converter.convert(V1Span.newBuilder().traceId(traceId).id("20").name("get").timestamp(TestObjects.TODAY * 1000L).duration(350000L).addAnnotation(TestObjects.TODAY * 1000L, "sr", frontend).addAnnotation((TestObjects.TODAY + 350L) * 1000L, "ss", frontend).addBinaryAnnotation("ca", frontend).addBinaryAnnotation("sa", frontend).build(), trace);
        converter.convert(V1Span.newBuilder().traceId(traceId).parentId("21").id("22").name("get").timestamp((TestObjects.TODAY + 50L) * 1000L).duration(250000L).addAnnotation((TestObjects.TODAY + 50L) * 1000L, "cs", frontend).addAnnotation((TestObjects.TODAY + 300L) * 1000L, "cr", frontend).addBinaryAnnotation("ca", backend).addBinaryAnnotation("sa", backend).build(), trace);
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TODAY + 1000L, 1000L).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent(frontend.serviceName()).child(backend.serviceName()).callCount(1L).build()});
    }

    @Test
    protected void oneway(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        String traceId = TestObjects.newTraceId();
        Endpoint frontend = TestObjects.suffixServiceName(TestObjects.FRONTEND, testSuffix);
        Endpoint backend = TestObjects.suffixServiceName(TestObjects.BACKEND, testSuffix);
        List<Span> trace = List.of(Span.newBuilder().traceId(traceId).id("10").timestamp((TestObjects.TODAY + 50L) * 1000L).kind(Span.Kind.CLIENT).localEndpoint(frontend).build(), Span.newBuilder().traceId(traceId).id("10").shared(true).timestamp((TestObjects.TODAY + 100L) * 1000L).kind(Span.Kind.SERVER).localEndpoint(backend).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(trace), TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent(frontend.serviceName()).child(backend.serviceName()).callCount(1L).build()});
    }

    @Test
    protected void annotationNamedErrorIsntError(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        String traceId = TestObjects.newTraceId();
        Endpoint frontend = TestObjects.suffixServiceName(TestObjects.FRONTEND, testSuffix);
        Endpoint backend = TestObjects.suffixServiceName(TestObjects.BACKEND, testSuffix);
        List<Span> trace = List.of(Span.newBuilder().traceId(traceId).id("10").timestamp((TestObjects.TODAY + 50L) * 1000L).kind(Span.Kind.CLIENT).localEndpoint(frontend).build(), Span.newBuilder().traceId(traceId).id("10").shared(true).timestamp((TestObjects.TODAY + 100L) * 1000L).kind(Span.Kind.SERVER).localEndpoint(backend).addAnnotation((TestObjects.TODAY + 72L) * 1000L, "error").build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(trace), TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent(frontend.serviceName()).child(backend.serviceName()).callCount(1L).build()});
    }

    @Test
    protected void oneway_noClient(TestInfo testInfo) throws Exception {
        String testSuffix = ITDependencies.testSuffix(testInfo);
        String traceId = TestObjects.newTraceId();
        Endpoint backend = TestObjects.suffixServiceName(TestObjects.BACKEND, testSuffix);
        Endpoint kafka = TestObjects.suffixServiceName(TestObjects.KAFKA, testSuffix);
        List<Span> trace = List.of(Span.newBuilder().traceId(traceId).id("10").name("receive").timestamp(TestObjects.TODAY * 1000L).kind(Span.Kind.SERVER).localEndpoint(backend).remoteEndpoint(kafka).build(), Span.newBuilder().traceId(traceId).parentId("10").id("11").name("process").timestamp((TestObjects.TODAY + 25L) * 1000L).duration(325000L).localEndpoint(backend).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.endTs(trace), TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent(kafka.serviceName()).child(backend.serviceName()).callCount(1L).build()});
    }

    List<Span> subtractDay(List<Span> trace) {
        long random = ThreadLocalRandom.current().nextLong();
        return trace.stream().map(s -> {
            Span.Builder b = s.toBuilder().traceId(0L, random);
            if (s.timestampAsLong() != 0L) {
                b.timestamp(s.timestampAsLong() - TestObjects.DAY * 1000L);
            }
            s.annotations().forEach(a -> b.addAnnotation(a.timestamp() - TestObjects.DAY * 1000L, a.value()));
            return b.build();
        }).collect(Collectors.toList());
    }

    public static Map<Long, List<DependencyLink>> aggregateLinks(List<Span> spans) {
        LinkedHashMap<Long, DependencyLinker> midnightToLinker = new LinkedHashMap<Long, DependencyLinker>();
        for (List trace : (List)GroupByTraceId.create((boolean)false).map(spans)) {
            long midnightOfTrace = ITDependencies.flooredTraceTimestamp(trace);
            DependencyLinker linker2 = (DependencyLinker)midnightToLinker.get(midnightOfTrace);
            if (linker2 == null) {
                linker2 = new DependencyLinker();
                midnightToLinker.put(midnightOfTrace, linker2);
            }
            linker2.putTrace(trace);
        }
        LinkedHashMap<Long, List<DependencyLink>> result = new LinkedHashMap<Long, List<DependencyLink>>();
        midnightToLinker.forEach((midnight, linker) -> result.put((Long)midnight, linker.link()));
        return result;
    }

    static Iterable<? extends DependencyLink> links(String testSuffix) {
        String frontend = TestObjects.appendSuffix(TestObjects.FRONTEND.serviceName(), testSuffix);
        String backend = TestObjects.appendSuffix(TestObjects.BACKEND.serviceName(), testSuffix);
        String db = TestObjects.appendSuffix(TestObjects.DB.serviceName(), testSuffix);
        return List.of(DependencyLink.newBuilder().parent(frontend).child(backend).callCount(1L).build(), DependencyLink.newBuilder().parent(backend).child(db).callCount(1L).errorCount(1L).build());
    }

    static long flooredTraceTimestamp(List<Span> trace) {
        long midnightOfTrace = Long.MAX_VALUE;
        for (Span span : trace) {
            long currentTs = ITDependencies.guessTimestamp(span);
            if (currentTs == 0L || currentTs >= midnightOfTrace) continue;
            midnightOfTrace = TestObjects.midnightUTC(currentTs / 1000L);
        }
        Assertions.assertThat((long)midnightOfTrace).isNotEqualTo(Long.MAX_VALUE);
        return midnightOfTrace;
    }

    static long guessTimestamp(Span span) {
        if (span.timestampAsLong() != 0L) {
            return span.timestampAsLong();
        }
        for (Annotation annotation : span.annotations()) {
            if (0L >= annotation.timestamp()) continue;
            return annotation.timestamp();
        }
        return 0L;
    }
}

