/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public final class ZipkinModuleImporter
implements ApplicationContextInitializer<GenericApplicationContext> {
    static final Logger LOG = LoggerFactory.getLogger(ZipkinModuleImporter.class);
    static final String PROPERTY_NAME_MODULE = "zipkin.internal.module";

    public void initialize(GenericApplicationContext context) {
        ConfigurableEnvironment env = context.getEnvironment();
        Map modules = (Map)Binder.get((Environment)env).bind(PROPERTY_NAME_MODULE, Map.class).orElse(null);
        if (modules == null || modules.isEmpty()) {
            LOG.debug("no modules found under path {}", (Object)PROPERTY_NAME_MODULE);
            return;
        }
        LOG.debug("attempting to load modules: {}", modules.keySet());
        for (Map.Entry module : modules.entrySet()) {
            try {
                context.registerBean(Class.forName((String)module.getValue()), new BeanDefinitionCustomizer[0]);
            }
            catch (Exception e) {
                LOG.debug("skipping unloadable module {}", module.getKey(), (Object)e);
            }
        }
    }
}

