/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.throttle;

import brave.Tracer;
import brave.Tracing;
import brave.propagation.CurrentTraceContext;
import com.linecorp.armeria.common.brave.RequestContextCurrentTraceContext;
import com.linecorp.armeria.common.util.Exceptions;
import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.limit.Gradient2Limit;
import com.netflix.concurrency.limits.limiter.AbstractLimiter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import zipkin2.Call;
import zipkin2.Span;
import zipkin2.internal.Nullable;
import zipkin2.server.internal.brave.TracedCall;
import zipkin2.server.internal.throttle.LimiterMetrics;
import zipkin2.server.internal.throttle.MicrometerThrottleMetrics;
import zipkin2.server.internal.throttle.ThrottledCall;
import zipkin2.storage.ForwardingStorageComponent;
import zipkin2.storage.SpanConsumer;
import zipkin2.storage.StorageComponent;

public final class ThrottledStorageComponent
extends ForwardingStorageComponent {
    static final RejectedExecutionException STORAGE_THROTTLE_MAX_QUEUE_SIZE = (RejectedExecutionException)Exceptions.clearTrace((Throwable)new RejectedExecutionException("STORAGE_THROTTLE_MAX_QUEUE_SIZE reached"));
    final StorageComponent delegate;
    @Nullable
    final Tracer tracer;
    @Nullable
    final CurrentTraceContext currentTraceContext;
    final AbstractLimiter<Void> limiter;
    final ThreadPoolExecutor executor;
    final LimiterMetrics limiterMetrics;

    public ThrottledStorageComponent(StorageComponent delegate, MeterRegistry registry, @Nullable Tracing tracing, int minConcurrency, int maxConcurrency, int maxQueueSize) {
        this.delegate = Objects.requireNonNull(delegate);
        this.tracer = tracing != null ? tracing.tracer() : null;
        this.currentTraceContext = tracing != null ? tracing.currentTraceContext() : null;
        Gradient2Limit limit = Gradient2Limit.newBuilder().minLimit(minConcurrency).initialLimit(minConcurrency).maxConcurrency(maxConcurrency).queueSize(0).build();
        this.limiter = ((Builder)new Builder().limit((Limit)limit)).build();
        this.executor = new ThreadPoolExecutor(limit.getLimit(), limit.getLimit(), 0L, TimeUnit.DAYS, ThrottledStorageComponent.createQueue(maxQueueSize), (ThreadFactory)new NamedThreadFactory("zipkin-throttle-pool"){

            public Thread newThread(final Runnable runnable) {
                return super.newThread(new Runnable(){

                    @Override
                    public void run() {
                        RequestContextCurrentTraceContext.setCurrentThreadNotRequestThread((boolean)true);
                        runnable.run();
                    }

                    public String toString() {
                        return runnable.toString();
                    }
                });
            }
        }, (r, e) -> {
            throw STORAGE_THROTTLE_MAX_QUEUE_SIZE;
        });
        limit.notifyOnChange((Consumer)new ThreadPoolExecutorResizer(this.executor));
        MicrometerThrottleMetrics metrics = new MicrometerThrottleMetrics(registry);
        metrics.bind(this.executor);
        metrics.bind(this.limiter);
        this.limiterMetrics = new LimiterMetrics(registry);
    }

    protected StorageComponent delegate() {
        return this.delegate;
    }

    public SpanConsumer spanConsumer() {
        return new ThrottledSpanConsumer(this);
    }

    public void close() throws IOException {
        this.executor.shutdownNow();
        this.delegate.close();
    }

    public String toString() {
        return "Throttled{" + this.delegate.toString() + "}";
    }

    static BlockingQueue<Runnable> createQueue(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxSize < 0");
        }
        if (maxSize == 0) {
            maxSize = 1;
        }
        return new LinkedBlockingQueue<Runnable>(maxSize);
    }

    static final class Builder
    extends AbstractLimiter.Builder<Builder> {
        Builder() {
        }

        NonLimitingLimiter build() {
            return new NonLimitingLimiter(this);
        }

        protected Builder self() {
            return this;
        }
    }

    static final class NonLimitingLimiter
    extends AbstractLimiter<Void> {
        NonLimitingLimiter(AbstractLimiter.Builder<?> builder) {
            super(builder);
        }

        public Optional<Limiter.Listener> acquire(Void context) {
            return Optional.of(this.createListener());
        }
    }

    static final class ThreadPoolExecutorResizer
    implements Consumer<Integer> {
        final ThreadPoolExecutor executor;

        ThreadPoolExecutorResizer(ThreadPoolExecutor executor) {
            this.executor = executor;
        }

        @Override
        public synchronized void accept(Integer newValue) {
            int newValueInt;
            int previousValue = this.executor.getCorePoolSize();
            if (previousValue < (newValueInt = newValue.intValue())) {
                this.executor.setMaximumPoolSize(newValueInt);
                this.executor.setCorePoolSize(newValueInt);
            } else if (previousValue > newValueInt) {
                this.executor.setCorePoolSize(newValueInt);
                this.executor.setMaximumPoolSize(newValueInt);
            }
        }
    }

    static final class ThrottledSpanConsumer
    implements SpanConsumer {
        final SpanConsumer delegate;
        final Executor executor;
        final Limiter<Void> limiter;
        final LimiterMetrics limiterMetrics;
        final Predicate<Throwable> isOverCapacity;
        @Nullable
        final Tracer tracer;

        ThrottledSpanConsumer(ThrottledStorageComponent throttledStorage) {
            this.delegate = throttledStorage.delegate.spanConsumer();
            this.executor = throttledStorage.currentTraceContext != null ? throttledStorage.currentTraceContext.executor((Executor)throttledStorage.executor) : throttledStorage.executor;
            this.limiter = throttledStorage.limiter;
            this.limiterMetrics = throttledStorage.limiterMetrics;
            this.isOverCapacity = arg_0 -> ((ThrottledStorageComponent)throttledStorage).isOverCapacity(arg_0);
            this.tracer = throttledStorage.tracer;
        }

        public Call<Void> accept(List<Span> spans) {
            ThrottledCall result = new ThrottledCall((Call<Void>)this.delegate.accept(spans), this.executor, this.limiter, this.limiterMetrics, this.isOverCapacity);
            return this.tracer != null ? new TracedCall(this.tracer, result, "throttled-accept-spans") : result;
        }

        public String toString() {
            return "Throttled(" + String.valueOf(this.delegate) + ")";
        }
    }
}

