/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.pulsar;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import zipkin2.collector.pulsar.PulsarCollector;

@ConfigurationProperties(value="zipkin.collector.pulsar")
class ZipkinPulsarCollectorProperties {
    private String serviceUrl;
    private String topic;
    private String subscriptionName;
    private Integer concurrency;
    private Map<String, Object> clientProps = new LinkedHashMap<String, Object>();
    private Map<String, Object> consumerProps = new LinkedHashMap<String, Object>();

    ZipkinPulsarCollectorProperties() {
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public Integer getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    public Map<String, Object> getClientProps() {
        return this.clientProps;
    }

    public void setClientProps(Map<String, Object> clientProps) {
        this.clientProps = clientProps;
    }

    public Map<String, Object> getConsumerProps() {
        return this.consumerProps;
    }

    public void setConsumerProps(Map<String, Object> consumerProps) {
        this.consumerProps = consumerProps;
    }

    public PulsarCollector.Builder toBuilder() {
        PulsarCollector.Builder result = PulsarCollector.builder();
        if (this.serviceUrl != null) {
            result.serviceUrl(this.serviceUrl);
        }
        if (this.topic != null) {
            result.topic(this.topic);
        }
        if (this.concurrency != null) {
            result.concurrency(this.concurrency);
        }
        if (this.subscriptionName != null) {
            result.subscriptionName(this.subscriptionName);
        }
        if (!this.clientProps.isEmpty()) {
            result.clientProps(this.clientProps);
        }
        if (!this.consumerProps.isEmpty()) {
            result.consumerProps(this.consumerProps);
        }
        return result;
    }
}

