/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.pulsar;

import io.micrometer.common.util.StringUtils;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.collector.pulsar.PulsarCollector;
import zipkin2.server.internal.pulsar.ZipkinPulsarCollectorProperties;
import zipkin2.storage.StorageComponent;

@ConditionalOnClass(value={PulsarCollector.class})
@Conditional(value={PulsarConditions.class})
@EnableConfigurationProperties(value={ZipkinPulsarCollectorProperties.class})
public class ZipkinPulsarCollectorConfiguration {
    @Bean(initMethod="start")
    PulsarCollector pulsar(ZipkinPulsarCollectorProperties properties, CollectorSampler sampler, CollectorMetrics metrics, StorageComponent storage) {
        return properties.toBuilder().sampler(sampler).metrics(metrics).storage(storage).build();
    }

    static final class PulsarConditions
    extends AllNestedConditions {
        PulsarConditions() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @Conditional(value={PulsarServiceUrlCondition.class})
        private static final class PulsarServiceUrlCondition
        implements Condition {
            private PulsarServiceUrlCondition() {
            }

            public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
                String serviceUrl = context.getEnvironment().getProperty("zipkin.collector.pulsar.service-url");
                return !StringUtils.isEmpty((String)serviceUrl);
            }
        }

        @ConditionalOnProperty(prefix="zipkin.collector.pulsar", name={"enabled"}, havingValue="true", matchIfMissing=true)
        private static final class PulsarEnabledCondition {
            private PulsarEnabledCondition() {
            }
        }
    }
}

