/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.banner;

import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.boot.Banner;
import org.springframework.boot.ansi.AnsiElement;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.boot.ansi.AnsiStyle;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StreamUtils;

public class ZipkinBanner
implements Banner {
    static final AnsiElement ZIPKIN_ORANGE = new AnsiElement(){

        public String toString() {
            return "38;5;208";
        }
    };

    public void printBanner(Environment environment, Class<?> sourceClass, PrintStream out) {
        try (InputStream stream = new ClassPathResource("zipkin.txt").getInputStream();){
            String banner = StreamUtils.copyToString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            banner = banner.replace("${AnsiOrange}", AnsiOutput.encode((AnsiElement)ZIPKIN_ORANGE));
            banner = banner.replace("${AnsiNormal}", AnsiOutput.encode((AnsiElement)AnsiStyle.NORMAL));
            out.println(banner);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

