/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.elasticsearch;

import brave.CurrentSpanCustomizer;
import brave.SpanCustomizer;
import brave.Tracing;
import brave.http.HttpTracing;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientFactoryBuilder;
import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.brave.BraveClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.server.internal.ConditionalOnSelfTracing;
import zipkin2.server.internal.elasticsearch.BasicAuthInterceptor;
import zipkin2.server.internal.elasticsearch.BasicCredentials;
import zipkin2.server.internal.elasticsearch.DynamicCredentialsFileLoader;
import zipkin2.server.internal.elasticsearch.HttpClientFactory;
import zipkin2.server.internal.elasticsearch.InitialEndpointSupplier;
import zipkin2.server.internal.elasticsearch.LazyHttpClientImpl;
import zipkin2.server.internal.elasticsearch.SslUtil;
import zipkin2.server.internal.elasticsearch.ZipkinElasticsearchStorageProperties;
import zipkin2.storage.StorageComponent;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ZipkinElasticsearchStorageProperties.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="elasticsearch")
@ConditionalOnMissingBean(value={StorageComponent.class})
public class ZipkinElasticsearchStorageConfiguration {
    static final String QUALIFIER = "zipkinElasticsearch";
    static final String USERNAME = "zipkin.storage.elasticsearch.username";
    static final String PASSWORD = "zipkin.storage.elasticsearch.password";
    static final String CREDENTIALS_FILE = "zipkin.storage.elasticsearch.credentials-file";
    static final String CREDENTIALS_REFRESH_INTERVAL = "zipkin.storage.elasticsearch.credentials-refresh-interval";

    @Bean
    @Qualifier(value="zipkinElasticsearch")
    @ConditionalOnMissingBean
    Supplier<EndpointGroup> esInitialEndpoints(SessionProtocol esSessionProtocol, ZipkinElasticsearchStorageProperties es) {
        return new InitialEndpointSupplier(esSessionProtocol, es.getHosts());
    }

    @Bean
    @Qualifier(value="zipkinElasticsearch")
    @ConditionalOnMissingBean
    SessionProtocol esSessionProtocol(ZipkinElasticsearchStorageProperties es) {
        if (es.getHosts() == null) {
            return SessionProtocol.HTTP;
        }
        if (es.getHosts().contains("https://")) {
            return SessionProtocol.HTTPS;
        }
        return SessionProtocol.HTTP;
    }

    @Bean
    @Qualifier(value="zipkinElasticsearch")
    @ConditionalOnMissingBean
    ClientFactory esClientFactory(ZipkinElasticsearchStorageProperties es, MeterRegistry meterRegistry) throws Exception {
        ClientFactoryBuilder builder = ClientFactory.builder();
        ZipkinElasticsearchStorageProperties.Ssl ssl = es.getSsl();
        if (ssl.isNoVerify()) {
            builder.tlsNoVerify();
        }
        if (ssl.getKeyStore() != null || ssl.getTrustStore() != null) {
            ZipkinElasticsearchStorageConfiguration.configureSsl(builder, ssl);
        }
        return builder.useHttp2Preface(false).connectTimeoutMillis((long)es.getTimeout().intValue()).meterRegistry(meterRegistry).build();
    }

    @Bean
    HttpClientFactory esHttpClientFactory(ZipkinElasticsearchStorageProperties es, @Qualifier(value="zipkinElasticsearch") ClientFactory factory, @Qualifier(value="zipkinElasticsearch") SessionProtocol protocol, @Qualifier(value="zipkinElasticsearch") List<Consumer<ClientOptionsBuilder>> options) {
        return new HttpClientFactory(es, factory, protocol, options);
    }

    @Bean
    @ConditionalOnMissingBean
    StorageComponent storage(ZipkinElasticsearchStorageProperties es, HttpClientFactory esHttpClientFactory, MeterRegistry meterRegistry, @Qualifier(value="zipkinElasticsearch") SessionProtocol protocol, @Qualifier(value="zipkinElasticsearch") Supplier<EndpointGroup> initialEndpoints, @Value(value="${zipkin.query.lookback:86400000}") int namesLookback, @Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId, @Value(value="${zipkin.storage.search-enabled:true}") boolean searchEnabled, @Value(value="${zipkin.storage.autocomplete-keys:}") List<String> autocompleteKeys, @Value(value="${zipkin.storage.autocomplete-ttl:3600000}") int autocompleteTtl, @Value(value="${zipkin.storage.autocomplete-cardinality:20000}") int autocompleteCardinality) {
        ElasticsearchStorage.Builder builder = es.toBuilder(new LazyHttpClientImpl(esHttpClientFactory, protocol, initialEndpoints, es, meterRegistry)).namesLookback(namesLookback).strictTraceId(strictTraceId).searchEnabled(searchEnabled).autocompleteKeys(autocompleteKeys).autocompleteTtl(autocompleteTtl).autocompleteCardinality(autocompleteCardinality);
        return builder.build();
    }

    @Bean
    @Qualifier(value="zipkinElasticsearch")
    @Conditional(value={BasicAuthRequired.class})
    Consumer<ClientOptionsBuilder> esBasicAuth(final @Qualifier(value="zipkinElasticsearch") BasicCredentials basicCredentials) {
        return new Consumer<ClientOptionsBuilder>(){

            @Override
            public void accept(ClientOptionsBuilder client) {
                client.decorator(delegate -> new BasicAuthInterceptor((HttpClient)delegate, basicCredentials));
            }

            public String toString() {
                return "BasicAuthCustomizer{basicCredentials=<redacted>}";
            }
        };
    }

    @Bean
    @Qualifier(value="zipkinElasticsearch")
    @Conditional(value={BasicAuthRequired.class})
    BasicCredentials basicCredentials(ZipkinElasticsearchStorageProperties es) {
        if (ZipkinElasticsearchStorageConfiguration.isEmpty(es.getUsername()) || ZipkinElasticsearchStorageConfiguration.isEmpty(es.getPassword())) {
            return new BasicCredentials();
        }
        return new BasicCredentials(es.getUsername(), es.getPassword());
    }

    @Bean(destroyMethod="shutdown")
    @Qualifier(value="zipkinElasticsearch")
    @Conditional(value={DynamicRefreshRequired.class})
    ScheduledExecutorService dynamicCredentialsScheduledExecutorService(@Value(value="${zipkin.storage.elasticsearch.credentials-file}") String credentialsFile, @Value(value="${zipkin.storage.elasticsearch.credentials-refresh-interval}") Integer credentialsRefreshInterval, @Qualifier(value="zipkinElasticsearch") BasicCredentials basicCredentials) throws IOException {
        ScheduledExecutorService ses = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("zipkin-load-es-credentials"));
        DynamicCredentialsFileLoader credentialsFileLoader = new DynamicCredentialsFileLoader(basicCredentials, credentialsFile);
        credentialsFileLoader.updateCredentialsFromProperties();
        ses.scheduleAtFixedRate(credentialsFileLoader, 0L, credentialsRefreshInterval.intValue(), TimeUnit.SECONDS);
        return ses;
    }

    @Bean
    @Qualifier(value="zipkinElasticsearch")
    @ConditionalOnSelfTracing
    Consumer<ClientOptionsBuilder> esTracing(Optional<HttpTracing> maybeHttpTracing) {
        if (!maybeHttpTracing.isPresent()) {
            return client -> {};
        }
        HttpTracing httpTracing = maybeHttpTracing.get().clientOf("elasticsearch");
        CurrentSpanCustomizer spanCustomizer = CurrentSpanCustomizer.create((Tracing)httpTracing.tracing());
        return arg_0 -> ZipkinElasticsearchStorageConfiguration.lambda$esTracing$2((SpanCustomizer)spanCustomizer, httpTracing, arg_0);
    }

    static ClientFactoryBuilder configureSsl(ClientFactoryBuilder builder, ZipkinElasticsearchStorageProperties.Ssl ssl) throws Exception {
        KeyManagerFactory keyManagerFactory = SslUtil.getKeyManagerFactory(ssl);
        TrustManagerFactory trustManagerFactory = SslUtil.getTrustManagerFactory(ssl);
        return builder.tlsCustomizer(sslContextBuilder -> {
            sslContextBuilder.keyManager(keyManagerFactory);
            sslContextBuilder.trustManager(trustManagerFactory);
        });
    }

    private static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    private static /* synthetic */ void lambda$esTracing$2(SpanCustomizer spanCustomizer, HttpTracing httpTracing, ClientOptionsBuilder client) {
        client.decorator((delegate, ctx, req) -> {
            String name;
            RequestLog log = ctx.log().partial();
            if (log.isAvailable(RequestLogProperty.NAME) && (name = log.name()) != null) {
                spanCustomizer.name(name);
            }
            return delegate.execute(ctx, req);
        });
        client.decorator(BraveClient.newDecorator((HttpTracing)httpTracing));
    }

    static final class DynamicRefreshRequired
    implements Condition {
        DynamicRefreshRequired() {
        }

        public boolean matches(ConditionContext condition, AnnotatedTypeMetadata ignored) {
            return !ZipkinElasticsearchStorageConfiguration.isEmpty(condition.getEnvironment().getProperty(ZipkinElasticsearchStorageConfiguration.CREDENTIALS_FILE));
        }
    }

    static final class BasicAuthRequired
    implements Condition {
        BasicAuthRequired() {
        }

        public boolean matches(ConditionContext condition, AnnotatedTypeMetadata ignored) {
            String userName = condition.getEnvironment().getProperty(ZipkinElasticsearchStorageConfiguration.USERNAME);
            String password = condition.getEnvironment().getProperty(ZipkinElasticsearchStorageConfiguration.PASSWORD);
            String credentialsFile = condition.getEnvironment().getProperty(ZipkinElasticsearchStorageConfiguration.CREDENTIALS_FILE);
            return !ZipkinElasticsearchStorageConfiguration.isEmpty(userName) && !ZipkinElasticsearchStorageConfiguration.isEmpty(password) || !ZipkinElasticsearchStorageConfiguration.isEmpty(credentialsFile);
        }
    }
}

