/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.cassandra;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import zipkin2.storage.cassandra.v1.CassandraStorage;

@ConfigurationProperties(value="zipkin.storage.cassandra")
class ZipkinCassandraStorageProperties
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String keyspace = "zipkin";
    private String contactPoints = "localhost";
    private String localDc;
    private int maxConnections = 8;
    private boolean ensureSchema = true;
    private boolean useSsl = false;
    private String username;
    private String password;
    private int spanTtl = (int)TimeUnit.DAYS.toSeconds(7L);
    private int indexTtl = (int)TimeUnit.DAYS.toSeconds(3L);
    private int indexCacheMax = 100000;
    private int indexCacheTtl = 60;
    private int indexFetchMultiplier = 3;

    ZipkinCassandraStorageProperties() {
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public String getContactPoints() {
        return this.contactPoints;
    }

    public void setContactPoints(String contactPoints) {
        this.contactPoints = contactPoints;
    }

    public String getLocalDc() {
        return this.localDc;
    }

    public void setLocalDc(String localDc) {
        this.localDc = "".equals(localDc) ? null : localDc;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public boolean isEnsureSchema() {
        return this.ensureSchema;
    }

    public void setEnsureSchema(boolean ensureSchema) {
        this.ensureSchema = ensureSchema;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = "".equals(username) ? null : username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = "".equals(password) ? null : password;
    }

    @Deprecated
    public int getSpanTtl() {
        return this.spanTtl;
    }

    @Deprecated
    public void setSpanTtl(int spanTtl) {
        this.spanTtl = spanTtl;
    }

    @Deprecated
    public int getIndexTtl() {
        return this.indexTtl;
    }

    @Deprecated
    public void setIndexTtl(int indexTtl) {
        this.indexTtl = indexTtl;
    }

    public int getIndexCacheMax() {
        return this.indexCacheMax;
    }

    public void setIndexCacheMax(int indexCacheMax) {
        this.indexCacheMax = indexCacheMax;
    }

    public int getIndexCacheTtl() {
        return this.indexCacheTtl;
    }

    public void setIndexCacheTtl(int indexCacheTtl) {
        this.indexCacheTtl = indexCacheTtl;
    }

    public int getIndexFetchMultiplier() {
        return this.indexFetchMultiplier;
    }

    public void setIndexFetchMultiplier(int indexFetchMultiplier) {
        this.indexFetchMultiplier = indexFetchMultiplier;
    }

    public CassandraStorage.Builder toBuilder() {
        return CassandraStorage.newBuilder().keyspace(this.keyspace).contactPoints(this.contactPoints).localDc(this.localDc).maxConnections(this.maxConnections).ensureSchema(this.ensureSchema).useSsl(this.useSsl).username(this.username).password(this.password).spanTtl(this.spanTtl).indexTtl(this.indexTtl).indexCacheMax(this.indexCacheMax).indexCacheTtl(this.indexCacheTtl).indexFetchMultiplier(this.indexFetchMultiplier);
    }
}

