/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import brave.Tracing;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.cors.CorsServiceBuilder;
import com.linecorp.armeria.server.file.HttpFileBuilder;
import com.linecorp.armeria.server.metric.PrometheusExpositionService;
import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.prometheus.client.CollectorRegistry;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.server.internal.ConditionalOnSelfTracing;
import zipkin2.server.internal.ConditionalOnThrottledStorage;
import zipkin2.server.internal.MicrometerCollectorMetrics;
import zipkin2.server.internal.ZipkinHttpCollector;
import zipkin2.server.internal.ZipkinQueryApiV2;
import zipkin2.server.internal.brave.TracingStorageComponent;
import zipkin2.server.internal.health.ZipkinHealthController;
import zipkin2.server.internal.prometheus.ZipkinMetricsController;
import zipkin2.server.internal.throttle.ThrottledStorageComponent;
import zipkin2.server.internal.throttle.ZipkinStorageThrottleProperties;
import zipkin2.storage.InMemoryStorage;
import zipkin2.storage.StorageComponent;

@Configuration
public class ZipkinServerConfiguration {
    public static final MediaType MEDIA_TYPE_ACTUATOR = MediaType.parse((String)"application/vnd.spring-boot.actuator.v2+json;charset=UTF-8");
    @Autowired(required=false)
    ZipkinQueryApiV2 httpQuery;
    @Autowired(required=false)
    ZipkinHttpCollector httpCollector;
    @Autowired(required=false)
    ZipkinHealthController healthController;
    @Autowired(required=false)
    ZipkinMetricsController metricsController;

    @Bean
    Consumer<MeterRegistry.Config> noActuatorMetrics() {
        return config -> config.meterFilter(MeterFilter.deny(id -> {
            String uri = id.getTag("uri");
            return uri != null && uri.startsWith("/actuator");
        }));
    }

    @Bean
    ArmeriaServerConfigurator serverConfigurator(Optional<CollectorRegistry> prometheusRegistry) {
        return sb -> {
            if (this.httpQuery != null) {
                sb.annotatedService((Object)this.httpQuery);
                sb.annotatedService("/zipkin", (Object)this.httpQuery);
            }
            if (this.httpCollector != null) {
                sb.annotatedService((Object)this.httpCollector);
            }
            if (this.healthController != null) {
                sb.annotatedService((Object)this.healthController);
            }
            if (this.metricsController != null) {
                sb.annotatedService((Object)this.metricsController);
            }
            prometheusRegistry.ifPresent(registry -> {
                PrometheusExpositionService prometheusService = new PrometheusExpositionService(registry);
                sb.service("/actuator/prometheus", (Service)prometheusService);
                sb.service("/prometheus", (Service)prometheusService);
            });
            sb.service("/actuator/info", (Service)ZipkinServerConfiguration.infoService(MEDIA_TYPE_ACTUATOR));
            sb.service("/info", (Service)ZipkinServerConfiguration.infoService(MediaType.JSON_UTF_8));
            sb.requestTimeout(Duration.ofSeconds(11L));
        };
    }

    @Bean
    Consumer<MeterRegistry.Config> noAdminMetrics() {
        return config -> config.meterFilter(MeterFilter.deny(id -> {
            String uri = id.getTag("uri");
            return uri != null && (uri.startsWith("/health") || uri.startsWith("/info") || uri.startsWith("/metrics") || uri.startsWith("/prometheus"));
        }));
    }

    @Order
    @Bean
    ArmeriaServerConfigurator corsConfigurator(@Value(value="${zipkin.query.allowed-origins:*}") String allowedOrigins) {
        CorsServiceBuilder corsBuilder = CorsServiceBuilder.forOrigins((String[])allowedOrigins.split(",")).allowRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST}).allowRequestHeaders(new CharSequence[]{HttpHeaderNames.CONTENT_TYPE, HttpHeaderNames.of((CharSequence)"X-GRPC-WEB")}).exposeHeaders(new CharSequence[]{"grpc-status", "grpc-message", "armeria.grpc.ThrowableProto-bin"});
        return builder -> builder.decorator(arg_0 -> ((CorsServiceBuilder)corsBuilder).build(arg_0));
    }

    @Bean
    @ConditionalOnMissingBean(value={CollectorSampler.class})
    CollectorSampler traceIdSampler(@Value(value="${zipkin.collector.sample-rate:1.0}") float rate) {
        return CollectorSampler.create((float)rate);
    }

    @Bean
    @ConditionalOnMissingBean(value={CollectorMetrics.class})
    CollectorMetrics metrics(MeterRegistry registry) {
        return new MicrometerCollectorMetrics(registry);
    }

    static HttpService infoService(MediaType mediaType) {
        return HttpFileBuilder.ofResource((String)"info.json").contentType(mediaType).build().asService();
    }

    static final class StorageTypeMemAbsentOrEmpty
    implements Condition {
        StorageTypeMemAbsentOrEmpty() {
        }

        public boolean matches(ConditionContext condition, AnnotatedTypeMetadata ignored) {
            String storageType = condition.getEnvironment().getProperty("zipkin.storage.type");
            if (storageType == null) {
                return true;
            }
            if ((storageType = storageType.trim()).isEmpty()) {
                return true;
            }
            return storageType.equals("mem");
        }
    }

    @Lazy
    @Configuration
    @Conditional(value={StorageTypeMemAbsentOrEmpty.class})
    @ConditionalOnMissingBean(value={StorageComponent.class})
    static class InMemoryConfiguration {
        InMemoryConfiguration() {
        }

        @Bean
        StorageComponent storage(@Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId, @Value(value="${zipkin.storage.search-enabled:true}") boolean searchEnabled, @Value(value="${zipkin.storage.mem.max-spans:500000}") int maxSpans, @Value(value="${zipkin.storage.autocomplete-keys:}") List<String> autocompleteKeys) {
            return InMemoryStorage.newBuilder().strictTraceId(strictTraceId).searchEnabled(searchEnabled).maxSpanCount(maxSpans).autocompleteKeys(autocompleteKeys).build();
        }
    }

    @Configuration
    @ConditionalOnSelfTracing
    static class TracingStorageComponentEnhancer
    implements BeanPostProcessor {
        @Autowired(required=false)
        Tracing tracing;

        TracingStorageComponentEnhancer() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (this.tracing == null) {
                return bean;
            }
            if (bean instanceof StorageComponent) {
                return new TracingStorageComponent(this.tracing, (StorageComponent)bean);
            }
            return bean;
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={ZipkinStorageThrottleProperties.class})
    @ConditionalOnThrottledStorage
    static class ThrottledStorageComponentEnhancer
    implements BeanPostProcessor,
    BeanFactoryAware {
        @Autowired(required=false)
        Tracing tracing;
        private BeanFactory beanFactory;

        ThrottledStorageComponentEnhancer() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (bean instanceof StorageComponent) {
                ZipkinStorageThrottleProperties throttleProperties = (ZipkinStorageThrottleProperties)this.beanFactory.getBean(ZipkinStorageThrottleProperties.class);
                return new ThrottledStorageComponent((StorageComponent)bean, (MeterRegistry)this.beanFactory.getBean(MeterRegistry.class), this.tracing, throttleProperties.getMinConcurrency(), throttleProperties.getMaxConcurrency(), throttleProperties.getMaxQueueSize());
            }
            return bean;
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }
    }
}

