/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.scribe;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.collector.scribe.ScribeCollector;
import zipkin2.storage.StorageComponent;

@Configuration
@ConditionalOnClass(value={ScribeCollector.class})
@ConditionalOnProperty(value={"zipkin.collector.scribe.enabled"}, havingValue="true")
public class ZipkinScribeCollectorConfiguration {
    @Bean(initMethod="start")
    ScribeCollector scribe(@Value(value="${zipkin.collector.scribe.category:zipkin}") String category, @Value(value="${zipkin.collector.scribe.port:9410}") int port, CollectorSampler sampler, CollectorMetrics metrics, StorageComponent storage) {
        return ScribeCollector.newBuilder().category(category).port(port).sampler(sampler).metrics(metrics).storage(storage).build();
    }
}

